/*
 * Decompiled with CFR 0.152.
 */
package com.pla.pladailyboss.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.FileReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.LevelResource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StatsReader {
    private static final Logger LOGGER = LogManager.getLogger();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getMobKillCountFromStatsFile(MinecraftServer server, ServerPlayer player, String mobId) {
        UUID playerUUID = player.m_142081_();
        Path statsFilePath = server.m_129843_(LevelResource.f_78175_).resolve(playerUUID + ".json");
        if (!Files.exists(statsFilePath, new LinkOption[0])) {
            return -1;
        }
        try (FileReader reader = new FileReader(statsFilePath.toFile());){
            JsonObject root = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            JsonObject stats = root.getAsJsonObject("stats");
            if (stats == null) {
                int n = -1;
                return n;
            }
            JsonObject killed = stats.getAsJsonObject("minecraft:killed");
            if (killed == null) {
                int n = 0;
                return n;
            }
            JsonElement killCountElement = killed.get(mobId);
            if (killCountElement == null) {
                int n = 0;
                return n;
            }
            int n = killCountElement.getAsInt();
            return n;
        }
        catch (Exception e) {
            LOGGER.warn("[DailyBoss] Failed to read stats file for player {}", (Object)player.m_6302_(), (Object)e);
            return -1;
        }
    }
}

