/*
 * Decompiled with CFR 0.152.
 */
package com.pla.pladailyboss.data;

import com.google.common.collect.Maps;
import com.pla.pladailyboss.enums.KeyEntityState;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;

public class KeyEntityManager
extends SavedData {
    public static final String DATA_NAME = "pla_key_entity_manager";
    private final Map<UUID, KeyEntityData> dataMap = Maps.newHashMap();
    public static final SavedData.Factory<KeyEntityManager> FACTORY = new SavedData.Factory(KeyEntityManager::new, KeyEntityManager::load, DataFixTypes.LEVEL);

    public static KeyEntityManager get(ServerLevel level) {
        return (KeyEntityManager)level.getDataStorage().computeIfAbsent(FACTORY, DATA_NAME);
    }

    public void update(UUID keyEntityUUID, UUID mobUUID, KeyEntityState state, long updatedTime, String summonedMobRL) {
        this.dataMap.put(keyEntityUUID, new KeyEntityData(mobUUID, state, updatedTime, summonedMobRL));
        this.setDirty();
    }

    public KeyEntityData get(UUID keyEntityUUID) {
        return this.dataMap.get(keyEntityUUID);
    }

    public void remove(UUID keyEntityUUID) {
        this.dataMap.remove(keyEntityUUID);
        this.setDirty();
    }

    public static KeyEntityManager load(CompoundTag tag, HolderLookup.Provider provider) {
        KeyEntityManager manager = new KeyEntityManager();
        ListTag list = tag.getList("KeyEntities", 10);
        for (Tag t : list) {
            CompoundTag entry = (CompoundTag)t;
            UUID keyUUID = entry.getUUID("KeyUUID");
            UUID mobUUID = entry.contains("MobUUID") ? entry.getUUID("MobUUID") : null;
            KeyEntityState state = KeyEntityState.valueOf(entry.getString("State"));
            long time = entry.getLong("UpdatedTime");
            String summonedMobRL = entry.getString("SummonedMobRL");
            manager.dataMap.put(keyUUID, new KeyEntityData(mobUUID, state, time, summonedMobRL));
        }
        return manager;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        ListTag list = new ListTag();
        for (Map.Entry<UUID, KeyEntityData> entry : this.dataMap.entrySet()) {
            CompoundTag nbt = new CompoundTag();
            nbt.putUUID("KeyUUID", entry.getKey());
            if (entry.getValue().mobUUID() != null) {
                nbt.putUUID("MobUUID", entry.getValue().mobUUID());
            }
            nbt.putString("State", entry.getValue().state().name());
            nbt.putLong("UpdatedTime", entry.getValue().updatedTime());
            nbt.putString("SummonedMobRL", entry.getValue().summonedMobRL());
            list.add((Object)nbt);
        }
        tag.put("KeyEntities", (Tag)list);
        return tag;
    }

    public record KeyEntityData(UUID mobUUID, KeyEntityState state, long updatedTime, String summonedMobRL) {
    }
}

