/*
 * Decompiled with CFR 0.152.
 */
package com.pla.pladailyboss.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.pla.pladailyboss.client.renderer.KeyEntityModel;
import com.pla.pladailyboss.client.renderer.ModModelLayers;
import com.pla.pladailyboss.entity.KeyEntity;
import com.pla.pladailyboss.enums.KeyEntityState;
import com.pla.pladailyboss.init.BlockInit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class KeyEntityRenderer
extends MobRenderer<KeyEntity, KeyEntityModel<KeyEntity>> {
    private final EntityRendererProvider.Context context;
    private static final Logger LOGGER = LogManager.getLogger();

    public KeyEntityRenderer(EntityRendererProvider.Context pContext) {
        super(pContext, new KeyEntityModel(pContext.m_174023_(ModModelLayers.KEY_ENTITY_LAYER)), 0.0f);
        this.context = pContext;
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull KeyEntity pEntity) {
        return new ResourceLocation("pladailyboss", "textures/entity/key_entity.png");
    }

    protected int getBlockLightLevel(KeyEntity pEntity, BlockPos pPos) {
        return 15;
    }

    public void render(@NotNull KeyEntity pEntity, float pEntityYaw, float pPartialTicks, @NotNull PoseStack pPoseStack, @NotNull MultiBufferSource pBuffer, int pPackedLight) {
        super.m_7392_((Mob)pEntity, pEntityYaw, pPartialTicks, pPoseStack, pBuffer, pPackedLight);
        if (pEntity.getState() == KeyEntityState.NORMAL) {
            Level level = pEntity.f_19853_;
            int packedLight = LightTexture.m_109885_((int)15, (int)15);
            double relativeGameTime = (float)level.m_46467_() + pPartialTicks;
            double offset = Math.sin(relativeGameTime / 10.0) / 20.0;
            pPoseStack.m_85836_();
            pPoseStack.m_85837_(0.0, 3.5 + offset, 0.0);
            pPoseStack.m_85845_(Vector3f.f_122227_.m_122240_(45.0f));
            float spin = (float)(relativeGameTime * 4.0 % 360.0);
            pPoseStack.m_85845_(Vector3f.f_122223_.m_122240_(spin));
            this.context.m_174025_().m_174269_(new ItemStack((ItemLike)BlockInit.SPINNING_BLOCK.get()), ItemTransforms.TransformType.FIXED, packedLight, OverlayTexture.f_118083_, pPoseStack, pBuffer, 0);
            pPoseStack.m_85849_();
        } else {
            long updatedTime = Long.parseLong(pEntity.getUpdatedStateTime());
            long remaining = Long.parseLong(pEntity.getRechargeCooldown()) - (System.currentTimeMillis() - updatedTime);
            if (remaining > 0L) {
                long seconds = remaining / 1000L % 60L;
                long minutes = remaining / 60000L % 60L;
                long hours = remaining / 3600000L;
                String timerText = String.format("%02d:%02d:%02d", hours, minutes, seconds);
                pPoseStack.m_85836_();
                pPoseStack.m_85837_(0.0, 3.5, 0.0);
                pPoseStack.m_85845_(Minecraft.m_91087_().m_91290_().m_114470_());
                pPoseStack.m_85841_(-0.02f, -0.02f, 0.02f);
                this.context.m_174028_().m_92811_(timerText, (float)(-this.context.m_174028_().m_92895_(timerText)) / 2.0f, 0.0f, 65280, false, pPoseStack.m_85850_().m_85861_(), pBuffer, false, 0, 0xF000F0);
                pPoseStack.m_85849_();
            }
        }
    }
}

