/*
 * Decompiled with CFR 0.152.
 */
package com.pla.pladailyboss.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.pla.pladailyboss.data.BossEntry;
import com.pla.pladailyboss.enums.BossEntryState;
import com.pla.pladailyboss.network.AskForDataMessage;
import com.pla.pladailyboss.network.NetworkHandler;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BossScreen
extends Screen {
    private static final Logger LOGGER = LogManager.getLogger();
    private static BossScreen instance;
    private static final Component TITLE;
    private static final String posterPath = "textures/gui/entity_posters/";
    private static final ResourceLocation BACKGROUND;
    private int currentPage;
    private int totalPages;
    private Button pageButton;
    private List<BossEntry> entityIdStrings;
    private static final int BOX_WIDTH = 60;
    private static final int BOX_HEIGHT = 80;
    private static final int GUI_WIDTH = 512;
    private static final int GUI_HEIGHT = 320;
    private static final int PADDING_HORIZONTAL = 5;
    private static final int PADDING_VERTICAL = 4;
    private static final int BUTTON_SIZE = 20;

    public BossScreen() {
        super(TITLE);
        instance = this;
        NetworkHandler.INSTANCE.sendToServer((Object)new AskForDataMessage());
    }

    public static BossScreen getInstance() {
        return instance;
    }

    public void setEntityIdStrings(List<BossEntry> entityIdStrings) {
        this.entityIdStrings = entityIdStrings;
        this.m_7856_();
    }

    protected void m_7856_() {
        if (this.entityIdStrings == null) {
            return;
        }
        super.m_7856_();
        int bgLeft = (this.f_96543_ - 512) / 2;
        int bgTop = (this.f_96544_ - 320) / 2;
        int bgRight = bgLeft + 512;
        int bgBottom = bgTop + 320;
        int bgWidth = 512;
        int maxColumns = Math.max(1, (bgWidth + 5) / 65);
        int maxRows = Math.max(1, 3);
        int entitiesPerPage = maxRows * maxColumns;
        this.totalPages = Math.max(1, (int)Math.ceil((double)this.entityIdStrings.size() / (double)entitiesPerPage));
        this.currentPage = Math.max(1, Math.min(this.currentPage, this.totalPages));
        this.m_142416_((GuiEventListener)new Button(bgLeft + (bgWidth - 100) / 2, bgTop - 20, 100, 20, (Component)new TextComponent("Daily Boss List"), this::doNothing));
        this.m_142416_((GuiEventListener)new Button(bgRight - 80 - 5, bgBottom + 2, 20, 20, (Component)new TextComponent("<"), this::handlePrevPage));
        this.pageButton = (Button)this.m_142416_((GuiEventListener)new Button(bgRight - 60 - 5, bgBottom + 2, 40, 20, (Component)new TextComponent(this.currentPage + "/" + this.totalPages), this::doNothing));
        this.m_142416_((GuiEventListener)new Button(bgRight - 20 - 5, bgBottom + 2, 20, 20, (Component)new TextComponent(">"), this::handleNextPage));
    }

    public boolean textureExists(ResourceLocation location) {
        ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
        try {
            resourceManager.m_142591_(location);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private void drawEntityCard(PoseStack poseStack, int x, int y, BossEntry bossEntry) {
        String prefixImage = bossEntry.state == BossEntryState.DEFEAT ? "_enabled.png" : (bossEntry.state == BossEntryState.NOT_INSTALLED ? "_corrupted" : "_disabled.png");
        String entityPoster = posterPath + bossEntry.name.replace(":", "/") + "/" + bossEntry.name.split(":")[1] + prefixImage;
        ResourceLocation entityCardTexture = new ResourceLocation("pladailyboss", entityPoster);
        if (!this.textureExists(entityCardTexture)) {
            entityCardTexture = new ResourceLocation("pladailyboss", "textures/gui/entity_posters/not_found/not_found" + prefixImage);
        }
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)entityCardTexture);
        BossScreen.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)60, (int)80, (int)60, (int)80);
    }

    public void m_6305_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        int bgLeft = (this.f_96543_ - 512) / 2;
        int bgTop = (this.f_96544_ - 320) / 2;
        int bgWidth = 512;
        int bgHeight = 320;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
        BossScreen.m_93133_((PoseStack)poseStack, (int)bgLeft, (int)bgTop, (float)0.0f, (float)0.0f, (int)bgWidth, (int)bgHeight, (int)bgWidth, (int)bgHeight);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        if (this.entityIdStrings == null) {
            return;
        }
        int usableWidth = 502;
        int maxColumns = usableWidth / 65;
        int totalWidth = maxColumns * 60 + (maxColumns - 1) * 5;
        int startX = bgLeft + (512 - totalWidth) / 2;
        int usableHeight = 312;
        int maxRows = usableHeight / 84;
        int totalHeight = maxRows * 80 + (maxRows - 1) * 4;
        int startY = bgTop + (320 - totalHeight) / 2;
        int entitiesPerPage = maxRows * maxColumns;
        this.totalPages = Math.max(1, (int)Math.ceil((double)this.entityIdStrings.size() / (double)entitiesPerPage));
        this.currentPage = Math.max(1, Math.min(this.currentPage, this.totalPages));
        int startIndex = (this.currentPage - 1) * entitiesPerPage;
        int endIndex = Math.min(startIndex + entitiesPerPage, this.entityIdStrings.size());
        List<BossEntry> entitiesToRender = this.entityIdStrings.subList(startIndex, endIndex);
        for (int i = 0; i < entitiesToRender.size(); ++i) {
            int col = i % maxColumns;
            int row = i / maxColumns;
            int x = startX + col * 65;
            int y = startY + row * 85;
            this.drawEntityCard(poseStack, x, y, entitiesToRender.get(i));
        }
    }

    private void handlePrevPage(Button button) {
        if (this.currentPage > 1) {
            --this.currentPage;
        }
        this.pageButton.m_93666_((Component)new TextComponent(this.currentPage + "/" + this.totalPages));
    }

    private void handleNextPage(Button button) {
        if (this.currentPage < this.totalPages) {
            ++this.currentPage;
        }
        this.pageButton.m_93666_((Component)new TextComponent(this.currentPage + "/" + this.totalPages));
    }

    private void doNothing(Button button) {
    }

    static {
        TITLE = new TranslatableComponent("gui.pladailyboss.boss_screen");
        BACKGROUND = new ResourceLocation("pladailyboss", "textures/gui/screen_background.png");
    }
}

