/*
 * Decompiled with CFR 0.152.
 */
package com.pla.pladailyboss.network;

import com.pla.pladailyboss.client.screen.BossScreen;
import com.pla.pladailyboss.data.BossEntry;
import com.pla.pladailyboss.enums.BossEntryState;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class BossListMessage {
    private final List<BossEntry> bossList;

    public BossListMessage(List<BossEntry> bossList) {
        this.bossList = bossList;
    }

    public List<BossEntry> getBossList() {
        return this.bossList;
    }

    public static void encode(BossListMessage msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.bossList.size());
        for (BossEntry entry : msg.bossList) {
            buf.m_130070_(entry.name);
            buf.m_130068_((Enum)entry.state);
            buf.m_130070_(entry.message);
        }
    }

    public static BossListMessage decode(FriendlyByteBuf buf) {
        int size = buf.readInt();
        ArrayList<BossEntry> bossList = new ArrayList<BossEntry>();
        for (int i = 0; i < size; ++i) {
            String name = buf.m_130277_();
            BossEntryState state = (BossEntryState)buf.m_130066_(BossEntryState.class);
            String message = buf.m_130277_();
            bossList.add(new BossEntry(name, state, message));
        }
        return new BossListMessage(bossList);
    }

    public static void handle(BossListMessage msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            BossScreen screen = BossScreen.getInstance();
            if (screen != null) {
                screen.setEntityIdStrings(msg.getBossList());
            }
        }));
        ctx.get().setPacketHandled(true);
    }
}

