/*
 * Decompiled with CFR 0.152.
 */
package com.pla.pladailyboss.compat;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.entity.BossSpawnHandler;
import com.brutalbosses.entity.BossType;
import com.brutalbosses.entity.BossTypeManager;
import com.brutalbosses.entity.capability.BossCapEntity;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class BrutalBossesCompat
extends BossSpawnHandler {
    private static ConcurrentLinkedQueue<Tuple<BlockPos, BossType>> spawns = new ConcurrentLinkedQueue();

    @Nullable
    public static Mob spawnBossAndReturn(ServerLevelAccessor world, BlockPos pos, BossType bossType) {
        try {
            Mob boss;
            spawns.add((Tuple<BlockPos, BossType>)new Tuple((Object)pos, (Object)bossType));
            if (spawns.size() > 20) {
                spawns.poll();
            }
            if ((boss = bossType.createBossEntity((Level)world.getLevel())) == null) {
                return null;
            }
            BlockPos spawnPos = BrutalBossesCompat.findSpawnPosForBoss((ServerLevelAccessor)world, (Entity)boss, (BlockPos)pos);
            if (spawnPos == null) {
                boss.remove(Entity.RemovalReason.DISCARDED);
                return null;
            }
            boss.setPos((double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5);
            ((BossCapEntity)boss).getBossCap().setSpawnPos(pos);
            if (!boss.isRemoved()) {
                world.addFreshEntity((Entity)boss);
            }
            return boss;
        }
        catch (Exception spawnException) {
            BrutalBosses.LOGGER.error("Boss: " + String.valueOf(bossType.getID()) + " failed to spawn! Error:", (Throwable)spawnException);
            return null;
        }
    }

    @Nullable
    public static Mob spawnRandomBossAndReturn(ServerLevel world, BlockPos pos) {
        ArrayList list = new ArrayList(BossTypeManager.instance.bosses.values());
        BossType bossType = (BossType)list.get(BrutalBosses.rand.nextInt(list.size()));
        return BrutalBossesCompat.spawnBossAndReturn((ServerLevelAccessor)world, pos, bossType);
    }
}

