/*
 * Decompiled with CFR 0.152.
 */
package com.pla.pladailyboss.entity;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.pla.pladailyboss.compat.BrutalBossesCompat;
import com.pla.pladailyboss.compat.IronsSpellBooksCompat;
import com.pla.pladailyboss.config.PlaDailyBossConfig;
import com.pla.pladailyboss.data.BossLootData;
import com.pla.pladailyboss.data.DailyBossLoader;
import com.pla.pladailyboss.enums.KeyEntityState;
import com.pla.pladailyboss.event.RewardEvent;
import com.pla.pladailyboss.ftb.ClaimChunkHelper;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class KeyEntity
extends Mob {
    private UUID summonedMobId;
    private String summonedMobRL;
    private KeyEntityState state;
    private long updatedStateTime;
    private final long rechargeCooldown = (Long)PlaDailyBossConfig.COOL_DOWN.get();
    private static final Random RANDOM = new Random();
    private static final Logger LOGGER = LogManager.getLogger();
    private static final EntityDataAccessor<Integer> DATA_STATE = SynchedEntityData.defineId(KeyEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Long> UPDATED_STATE_TIME = SynchedEntityData.defineId(KeyEntity.class, (EntityDataSerializer)EntityDataSerializers.LONG);
    private static final EntityDataAccessor<Long> RECHARGE_COOLDOWN = SynchedEntityData.defineId(KeyEntity.class, (EntityDataSerializer)EntityDataSerializers.LONG);

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_STATE, (Object)KeyEntityState.NORMAL.ordinal());
        builder.define(UPDATED_STATE_TIME, (Object)0L);
        builder.define(RECHARGE_COOLDOWN, (Object)0L);
    }

    public KeyEntity(EntityType<? extends Mob> type, Level level) {
        super(type, level);
        this.noPhysics = true;
        this.setBoundingBox(new AABB(this.getX(), this.getY(), this.getZ(), this.getX(), this.getY(), this.getZ()));
        this.entityData.set(RECHARGE_COOLDOWN, (Object)this.rechargeCooldown);
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        if (this.summonedMobId != null) {
            pCompound.putUUID("SummonedMobUUID", this.summonedMobId);
        }
        pCompound.putString("SummonedMobRL", this.summonedMobRL);
        pCompound.putString("KeyState", this.state.name());
        pCompound.putLong("UpdatedStateTime", this.updatedStateTime);
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        if (pCompound.contains("SummonedMobUUID")) {
            try {
                this.summonedMobId = pCompound.getUUID("SummonedMobUUID");
            }
            catch (Exception e) {
                this.summonedMobId = null;
            }
        } else {
            this.summonedMobId = null;
        }
        String string = this.summonedMobRL = pCompound.contains("SummonedMobRL") ? pCompound.getString("SummonedMobRL") : "";
        if (pCompound.contains("KeyState")) {
            try {
                this.state = KeyEntityState.valueOf(pCompound.getString("KeyState"));
            }
            catch (IllegalArgumentException e) {
                this.state = KeyEntityState.NORMAL;
            }
        } else {
            this.state = KeyEntityState.NORMAL;
        }
        this.updatedStateTime = pCompound.contains("UpdatedStateTime") ? pCompound.getLong("UpdatedStateTime") : 0L;
        this.entityData.set(DATA_STATE, (Object)this.state.ordinal());
        this.entityData.set(UPDATED_STATE_TIME, (Object)this.updatedStateTime);
    }

    public void tick() {
        super.tick();
        Player player = this.level().getNearestPlayer((Entity)this, 10.0);
        if (player != null) {
            this.lookAt(EntityAnchorArgument.Anchor.EYES, player.position());
        }
        if (!this.level().isClientSide) {
            if (this.state == KeyEntityState.DISAPPEARED && !this.isInvisible()) {
                this.setInvisible(true);
                this.setSilent(true);
                this.noPhysics = true;
            }
            if (this.state == KeyEntityState.DISABLED) {
                long now = System.currentTimeMillis();
                if (now - this.updatedStateTime >= this.rechargeCooldown) {
                    this.setState(KeyEntityState.NORMAL);
                }
                return;
            }
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.ENCHANT, this.getX(), this.getY() + 3.5, this.getZ(), 2, 0.2, 0.2, 0.2, 0.0);
            if (this.summonedMobId != null) {
                Entity entity = ((ServerLevel)this.level()).getEntity(this.summonedMobId);
                if (entity instanceof Mob) {
                    long now;
                    Mob mob = (Mob)entity;
                    double distance = this.distanceToSqr((Entity)mob);
                    if (distance > 900.0) {
                        mob.teleportTo(this.getX(), this.getY() + 2.5, this.getZ());
                    }
                    if ((now = System.currentTimeMillis()) - this.updatedStateTime >= this.rechargeCooldown) {
                        mob.discard();
                        this.summonedMobId = null;
                        this.setState(KeyEntityState.NORMAL);
                    }
                } else if (this.summonedMobId.equals(new UUID(0L, 0L))) {
                    AABB area = new AABB(this.blockPosition()).inflate(2.5);
                    List nearby = this.level().getEntities((Entity)this, area, realMob -> Objects.equals(BuiltInRegistries.ENTITY_TYPE.getKey((Object)realMob.getType()), ResourceLocation.fromNamespaceAndPath((String)"irons_spellbooks", (String)"dead_king")));
                    if (!nearby.isEmpty()) {
                        this.summonedMobId = ((Entity)nearby.get(0)).getUUID();
                    }
                } else {
                    String tempSummonedMobRL = this.summonedMobRL;
                    this.summonedMobRL = "";
                    this.summonedMobId = null;
                    this.setState(KeyEntityState.DISABLED);
                    BossLootData data = DailyBossLoader.BOSS_LOOT_TABLES.get(tempSummonedMobRL);
                    List<Object> lootTables = data != null ? data.lootTables : Collections.emptyList();
                    for (int i = 0; i < 5; ++i) {
                        String lootTableId = (String)lootTables.get(RANDOM.nextInt(lootTables.size()));
                        String[] parts = lootTableId.split(":", 2);
                        RewardEvent.dropLoot((ServerLevel)this.level(), ResourceLocation.fromNamespaceAndPath((String)parts[0], (String)parts[1]), this.getOnPos(), 1);
                    }
                    int xpAmount = 1395;
                    this.level().addFreshEntity((Entity)new ExperienceOrb(this.level(), (double)this.getOnPos().getX() + 0.5, (double)(this.getOnPos().getY() + 1), (double)this.getOnPos().getZ() + 0.5, xpAmount));
                }
            }
        }
    }

    private void entityClaimChunk(@NotNull Player player) {
        ClaimChunkHelper claimChunkHelper = null;
        try {
            claimChunkHelper = ClaimChunkHelper.getInstance(player.getServer());
            claimChunkHelper.claimChunk(player.createCommandSourceStack(), (ServerPlayer)player, this.getOnPos());
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean spawnBoss(@NotNull Player player) {
        Entity entity;
        ResourceLocation mobRL;
        List<String> mobIds = DailyBossLoader.getListBasedOnKilledMob((ServerPlayer)player, player.getServer());
        if (mobIds.isEmpty()) {
            player.displayClientMessage((Component)Component.literal((String)"You're too weak. Come back after you've defeated at least one boss or mini-boss.").withStyle(style -> style.withColor(0xFFFF00)), true);
            return false;
        }
        String selectedMobId = !((String)PlaDailyBossConfig.FORCE_SPAWN.get()).isEmpty() ? (String)PlaDailyBossConfig.FORCE_SPAWN.get() : mobIds.get(RANDOM.nextInt(mobIds.size()));
        if (Objects.equals(selectedMobId, "brutalbosses:randomboss")) {
            this.summonedMobId = Objects.requireNonNull(BrutalBossesCompat.spawnRandomBossAndReturn((ServerLevel)this.level(), this.getOnPos())).getUUID();
            this.level().playSound(null, this.blockPosition(), SoundEvents.END_PORTAL_FRAME_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.summonedMobRL = selectedMobId;
            this.setState(KeyEntityState.DISAPPEARED);
            this.entityClaimChunk(player);
            return true;
        }
        if (Objects.equals(selectedMobId, "irons_spellbooks:dead_king")) {
            mobRL = ResourceLocation.fromNamespaceAndPath((String)"irons_spellbooks", (String)"dead_king_corpse");
        } else {
            String[] parts = selectedMobId.split(":", 2);
            mobRL = ResourceLocation.fromNamespaceAndPath((String)parts[0], (String)parts[1]);
        }
        EntityType type = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(mobRL);
        boolean usedCustomNBT = false;
        if (type != null && (entity = type.create(this.level())) instanceof Mob) {
            CompoundTag tag;
            Mob mob = (Mob)entity;
            BossLootData lootData = DailyBossLoader.BOSS_LOOT_TABLES.get(selectedMobId);
            if (lootData != null && lootData.nbt != null && !lootData.nbt.entrySet().isEmpty() && !(tag = CompoundTag.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)lootData.nbt).resultOrPartial(msg -> LOGGER.warn("[Daily Boss] Failed to parse NBT for mob {}: {}", (Object)selectedMobId, msg)).orElse(new CompoundTag())).isEmpty()) {
                tag.putString("id", selectedMobId);
                Entity loaded = EntityType.loadEntityRecursive((CompoundTag)tag, (Level)this.level(), e -> {
                    e.setPos(this.getX(), this.getY(), this.getZ());
                    return e;
                });
                if (loaded != null) {
                    if (loaded instanceof Mob) {
                        Mob loadedMob = (Mob)loaded;
                        loadedMob.setPersistenceRequired();
                        loadedMob.setTarget((LivingEntity)player);
                        this.level().addFreshEntity((Entity)loadedMob);
                        this.summonedMobId = loadedMob.getUUID();
                        usedCustomNBT = true;
                    } else {
                        LOGGER.warn("[DailyBoss] Loaded entity from NBT is not a mob: {}", (Object)BuiltInRegistries.ENTITY_TYPE.getKey((Object)loaded.getType()));
                    }
                } else {
                    LOGGER.warn("[DailyBoss] No entity was created from NBT for mob {}", (Object)selectedMobId);
                }
            }
            if (!usedCustomNBT) {
                if (Objects.equals(selectedMobId, "irons_spellbooks:fire_boss")) {
                    mob = IronsSpellBooksCompat.spawnIronBoss((LivingEntity)this, player);
                } else {
                    mob.setPos(this.getX(), this.getY(), this.getZ());
                    mob.setPersistenceRequired();
                    mob.setTarget((LivingEntity)player);
                    this.level().addFreshEntity((Entity)mob);
                }
                if (Objects.equals(selectedMobId, "irons_spellbooks:dead_king")) {
                    mob.interact(player, InteractionHand.OFF_HAND);
                    this.summonedMobId = new UUID(0L, 0L);
                } else {
                    this.summonedMobId = mob.getUUID();
                }
            }
            this.level().playSound(null, this.blockPosition(), SoundEvents.END_PORTAL_FRAME_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.summonedMobRL = selectedMobId;
            this.setState(KeyEntityState.DISAPPEARED);
            this.entityClaimChunk(player);
            return true;
        }
        return false;
    }

    @NotNull
    protected InteractionResult mobInteract(@NotNull Player player, @NotNull InteractionHand hand) {
        if (!this.level().isClientSide && hand == InteractionHand.MAIN_HAND) {
            if (this.state == KeyEntityState.DISABLED) {
                long remaining = this.rechargeCooldown - (System.currentTimeMillis() - this.updatedStateTime);
                long seconds = remaining / 1000L % 60L;
                long minutes = remaining / 60000L % 60L;
                long hours = remaining / 3600000L;
                player.displayClientMessage((Component)Component.literal((String)("Come back after " + hours + "h " + minutes + "m " + seconds + "s")).withStyle(style -> style.withColor(0xFFFF00)), true);
                return InteractionResult.PASS;
            }
            if (this.state == KeyEntityState.DISAPPEARED) {
                return InteractionResult.PASS;
            }
            if (this.spawnBoss(player)) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        return super.mobInteract(player, hand);
    }

    public KeyEntityState getState() {
        if (this.level().isClientSide) {
            return KeyEntityState.values()[(Integer)this.entityData.get(DATA_STATE)];
        }
        return this.state;
    }

    public Long getUpdatedStateTime() {
        if (this.level().isClientSide) {
            return (Long)this.entityData.get(UPDATED_STATE_TIME);
        }
        return this.updatedStateTime;
    }

    public Long getRechargeCooldown() {
        if (this.level().isClientSide) {
            return (Long)this.entityData.get(RECHARGE_COOLDOWN);
        }
        return this.rechargeCooldown;
    }

    public void setState(KeyEntityState newState) {
        this.state = newState;
        this.entityData.set(DATA_STATE, (Object)newState.ordinal());
        if (newState == KeyEntityState.DISAPPEARED) {
            this.setInvisible(true);
            this.setSilent(true);
            this.noPhysics = true;
            this.updatedStateTime = System.currentTimeMillis();
            this.entityData.set(UPDATED_STATE_TIME, (Object)this.updatedStateTime);
            this.refreshDimensions();
        } else {
            this.setInvisible(false);
            this.setSilent(false);
            this.noPhysics = false;
            this.refreshDimensions();
        }
        if (!this.level().isClientSide) {
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.END_ROD, this.getX(), this.getY() + 1.0, this.getZ(), 20, 0.3, 0.3, 0.3, 0.01);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 0.0);
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        return false;
    }

    public boolean isInvulnerableTo(@NotNull DamageSource source) {
        return true;
    }

    public void knockback(double strength, double x, double z) {
    }

    public boolean isPushable() {
        return false;
    }

    public boolean isNoAi() {
        return true;
    }

    protected void doPush(@NotNull Entity other) {
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public void remove(@NotNull Entity.RemovalReason reason) {
        if (reason == Entity.RemovalReason.KILLED || reason == Entity.RemovalReason.DISCARDED) {
            return;
        }
        super.remove(reason);
    }

    public void die(@NotNull DamageSource cause) {
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    @NotNull
    public AABB getBoundingBoxForCulling() {
        return new AABB(this.getX(), this.getY(), this.getZ(), this.getX(), this.getY(), this.getZ());
    }

    public boolean canBeSeenAsEnemy() {
        return false;
    }

    public boolean isAttackable() {
        return false;
    }

    public boolean isPickable() {
        return this.state != KeyEntityState.DISAPPEARED;
    }
}

