/*
 * Decompiled with CFR 0.152.
 */
package com.pla.pladailyboss.data;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.pla.pladailyboss.config.PlaDailyBossConfig;
import com.pla.pladailyboss.data.BossEntry;
import com.pla.pladailyboss.data.BossLootData;
import com.pla.pladailyboss.data.StatsReader;
import com.pla.pladailyboss.enums.BossEntryState;
import com.pla.pladailyboss.enums.BossLootDataState;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.stats.Stats;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DailyBossLoader
extends SimpleJsonResourceReloadListener {
    public static final Map<String, BossLootData> BOSS_LOOT_TABLES = new HashMap<String, BossLootData>();
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new Gson();

    public DailyBossLoader() {
        super(GSON, "dailyboss");
    }

    private boolean parseIsWater(JsonElement element) {
        if (!element.isJsonObject()) {
            return false;
        }
        JsonObject obj = element.getAsJsonObject();
        if (!obj.has("is_water")) {
            return false;
        }
        JsonElement w = obj.get("is_water");
        return w.isJsonPrimitive() && w.getAsJsonPrimitive().isBoolean() && w.getAsBoolean();
    }

    private List<String> parseLootTables(JsonElement element) {
        ArrayList<String> lootTables = new ArrayList<String>();
        if (!element.isJsonObject()) {
            return lootTables;
        }
        JsonObject obj = element.getAsJsonObject();
        JsonElement lootElement = obj.get("loot_table");
        if (lootElement == null) {
            return lootTables;
        }
        if (lootElement.isJsonArray()) {
            for (JsonElement e : lootElement.getAsJsonArray()) {
                lootTables.add(e.getAsString());
            }
        } else if (lootElement.isJsonPrimitive()) {
            lootTables.add(lootElement.getAsString());
        }
        return lootTables;
    }

    protected void apply(Map<ResourceLocation, JsonElement> objectMap, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
        BOSS_LOOT_TABLES.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : objectMap.entrySet()) {
            ResourceLocation id = entry.getKey();
            JsonElement element = entry.getValue();
            List<String> lootTables = this.parseLootTables(element);
            BossLootDataState bossLootDataState = BossLootDataState.AVAILABLE;
            String[] splitPath = id.m_135815_().split("/", 2);
            if (splitPath.length < 2) {
                LOGGER.warn("[DailyBoss] Skipping malformed resource location: {}", (Object)id);
                continue;
            }
            String namespace = splitPath[0];
            String mobPath = splitPath[1];
            if (!ModList.get().isLoaded(namespace)) {
                bossLootDataState = BossLootDataState.UN_AVAILABLE;
            }
            String mobId = String.format("%s:%s", namespace, mobPath);
            JsonObject obj = element.getAsJsonObject();
            JsonObject nbt = obj.has("nbt") && obj.get("nbt").isJsonObject() ? obj.getAsJsonObject("nbt") : new JsonObject();
            List<String> phases = this.parsePhases(element);
            boolean isWater = this.parseIsWater(element);
            BOSS_LOOT_TABLES.put(mobId, new BossLootData(lootTables, nbt, bossLootDataState, phases, isWater));
        }
    }

    private List<String> parsePhases(JsonElement element) {
        ArrayList<String> phases = new ArrayList<String>();
        if (!element.isJsonObject()) {
            return phases;
        }
        JsonObject obj = element.getAsJsonObject();
        JsonElement p = obj.get("phases");
        if (p == null) {
            return phases;
        }
        if (p.isJsonArray()) {
            JsonArray arr = p.getAsJsonArray();
            for (JsonElement e : arr) {
                if (!e.isJsonPrimitive()) continue;
                phases.add(e.getAsString());
            }
        } else if (p.isJsonPrimitive()) {
            phases.add(p.getAsString());
        }
        return phases;
    }

    public static List<String> getListBasedOnKilledMob(ServerPlayer player, MinecraftServer server) {
        return BOSS_LOOT_TABLES.entrySet().stream().filter(entry -> ((BossLootData)entry.getValue()).state == BossLootDataState.AVAILABLE).map(Map.Entry::getKey).filter(mobId -> {
            int inMemoryKillCount;
            if (((Boolean)PlaDailyBossConfig.FORCE_UNLOCK.get()).booleanValue()) {
                return true;
            }
            if (Objects.equals(mobId, "brutalbosses:randomboss")) {
                return true;
            }
            EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(mobId));
            if (entityType != null && (inMemoryKillCount = player.m_8951_().m_13015_(Stats.f_12986_.m_12902_((Object)entityType))) > 0) {
                return true;
            }
            int fromFile = StatsReader.getMobKillCountFromStatsFile(server, player, mobId);
            return fromFile > 0;
        }).collect(Collectors.toList());
    }

    public static List<BossEntry> getBossEntriesForPlayer(ServerPlayer player, MinecraftServer server) {
        return BOSS_LOOT_TABLES.entrySet().stream().map(entry -> {
            String mobIdStr = (String)entry.getKey();
            BossLootData data = (BossLootData)entry.getValue();
            if (data.state == BossLootDataState.UN_AVAILABLE) {
                return new BossEntry(mobIdStr, BossEntryState.NOT_INSTALLED);
            }
            if (Objects.equals(mobIdStr, "brutalbosses:randomboss")) {
                return new BossEntry(mobIdStr, BossEntryState.DEFEATED);
            }
            ResourceLocation mobId = new ResourceLocation(mobIdStr);
            EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(mobId);
            if (entityType == null) {
                return new BossEntry(mobIdStr, BossEntryState.NOT_INSTALLED);
            }
            if (((Boolean)PlaDailyBossConfig.FORCE_UNLOCK.get()).booleanValue()) {
                return new BossEntry(mobIdStr, BossEntryState.DEFEATED);
            }
            int inMemoryKillCount = player.m_8951_().m_13015_(Stats.f_12986_.m_12902_((Object)entityType));
            if (inMemoryKillCount > 0) {
                return new BossEntry(mobIdStr, BossEntryState.DEFEATED);
            }
            int fromFile = StatsReader.getMobKillCountFromStatsFile(server, player, mobIdStr);
            if (fromFile > 0) {
                return new BossEntry(mobIdStr, BossEntryState.DEFEATED);
            }
            return new BossEntry(mobIdStr, BossEntryState.UNDEFEATED);
        }).sorted(Comparator.comparingInt(entry -> DailyBossLoader.getSortPriority(entry.state))).collect(Collectors.toList());
    }

    private static int getSortPriority(BossEntryState state) {
        return switch (state) {
            default -> throw new IncompatibleClassChangeError();
            case BossEntryState.DEFEATED -> 0;
            case BossEntryState.UNDEFEATED -> 1;
            case BossEntryState.NOT_INSTALLED -> 2;
        };
    }
}

