/*
 * Decompiled with CFR 0.152.
 */
package com.pla.pladailyboss.entity;

import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.pla.pladailyboss.compat.BrutalBossesCompat;
import com.pla.pladailyboss.config.PlaDailyBossConfig;
import com.pla.pladailyboss.data.BossLootData;
import com.pla.pladailyboss.data.DailyBossLoader;
import com.pla.pladailyboss.enums.KeyEntityState;
import com.pla.pladailyboss.event.RewardEvent;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class KeyEntity
extends Mob {
    private UUID summonedMobId;
    private String summonedMobRL;
    private KeyEntityState state;
    private long updatedStateTime;
    private boolean multiPhaseBoss = false;
    private final long rechargeCooldown = (Long)PlaDailyBossConfig.COOL_DOWN.get();
    private static final Random RANDOM = new Random();
    private static final Logger LOGGER = LogManager.getLogger();
    private static final EntityDataAccessor<Integer> DATA_STATE = SynchedEntityData.m_135353_(KeyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> UPDATED_STATE_TIME = SynchedEntityData.m_135353_(KeyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> RECHARGE_COOLDOWN = SynchedEntityData.m_135353_(KeyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_STATE, (Object)KeyEntityState.NORMAL.ordinal());
        this.f_19804_.m_135372_(UPDATED_STATE_TIME, (Object)"");
        this.f_19804_.m_135372_(RECHARGE_COOLDOWN, (Object)"");
    }

    public KeyEntity(EntityType<? extends Mob> type, Level level) {
        super(type, level);
        this.f_19794_ = true;
        this.m_20011_(new AABB(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_20185_(), this.m_20186_(), this.m_20189_()));
        this.f_19804_.m_135381_(RECHARGE_COOLDOWN, (Object)String.valueOf(this.rechargeCooldown));
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        if (this.summonedMobId != null) {
            pCompound.m_128362_("SummonedMobUUID", this.summonedMobId);
        }
        pCompound.m_128359_("SummonedMobRL", this.summonedMobRL);
        pCompound.m_128359_("KeyState", this.state.name());
        pCompound.m_128356_("UpdatedStateTime", this.updatedStateTime);
        pCompound.m_128379_("MultiPhaseBoss", this.multiPhaseBoss);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("SummonedMobUUID")) {
            try {
                this.summonedMobId = pCompound.m_128342_("SummonedMobUUID");
            }
            catch (Exception e) {
                this.summonedMobId = null;
            }
        } else {
            this.summonedMobId = null;
        }
        String string = this.summonedMobRL = pCompound.m_128441_("SummonedMobRL") ? pCompound.m_128461_("SummonedMobRL") : "";
        if (pCompound.m_128441_("KeyState")) {
            try {
                this.state = KeyEntityState.valueOf(pCompound.m_128461_("KeyState"));
            }
            catch (IllegalArgumentException e) {
                this.state = KeyEntityState.NORMAL;
            }
        } else {
            this.state = KeyEntityState.NORMAL;
        }
        this.updatedStateTime = pCompound.m_128441_("UpdatedStateTime") ? pCompound.m_128454_("UpdatedStateTime") : 0L;
        this.multiPhaseBoss = pCompound.m_128441_("MultiPhaseBoss") && pCompound.m_128471_("MultiPhaseBoss");
        this.f_19804_.m_135381_(DATA_STATE, (Object)this.state.ordinal());
        this.f_19804_.m_135381_(UPDATED_STATE_TIME, (Object)String.valueOf(this.updatedStateTime));
    }

    public void m_8119_() {
        super.m_8119_();
        Player player = this.f_19853_.m_45930_((Entity)this, 10.0);
        if (player != null) {
            this.m_7618_(EntityAnchorArgument.Anchor.EYES, player.m_20182_());
        }
        if (!this.f_19853_.f_46443_) {
            if (this.state == KeyEntityState.DISAPPEARED && !this.m_20145_()) {
                this.m_6842_(true);
                this.m_20225_(true);
                this.f_19794_ = true;
            }
            if (this.state == KeyEntityState.DISABLED) {
                long now = System.currentTimeMillis();
                if (now - this.updatedStateTime >= this.rechargeCooldown) {
                    this.setState(KeyEntityState.NORMAL);
                }
                return;
            }
            ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123809_, this.m_20185_(), this.m_20186_() + 3.5, this.m_20189_(), 2, 0.2, 0.2, 0.2, 0.0);
            if (this.summonedMobId != null) {
                Entity entity = ((ServerLevel)this.f_19853_).m_8791_(this.summonedMobId);
                if (entity instanceof Mob) {
                    long now;
                    Mob mob = (Mob)entity;
                    double distance = this.m_20280_((Entity)mob);
                    if (distance > 900.0) {
                        mob.m_6021_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                    }
                    if ((now = System.currentTimeMillis()) - this.updatedStateTime >= this.rechargeCooldown) {
                        mob.m_146870_();
                        this.summonedMobId = null;
                        this.setState(KeyEntityState.NORMAL);
                    }
                } else if (this.multiPhaseBoss) {
                    AABB area;
                    List nearby;
                    if (Objects.equals(this.summonedMobRL, "irons_spellbooks:dead_king_corpse")) {
                        AABB area2 = new AABB(this.m_20183_()).m_82400_(2.5);
                        List nearby2 = this.f_19853_.m_6249_((Entity)this, area2, realMob -> Objects.equals(ForgeRegistries.ENTITY_TYPES.getKey((Object)realMob.m_6095_()), ResourceLocation.fromNamespaceAndPath((String)"irons_spellbooks", (String)"dead_king")));
                        if (!nearby2.isEmpty()) {
                            this.summonedMobId = ((Entity)nearby2.get(0)).m_20148_();
                            this.summonedMobRL = "irons_spellbooks:dead_king";
                            this.multiPhaseBoss = false;
                        }
                    } else if (Objects.equals(this.summonedMobRL, "annoyingvillagers:blue_demon") && !(nearby = this.f_19853_.m_6249_((Entity)this, area = new AABB(this.m_20183_()).m_82400_(60.0), realMob -> Objects.equals(ForgeRegistries.ENTITY_TYPES.getKey((Object)realMob.m_6095_()), ResourceLocation.fromNamespaceAndPath((String)"annoyingvillagers", (String)"blue_demon_2")))).isEmpty()) {
                        this.summonedMobId = ((Entity)nearby.get(0)).m_20148_();
                        this.summonedMobRL = "annoyingvillagers:blue_demon_2";
                        this.multiPhaseBoss = false;
                    }
                } else {
                    String tempSummonedMobRL = this.summonedMobRL;
                    this.summonedMobRL = "";
                    this.summonedMobId = null;
                    this.setState(KeyEntityState.DISABLED);
                    BossLootData data = DailyBossLoader.BOSS_LOOT_TABLES.get(tempSummonedMobRL);
                    List<Object> lootTables = data != null ? data.lootTables : Collections.emptyList();
                    for (int i = 0; i < 5; ++i) {
                        String lootTableId = (String)lootTables.get(RANDOM.nextInt(lootTables.size()));
                        String[] parts = lootTableId.split(":");
                        RewardEvent.dropLoot((ServerLevel)this.f_19853_, ResourceLocation.fromNamespaceAndPath((String)parts[0], (String)parts[1]), this.m_20097_(), 1);
                    }
                    int xpAmount = 1395;
                    this.f_19853_.m_7967_((Entity)new ExperienceOrb(this.f_19853_, (double)this.m_20097_().m_123341_() + 0.5, (double)(this.m_20097_().m_123342_() + 1), (double)this.m_20097_().m_123343_() + 0.5, xpAmount));
                }
            }
        }
    }

    private boolean spawnBoss(@NotNull Player player) {
        Entity entity;
        ResourceLocation mobRL;
        List<String> mobIds = DailyBossLoader.getListBasedOnKilledMob((ServerPlayer)player, player.m_20194_());
        if (mobIds.isEmpty()) {
            player.m_5661_((Component)Component.m_237113_((String)"You're too weak. Come back after you've defeated at least one boss or mini-boss.").m_130938_(style -> style.m_178520_(0xFFFF00)), true);
            return false;
        }
        String selectedMobId = !((String)PlaDailyBossConfig.FORCE_SPAWN.get()).isEmpty() ? (String)PlaDailyBossConfig.FORCE_SPAWN.get() : mobIds.get(RANDOM.nextInt(mobIds.size()));
        if (Objects.equals(selectedMobId, "brutalbosses:randomboss")) {
            this.summonedMobId = Objects.requireNonNull(BrutalBossesCompat.spawnRandomBossAndReturn((ServerLevel)this.f_19853_, this.m_20097_())).m_20148_();
            this.f_19853_.m_5594_(null, this.m_20183_(), SoundEvents.f_11859_, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.summonedMobRL = selectedMobId;
            this.setState(KeyEntityState.DISAPPEARED);
            return true;
        }
        if (Objects.equals(selectedMobId, "irons_spellbooks:dead_king")) {
            mobRL = ResourceLocation.fromNamespaceAndPath((String)"irons_spellbooks", (String)"dead_king_corpse");
        } else if (Objects.equals(selectedMobId, "annoyingvillagers:blue_demon_2")) {
            mobRL = ResourceLocation.fromNamespaceAndPath((String)"annoyingvillagers", (String)"blue_demon");
        } else {
            String[] parts = selectedMobId.split(":");
            mobRL = ResourceLocation.fromNamespaceAndPath((String)parts[0], (String)parts[1]);
        }
        EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(mobRL);
        boolean usedCustomNBT = false;
        if (type != null && (entity = type.m_20615_(this.f_19853_)) instanceof Mob) {
            CompoundTag tag;
            Mob mob = (Mob)entity;
            BossLootData lootData = DailyBossLoader.BOSS_LOOT_TABLES.get(selectedMobId);
            if (lootData != null && lootData.nbt != null && !lootData.nbt.entrySet().isEmpty() && !(tag = CompoundTag.f_128325_.parse((DynamicOps)JsonOps.INSTANCE, (Object)lootData.nbt).resultOrPartial(msg -> LOGGER.warn("[Daily Boss] Failed to parse NBT for mob {}: {}", (Object)selectedMobId, msg)).orElse(new CompoundTag())).m_128456_()) {
                tag.m_128359_("id", selectedMobId);
                Entity loaded = EntityType.m_20645_((CompoundTag)tag, (Level)this.f_19853_, e -> {
                    e.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                    return e;
                });
                if (loaded != null) {
                    if (loaded instanceof Mob) {
                        Mob loadedMob = (Mob)loaded;
                        loadedMob.m_21530_();
                        loadedMob.m_6710_((LivingEntity)player);
                        this.f_19853_.m_7967_((Entity)loadedMob);
                        this.summonedMobId = loadedMob.m_20148_();
                        this.summonedMobRL = selectedMobId;
                        usedCustomNBT = true;
                    } else {
                        LOGGER.warn("[DailyBoss] Loaded entity from NBT is not a mob: {}", (Object)ForgeRegistries.ENTITY_TYPES.getKey((Object)loaded.m_6095_()));
                    }
                } else {
                    LOGGER.warn("[DailyBoss] No entity was created from NBT for mob {}", (Object)selectedMobId);
                }
            }
            if (!usedCustomNBT) {
                mob.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                mob.m_21530_();
                mob.m_6710_((LivingEntity)player);
                this.f_19853_.m_7967_((Entity)mob);
                if (Objects.equals(selectedMobId, "irons_spellbooks:dead_king")) {
                    mob.m_6096_(player, InteractionHand.OFF_HAND);
                    this.multiPhaseBoss = true;
                    this.summonedMobRL = "irons_spellbooks:dead_king_corpse";
                } else if (Objects.equals(selectedMobId, "annoyingvillagers:blue_demon_2")) {
                    this.multiPhaseBoss = true;
                    this.summonedMobRL = "annoyingvillagers:blue_demon";
                } else {
                    this.summonedMobRL = selectedMobId;
                }
                this.summonedMobId = mob.m_20148_();
            }
            this.f_19853_.m_5594_(null, this.m_20183_(), SoundEvents.f_11859_, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.setState(KeyEntityState.DISAPPEARED);
            return true;
        }
        return false;
    }

    @NotNull
    protected InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        if (!this.f_19853_.f_46443_ && hand == InteractionHand.MAIN_HAND) {
            if (this.state == KeyEntityState.DISABLED) {
                long remaining = this.rechargeCooldown - (System.currentTimeMillis() - this.updatedStateTime);
                long seconds = remaining / 1000L % 60L;
                long minutes = remaining / 60000L % 60L;
                long hours = remaining / 3600000L;
                player.m_5661_((Component)Component.m_237113_((String)("Come back after " + hours + "h " + minutes + "m " + seconds + "s")).m_130938_(style -> style.m_178520_(0xFFFF00)), true);
                return InteractionResult.PASS;
            }
            if (this.state == KeyEntityState.DISAPPEARED) {
                return InteractionResult.PASS;
            }
            if (this.spawnBoss(player)) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        return super.m_6071_(player, hand);
    }

    public KeyEntityState getState() {
        if (this.f_19853_.f_46443_) {
            return KeyEntityState.values()[(Integer)this.f_19804_.m_135370_(DATA_STATE)];
        }
        return this.state;
    }

    public String getUpdatedStateTime() {
        if (this.f_19853_.f_46443_) {
            return (String)this.f_19804_.m_135370_(UPDATED_STATE_TIME);
        }
        return String.valueOf(this.updatedStateTime);
    }

    public String getRechargeCooldown() {
        if (this.f_19853_.f_46443_) {
            return (String)this.f_19804_.m_135370_(RECHARGE_COOLDOWN);
        }
        return String.valueOf(this.rechargeCooldown);
    }

    public void setState(KeyEntityState newState) {
        this.state = newState;
        this.f_19804_.m_135381_(DATA_STATE, (Object)newState.ordinal());
        if (newState == KeyEntityState.DISAPPEARED) {
            this.m_6842_(true);
            this.m_20225_(true);
            this.f_19794_ = true;
            this.updatedStateTime = System.currentTimeMillis();
            this.f_19804_.m_135381_(UPDATED_STATE_TIME, (Object)String.valueOf(this.updatedStateTime));
            this.m_6210_();
        } else {
            this.m_6842_(false);
            this.m_20225_(false);
            this.f_19794_ = false;
            this.m_6210_();
        }
        if (!this.f_19853_.f_46443_) {
            ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123810_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 20, 0.3, 0.3, 0.3, 0.01);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.0);
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        return false;
    }

    public boolean m_6673_(@NotNull DamageSource source) {
        return true;
    }

    public void m_147240_(double strength, double x, double z) {
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_21525_() {
        return true;
    }

    protected void m_7324_(@NotNull Entity other) {
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public void m_142687_(@NotNull Entity.RemovalReason reason) {
        if (reason == Entity.RemovalReason.KILLED || reason == Entity.RemovalReason.DISCARDED) {
            return;
        }
        super.m_142687_(reason);
    }

    public void m_6667_(@NotNull DamageSource cause) {
    }

    public boolean m_5829_() {
        return false;
    }

    @NotNull
    public AABB m_6921_() {
        return new AABB(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
    }

    public boolean m_142066_() {
        return false;
    }

    public boolean m_6097_() {
        return false;
    }

    public boolean m_6087_() {
        return this.state != KeyEntityState.DISAPPEARED;
    }
}

