/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.sitAddon;

import de.scholle.essentiax.EssentiaX;
import de.scholle.essentiax.addons.EssentiaXAddon;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class SitAddon
implements EssentiaXAddon,
Listener,
CommandExecutor {
    private EssentiaX plugin;
    private FileConfiguration config;
    private File configFile;
    private static final String PERM_SIT_CMD = "sitaddon.sit";
    private static final String PERM_SIT_CLICK = "sitaddon.sit.click";

    public void onLoad(EssentiaX plugin) {
        this.plugin = plugin;
        this.configFile = new File(plugin.getDataFolder(), "addons/sitaddon.yml");
        if (!this.configFile.exists()) {
            this.configFile.getParentFile().mkdirs();
            try (InputStream in = this.getClass().getClassLoader().getResourceAsStream("sitaddon.yml");){
                if (in != null) {
                    Files.copy(in, this.configFile.toPath(), new CopyOption[0]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        plugin.getLogger().info("[SitAddon] Loading...");
    }

    public void onEnable(EssentiaX plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.registerCommand("sit", this);
        plugin.getLogger().info("[SitAddon] Enabled!");
    }

    public void onDisable(EssentiaX plugin) {
        plugin.getLogger().info("[SitAddon] Disabled.");
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        if (this.config.getBoolean("messages.join-enabled")) {
            event.getPlayer().sendMessage(this.config.getString("messages.join-message").replace("&", "\u00a7"));
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        Player p = event.getPlayer();
        if (p.getVehicle() instanceof ArmorStand) {
            ArmorStand as = (ArmorStand)p.getVehicle();
            p.leaveVehicle();
            as.remove();
        }
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        if (!player.hasPermission(PERM_SIT_CLICK)) {
            return;
        }
        if (!this.config.getBoolean("sit.on-click")) {
            return;
        }
        Material clicked = event.getClickedBlock().getType();
        if (!this.isSittable(clicked)) {
            return;
        }
        double offset = this.config.getDouble("sit.offset-y", 0.0);
        if (clicked.name().endsWith("SLAB") || clicked.name().endsWith("STAIRS")) {
            offset += 0.5;
        }
        Location base = event.getClickedBlock().getLocation().add(0.5, offset, 0.5);
        this.sitPlayer(player, base);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            return true;
        }
        Player p = (Player)sender;
        if (!p.hasPermission(PERM_SIT_CMD)) {
            p.sendMessage(this.config.getString("messages.no-permission").replace("&", "\u00a7"));
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("sit")) {
            Location loc = p.getLocation().clone().add(0.0, this.config.getDouble("sit.offset-y"), 0.0);
            this.sitPlayer(p, loc);
            return true;
        }
        return false;
    }

    private boolean isSittable(Material m) {
        return this.config.getStringList("sit.allowed-blocks").contains(m.name());
    }

    private void sitPlayer(Player player, Location loc) {
        if (player.getVehicle() instanceof ArmorStand) {
            return;
        }
        ArmorStand as = (ArmorStand)player.getWorld().spawn(loc.clone().add(0.0, 1.3, 0.0), ArmorStand.class);
        as.setVisible(false);
        as.setGravity(false);
        as.setSmall(true);
        as.setMarker(true);
        as.addPassenger((Entity)player);
    }

    public void saveConfig() {
        try {
            this.config.save(this.configFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void registerCommand(String name, final CommandExecutor executor) {
        try {
            Field commandMapField = this.plugin.getServer().getClass().getDeclaredField("commandMap");
            commandMapField.setAccessible(true);
            CommandMap commandMap = (CommandMap)commandMapField.get(this.plugin.getServer());
            Command command = new Command(name){

                public boolean execute(CommandSender sender, String label, String[] args) {
                    return executor.onCommand(sender, (Command)this, label, args);
                }
            };
            commandMap.register(this.plugin.getName(), command);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

