/*
 * Decompiled with CFR 0.152.
 */
package com.wzz.inventory_sort;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.logging.LogUtils;
import com.wzz.inventory_sort.SophisticatedBackpacksHandler;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.BrushItem;
import net.minecraft.world.item.CompassItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.HoneyBottleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.LingeringPotionItem;
import net.minecraft.world.item.MilkBucketItem;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SplashPotionItem;
import net.minecraft.world.item.SpyglassItem;
import net.minecraft.world.item.SuspiciousStewItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TippedArrowItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.ComparatorBlock;
import net.minecraft.world.level.block.DaylightDetectorBlock;
import net.minecraft.world.level.block.DetectorRailBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.DropperBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.GlassBlock;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.ObserverBlock;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RailBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.RedstoneLampBlock;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.StainedGlassBlock;
import net.minecraft.world.level.block.TargetBlock;
import net.minecraft.world.level.block.TripWireHookBlock;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import org.slf4j.Logger;

@Mod(value="inventory_sort")
public class InventorySortMod {
    public static final String MODID = "inventory_sort";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int BATCH_SIZE = 100;
    private static final int MAX_MERGE_ITERATIONS = 250;
    public static KeyMapping sortKey;
    private volatile boolean isSorting = false;
    private static final int HOTBAR_START = 0;
    private static final int HOTBAR_END = 8;
    private static final int INVENTORY_START = 9;
    private static final int INVENTORY_END = 35;
    private static final int ARMOR_START = 36;
    private static final int ARMOR_END = 39;
    private static final int OFFHAND_SLOT = 40;
    private static final int SPACE_KEY = 32;

    public InventorySortMod() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::onClientSetup);
        modEventBus.addListener(this::onKeyRegister);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void onClientSetup(FMLClientSetupEvent event) {
    }

    private void onKeyRegister(RegisterKeyMappingsEvent event) {
        sortKey = new KeyMapping("key.inventorysort.sort", 82, "key.categories.inventorysort");
        event.register(sortKey);
    }

    @SubscribeEvent
    public void onScreenMouseClick(ScreenEvent.MouseButtonPressed.Pre event) {
        if (event.getButton() == 0) {
            Screen screen;
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ == null || mc.f_91080_ == null || this.isSorting) {
                return;
            }
            if (GLFW.glfwGetKey((long)mc.m_91268_().m_85439_(), (int)32) == 1 && (screen = mc.f_91080_) instanceof AbstractContainerScreen) {
                AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
                AbstractContainerMenu container = containerScreen.m_6262_();
                Slot hoveredSlot = this.getSlotUnderMouse(containerScreen);
                if (hoveredSlot != null && !hoveredSlot.m_7993_().m_41619_()) {
                    CompletableFuture.runAsync(() -> {
                        try {
                            this.performQuickTransfer(hoveredSlot, container, mc);
                        }
                        catch (Exception e) {
                            LOGGER.error("\u4e00\u952e\u8f6c\u79fb\u65f6\u53d1\u751f\u9519\u8bef: ", (Throwable)e);
                        }
                    });
                    event.setCanceled(true);
                }
            }
        }
    }

    private boolean performQuickTransfer(Slot sourceSlot, AbstractContainerMenu container, Minecraft mc) {
        if (mc.f_91072_ == null || mc.f_91074_ == null) {
            return false;
        }
        if (!mc.f_91074_.f_36095_.m_142621_().m_41619_()) {
            return false;
        }
        ItemStack sourceItem = sourceSlot.m_7993_();
        if (sourceItem.m_41619_()) {
            return false;
        }
        boolean isContainerToInventory = this.isContainerSlot(sourceSlot, container);
        try {
            if (isContainerToInventory) {
                return this.transferAllFromContainer(container, mc);
            }
            boolean isHotbarSlot = this.isHotbarSlot(sourceSlot, container);
            return this.transferAllFromInventory(container, mc, isHotbarSlot);
        }
        catch (Exception e) {
            LOGGER.error("\u8f6c\u79fb\u6240\u6709\u7269\u54c1\u65f6\u53d1\u751f\u9519\u8bef: ", (Throwable)e);
            return false;
        }
    }

    private boolean isHotbarSlot(Slot slot, AbstractContainerMenu container) {
        if (container instanceof InventoryMenu) {
            return slot.f_40219_ >= 0 && slot.f_40219_ <= 8;
        }
        int totalSlots = container.f_38839_.size();
        int playerSlotsStart = totalSlots - 36;
        int hotbarStart = playerSlotsStart + 27;
        int hotbarEnd = playerSlotsStart + 35;
        return slot.f_40219_ >= hotbarStart && slot.f_40219_ <= hotbarEnd;
    }

    private boolean transferAllFromContainer(AbstractContainerMenu container, Minecraft mc) {
        List<Slot> containerSlots = this.getContainerSlots(container);
        return this.transferAllSlots(containerSlots, container, mc, "\u5bb9\u5668\u5230\u80cc\u5305");
    }

    private boolean transferAllFromInventory(AbstractContainerMenu container, Minecraft mc, boolean onlyHotbar) {
        List<Slot> inventorySlots = this.getPlayerInventorySlots(container, onlyHotbar);
        String direction = onlyHotbar ? "\u5feb\u6377\u680f\u5230\u5bb9\u5668" : "\u4e3b\u80cc\u5305\u5230\u5bb9\u5668";
        return this.transferAllSlots(inventorySlots, container, mc, direction);
    }

    private List<Slot> getPlayerInventorySlots(AbstractContainerMenu container, boolean onlyHotbar) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        if (container instanceof InventoryMenu) {
            if (onlyHotbar) {
                for (int i = 0; i <= 8; ++i) {
                    slots.add(container.m_38853_(i));
                }
            } else {
                for (int i = 9; i <= 35; ++i) {
                    slots.add(container.m_38853_(i));
                }
            }
        } else {
            int totalSlots = container.f_38839_.size();
            int playerSlotsStart = totalSlots - 36;
            if (onlyHotbar) {
                for (int i = playerSlotsStart + 27; i < playerSlotsStart + 36; ++i) {
                    if (i < 0 || i >= totalSlots) continue;
                    slots.add(container.m_38853_(i));
                }
            } else {
                for (int i = playerSlotsStart; i < playerSlotsStart + 27; ++i) {
                    if (i < 0 || i >= totalSlots) continue;
                    slots.add(container.m_38853_(i));
                }
            }
        }
        return slots;
    }

    private List<Slot> getPlayerInventorySlots(AbstractContainerMenu container) {
        return this.getPlayerInventorySlots(container, false);
    }

    private boolean transferAllSlots(List<Slot> slots, AbstractContainerMenu container, Minecraft mc, String direction) {
        if (slots.isEmpty()) {
            return false;
        }
        boolean anyTransferred = false;
        int transferredSlots = 0;
        int totalSlots = 0;
        for (Slot slot : slots) {
            if (slot.m_7993_().m_41619_()) continue;
            ++totalSlots;
        }
        if (totalSlots == 0) {
            return false;
        }
        try {
            for (Slot slot : slots) {
                if (slot.m_7993_().m_41619_()) continue;
                if (!mc.f_91074_.f_36095_.m_142621_().m_41619_()) {
                    LOGGER.warn("\u8f6c\u79fb\u8fc7\u7a0b\u4e2d\u9f20\u6807\u4e0d\u4e3a\u7a7a\uff0c\u505c\u6b62\u8f6c\u79fb");
                    break;
                }
                ItemStack originalItem = slot.m_7993_().m_41777_();
                mc.f_91072_.m_171799_(container.f_38840_, slot.f_40219_, 0, ClickType.QUICK_MOVE, (Player)mc.f_91074_);
                ItemStack currentItem = slot.m_7993_();
                if (currentItem.m_41613_() < originalItem.m_41613_() || currentItem.m_41619_()) {
                    anyTransferred = true;
                    ++transferredSlots;
                }
                if (transferredSlots % 10 != 0) continue;
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            return anyTransferred;
        }
        catch (Exception e) {
            LOGGER.error("\u8f6c\u79fb\u6240\u6709\u7269\u54c1\u65f6\u53d1\u751f\u9519\u8bef: ", (Throwable)e);
            return false;
        }
    }

    private List<Slot> getContainerSlots(AbstractContainerMenu container) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        if (container instanceof InventoryMenu) {
            return slots;
        }
        int totalSlots = container.f_38839_.size();
        int containerSlotsEnd = totalSlots - 36;
        for (int i = 0; i < containerSlotsEnd; ++i) {
            if (i < 0 || i >= totalSlots) continue;
            slots.add(container.m_38853_(i));
        }
        return slots;
    }

    private boolean isContainerSlot(Slot slot, AbstractContainerMenu container) {
        if (container instanceof InventoryMenu) {
            return false;
        }
        int totalSlots = container.f_38839_.size();
        int playerSlotsStart = totalSlots - 36;
        return slot.f_40219_ < playerSlotsStart;
    }

    private Slot getSlotUnderMouse(AbstractContainerScreen<?> screen) {
        block7: {
            try {
                Field[] fields;
                String[] methodNames;
                Method method = null;
                Class<AbstractContainerScreen> clazz = AbstractContainerScreen.class;
                for (String methodName : methodNames = new String[]{"getSlotUnderMouse", "m_97894_", "getHoveredSlot"}) {
                    try {
                        method = clazz.getDeclaredMethod(methodName, new Class[0]);
                        break;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                }
                if (method != null) {
                    method.setAccessible(true);
                    return (Slot)method.invoke(screen, new Object[0]);
                }
                for (Field field : fields = clazz.getDeclaredFields()) {
                    if (field.getType() != Slot.class) continue;
                    field.setAccessible(true);
                    Object value = field.get(screen);
                    if (!(value instanceof Slot)) continue;
                    return (Slot)value;
                }
            }
            catch (Exception e) {
                if (!LOGGER.isDebugEnabled()) break block7;
                LOGGER.debug("\u83b7\u53d6\u9f20\u6807\u4e0b\u69fd\u4f4d\u5931\u8d25: ", (Throwable)e);
            }
        }
        return null;
    }

    @SubscribeEvent
    public void onScreenKeyPress(ScreenEvent.KeyPressed.Pre event) {
        if (sortKey.m_90832_(event.getKeyCode(), event.getScanCode())) {
            this.tryTriggerSort(event);
        }
    }

    @SubscribeEvent
    public void onMouseClick(InputEvent.MouseButton event) {
        if (event.getAction() != 1) {
            return;
        }
        if (sortKey.getKey().m_84868_() == InputConstants.Type.MOUSE && sortKey.getKey().m_84873_() == event.getButton()) {
            this.tryTriggerSort(null);
        }
    }

    private void tryTriggerSort(@Nullable ScreenEvent.KeyPressed.Pre event) {
        Minecraft mc = Minecraft.m_91087_();
        if (this.shouldSkipSorting(mc)) {
            return;
        }
        if (this.trySortSophisticatedBackpack(event, mc)) {
            return;
        }
        Screen screen = mc.f_91080_;
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
            this.handleContainerSorting(containerScreen, event);
        }
    }

    private boolean shouldSkipSorting(Minecraft mc) {
        return mc.f_91074_ == null || this.isSorting || mc.f_91080_ instanceof CreativeModeInventoryScreen || mc.f_91080_ == null;
    }

    private boolean trySortSophisticatedBackpack(ScreenEvent.KeyPressed.Pre event, Minecraft mc) {
        boolean sorted;
        if (!SophisticatedBackpacksHandler.hasSophisticatedBackpacksMod()) {
            return false;
        }
        if (event != null) {
            sorted = SophisticatedBackpacksHandler.sortBackpack(event.getScreen());
            if (sorted) {
                event.setCanceled(true);
            }
        } else {
            sorted = SophisticatedBackpacksHandler.sortBackpack(mc.f_91080_);
        }
        return sorted;
    }

    private void handleContainerSorting(AbstractContainerScreen<?> containerScreen, ScreenEvent.KeyPressed.Pre event) {
        AbstractContainerMenu container = containerScreen.m_6262_();
        if (this.isPlayerInventory(containerScreen, container)) {
            this.sortPlayerInventoryAsync();
        } else if (this.shouldSortContainer(container)) {
            this.sortContainerAsync();
        }
        if (event != null) {
            event.setCanceled(true);
        }
    }

    private boolean isPlayerInventory(AbstractContainerScreen<?> screen, AbstractContainerMenu menu) {
        return screen instanceof InventoryScreen || menu instanceof InventoryMenu;
    }

    private boolean shouldSortContainer(AbstractContainerMenu container) {
        int MIN_CONTAINER_SIZE = 10;
        return this.getContainerSize(container) >= 10;
    }

    private void sortContainerAsync() {
        if (this.isSorting) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        mc.execute(() -> {
            try {
                this.sortContainer();
            }
            catch (Exception e) {
                LOGGER.error("\u6392\u5e8f\u5bb9\u5668\u65f6\u53d1\u751f\u9519\u8bef: ", (Throwable)e);
            }
        });
    }

    private void sortPlayerInventoryAsync() {
        if (this.isSorting) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                this.sortPlayerInventory();
            }
            catch (Exception e) {
                LOGGER.error("\u5f02\u6b65\u6392\u5e8f\u73a9\u5bb6\u80cc\u5305\u65f6\u53d1\u751f\u9519\u8bef: ", (Throwable)e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sortContainer() {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || this.isSorting) {
            return;
        }
        this.isSorting = true;
        try {
            AbstractContainerMenu container = player.f_36096_;
            ArrayList<Slot> containerSlots = new ArrayList<Slot>();
            int totalSlots = container.f_38839_.size();
            int containerSlotsCount = totalSlots - 36;
            for (int i = 0; i < containerSlotsCount; ++i) {
                if (i >= totalSlots) continue;
                containerSlots.add(container.m_38853_(i));
            }
            if (!containerSlots.isEmpty()) {
                this.sortSlots(containerSlots, container);
            }
        }
        finally {
            this.isSorting = false;
        }
    }

    private boolean isPlayerSlot(Slot slot, AbstractContainerMenu container) {
        return !this.isContainerSlot(slot, container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sortPlayerInventory() {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || this.isSorting) {
            return;
        }
        this.isSorting = true;
        try {
            AbstractContainerMenu container = player.f_36096_;
            ArrayList<Slot> inventorySlots = new ArrayList<Slot>();
            if (container instanceof InventoryMenu) {
                for (int i = 9; i <= 35; ++i) {
                    Slot slot = container.m_38853_(i);
                    inventorySlots.add(slot);
                }
            } else {
                int totalSlots = container.f_38839_.size();
                int playerInventoryStart = totalSlots - 36 + 9;
                int playerInventoryEnd = totalSlots - 9;
                for (int i = playerInventoryStart; i < playerInventoryEnd; ++i) {
                    if (i < 0 || i >= totalSlots) continue;
                    Slot slot = container.m_38853_(i);
                    inventorySlots.add(slot);
                }
            }
            if (!inventorySlots.isEmpty()) {
                this.sortSlots(inventorySlots, container);
            }
        }
        finally {
            this.isSorting = false;
        }
    }

    private int getContainerSize(AbstractContainerMenu container) {
        int totalSlots = container.f_38839_.size();
        if (container instanceof InventoryMenu) {
            return 0;
        }
        if (totalSlots > 36) {
            return totalSlots - 36;
        }
        return totalSlots;
    }

    private void sortSlots(List<Slot> slots, AbstractContainerMenu container) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91072_ == null) {
            return;
        }
        try {
            if (!this.ensureMouseEmpty(container, mc)) {
                LOGGER.error("\u6392\u5e8f\u5f00\u59cb\u524d\u65e0\u6cd5\u6e05\u7a7a\u9f20\u6807\uff0c\u4e2d\u6b62\u6392\u5e8f");
                return;
            }
            this.mergeIdenticalItemsBatched(slots, container, mc);
            if (!this.ensureMouseEmpty(container, mc)) {
                return;
            }
            this.performSortBatched(slots, container, mc);
            if (!this.ensureMouseEmpty(container, mc)) {
                LOGGER.error("\u6392\u5e8f\u5b8c\u6210\u540e\u65e0\u6cd5\u6e05\u7a7a\u9f20\u6807\uff0c\u53ef\u80fd\u5b58\u5728\u7269\u54c1\u4e22\u5931");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6574\u7406\u7269\u54c1\u65f6\u53d1\u751f\u9519\u8bef: ", (Throwable)e);
            try {
                this.ensureMouseEmpty(container, mc);
            }
            catch (Exception ex) {
                LOGGER.error("\u9519\u8bef\u6062\u590d\u65f6\u4e5f\u53d1\u751f\u5f02\u5e38: ", (Throwable)ex);
            }
        }
    }

    private boolean ensureMouseEmpty(AbstractContainerMenu container, Minecraft mc) {
        boolean success;
        if (mc.f_91072_ == null || mc.f_91074_ == null) {
            return true;
        }
        ItemStack carriedItem = mc.f_91074_.f_36095_.m_142621_();
        if (carriedItem.m_41619_()) {
            return true;
        }
        int attempts = 0;
        int MAX_ATTEMPTS = 10;
        while (!carriedItem.m_41619_() && attempts < 10) {
            ++attempts;
            boolean placed = false;
            for (Slot slot : container.f_38839_) {
                if (!slot.m_7993_().m_41619_() || !slot.m_5857_(carriedItem)) continue;
                mc.f_91072_.m_171799_(container.f_38840_, slot.f_40219_, 0, ClickType.PICKUP, (Player)mc.f_91074_);
                carriedItem = mc.f_91074_.f_36095_.m_142621_();
                if (!carriedItem.m_41619_()) continue;
                placed = true;
                break;
            }
            if (placed) break;
            for (Slot slot : container.f_38839_) {
                ItemStack slotItem = slot.m_7993_();
                if (slotItem.m_41619_() || !ItemStack.m_150942_((ItemStack)carriedItem, (ItemStack)slotItem) || slotItem.m_41613_() >= slotItem.m_41741_() || !slot.m_5857_(carriedItem)) continue;
                mc.f_91072_.m_171799_(container.f_38840_, slot.f_40219_, 0, ClickType.PICKUP, (Player)mc.f_91074_);
                carriedItem = mc.f_91074_.f_36095_.m_142621_();
                if (!carriedItem.m_41619_()) continue;
                placed = true;
                break;
            }
            if (placed) break;
            if (!carriedItem.m_41619_()) {
                mc.f_91072_.m_171799_(container.f_38840_, -999, 0, ClickType.PICKUP, (Player)mc.f_91074_);
                carriedItem = mc.f_91074_.f_36095_.m_142621_();
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
        if (!(success = carriedItem.m_41619_())) {
            LOGGER.error("\u65e0\u6cd5\u6e05\u7a7a\u9f20\u6807\uff0c\u5269\u4f59\u7269\u54c1: {} x{}", (Object)carriedItem.m_41611_().getString(), (Object)carriedItem.m_41613_());
        }
        return success;
    }

    private void mergeIdenticalItemsBatched(List<Slot> slots, AbstractContainerMenu container, Minecraft mc) {
        boolean merged;
        int iterations = 0;
        do {
            merged = false;
            if (++iterations > 250 || !mc.f_91074_.f_36095_.m_142621_().m_41619_() && !this.ensureMouseEmpty(container, mc)) break;
            for (int batchStart = 0; batchStart < slots.size() && !merged; batchStart += 100) {
                int batchEnd = Math.min(batchStart + 100, slots.size());
                block4: for (int i = batchStart; i < batchEnd && !merged; ++i) {
                    Slot slot1 = slots.get(i);
                    ItemStack stack1 = slot1.m_7993_();
                    if (stack1.m_41619_() || stack1.m_41613_() >= stack1.m_41741_()) continue;
                    for (int j = i + 1; j < slots.size(); ++j) {
                        int spaceAvailable;
                        Slot slot2 = slots.get(j);
                        ItemStack stack2 = slot2.m_7993_();
                        if (stack2.m_41619_() || !ItemStack.m_150942_((ItemStack)stack1, (ItemStack)stack2) || (spaceAvailable = stack1.m_41741_() - stack1.m_41613_()) <= 0) continue;
                        if (!mc.f_91074_.f_36095_.m_142621_().m_41619_()) {
                            return;
                        }
                        if (!this.mergeStacks(slot1, slot2, container, mc)) continue;
                        merged = true;
                        if (mc.f_91074_.f_36095_.m_142621_().m_41619_()) continue block4;
                        this.ensureMouseEmpty(container, mc);
                        continue block4;
                    }
                }
                if (!merged) continue;
                try {
                    Thread.sleep(3L);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        } while (merged);
    }

    private boolean mergeStacks(Slot targetSlot, Slot sourceSlot, AbstractContainerMenu container, Minecraft mc) {
        boolean sourceIsContainer;
        ItemStack source;
        if (mc.f_91072_ == null || mc.f_91074_ == null) {
            return false;
        }
        ItemStack target = targetSlot.m_7993_();
        if (!ItemStack.m_150942_((ItemStack)target, (ItemStack)(source = sourceSlot.m_7993_()))) {
            return false;
        }
        int maxStackSize = target.m_41741_();
        int spaceAvailable = maxStackSize - target.m_41613_();
        if (spaceAvailable <= 0) {
            return false;
        }
        boolean targetIsContainer = this.isContainerSlot(targetSlot, container);
        if (targetIsContainer != (sourceIsContainer = this.isContainerSlot(sourceSlot, container))) {
            return false;
        }
        int originalTargetCount = target.m_41613_();
        try {
            mc.f_91072_.m_171799_(container.f_38840_, sourceSlot.f_40219_, 0, ClickType.PICKUP, (Player)mc.f_91074_);
            mc.f_91072_.m_171799_(container.f_38840_, targetSlot.f_40219_, 0, ClickType.PICKUP, (Player)mc.f_91074_);
            ItemStack carriedItem = mc.f_91074_.f_36095_.m_142621_();
            if (!carriedItem.m_41619_()) {
                mc.f_91072_.m_171799_(container.f_38840_, sourceSlot.f_40219_, 0, ClickType.PICKUP, (Player)mc.f_91074_);
            }
            if (!mc.f_91074_.f_36095_.m_142621_().m_41619_()) {
                this.ensureMouseEmpty(container, mc);
            }
            return targetSlot.m_7993_().m_41613_() > originalTargetCount;
        }
        catch (Exception e) {
            LOGGER.error("\u5408\u5e76\u7269\u54c1\u65f6\u53d1\u751f\u9519\u8bef: ", (Throwable)e);
            try {
                if (!mc.f_91074_.f_36095_.m_142621_().m_41619_()) {
                    this.ensureMouseEmpty(container, mc);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
    }

    private void performSortBatched(List<Slot> slots, AbstractContainerMenu container, Minecraft mc) {
        if (mc.f_91074_ == null) {
            return;
        }
        if (!mc.f_91074_.f_36095_.m_142621_().m_41619_() && !this.ensureMouseEmpty(container, mc)) {
            LOGGER.error("\u65e0\u6cd5\u6e05\u7a7a\u9f20\u6807\uff0c\u4e2d\u6b62\u6392\u5e8f");
            return;
        }
        ArrayList<SlotInfo> slotInfos = new ArrayList<SlotInfo>();
        for (int i = 0; i < slots.size(); ++i) {
            Slot slot = slots.get(i);
            ItemStack stack = slot.m_7993_();
            slotInfos.add(new SlotInfo(i, slot, stack.m_41777_()));
        }
        slotInfos.sort((a, b) -> {
            if (a.stack.m_41619_() && b.stack.m_41619_()) {
                return 0;
            }
            if (a.stack.m_41619_()) {
                return 1;
            }
            if (b.stack.m_41619_()) {
                return -1;
            }
            String keyA = this.getItemKey(a.stack);
            String keyB = this.getItemKey(b.stack);
            return keyA.compareTo(keyB);
        });
        int swapCount = 0;
        for (int targetIndex = 0; targetIndex < slotInfos.size(); ++targetIndex) {
            if (!mc.f_91074_.f_36095_.m_142621_().m_41619_() && !this.ensureMouseEmpty(container, mc)) {
                LOGGER.error("\u4ea4\u6362\u8fc7\u7a0b\u4e2d\u65e0\u6cd5\u6e05\u7a7a\u9f20\u6807\uff0c\u4e2d\u6b62\u6392\u5e8f");
                break;
            }
            SlotInfo targetInfo = (SlotInfo)slotInfos.get(targetIndex);
            if (targetInfo.originalIndex == targetIndex) continue;
            SlotInfo currentAtTarget = null;
            for (int i = targetIndex + 1; i < slotInfos.size(); ++i) {
                if (((SlotInfo)slotInfos.get((int)i)).originalIndex != targetIndex) continue;
                currentAtTarget = (SlotInfo)slotInfos.get(i);
                break;
            }
            if (currentAtTarget == null || !this.swapSlots(slots.get(targetIndex), slots.get(targetInfo.originalIndex), container, mc)) continue;
            int tempIndex = targetInfo.originalIndex;
            targetInfo.originalIndex = targetIndex;
            currentAtTarget.originalIndex = tempIndex;
            ++swapCount;
            if (!mc.f_91074_.f_36095_.m_142621_().m_41619_() && !this.ensureMouseEmpty(container, mc)) break;
            if (swapCount % 20 != 0) continue;
            try {
                Thread.sleep(3L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    private boolean swapSlots(Slot slot1, Slot slot2, AbstractContainerMenu container, Minecraft mc) {
        if (slot1.m_7993_().m_41619_() && slot2.m_7993_().m_41619_()) {
            return true;
        }
        if (mc.f_91072_ == null || mc.f_91074_ == null) {
            return false;
        }
        if (!mc.f_91074_.f_36095_.m_142621_().m_41619_()) {
            return false;
        }
        mc.f_91072_.m_171799_(container.f_38840_, slot1.f_40219_, 0, ClickType.PICKUP, (Player)mc.f_91074_);
        mc.f_91072_.m_171799_(container.f_38840_, slot2.f_40219_, 0, ClickType.PICKUP, (Player)mc.f_91074_);
        mc.f_91072_.m_171799_(container.f_38840_, slot1.f_40219_, 0, ClickType.PICKUP, (Player)mc.f_91074_);
        if (!mc.f_91074_.f_36095_.m_142621_().m_41619_()) {
            LOGGER.error("\u4ea4\u6362\u64cd\u4f5c\u540e\u9f20\u6807\u4ecd\u4e0d\u4e3a\u7a7a\uff0c\u53ef\u80fd\u5b58\u5728\u95ee\u9898");
            return false;
        }
        return true;
    }

    private String getItemKey(ItemStack stack) {
        if (stack.m_41619_()) {
            return "zzz_empty";
        }
        ItemCategory category = this.getItemCategory(stack);
        String itemName = this.getItemName(stack.m_41720_());
        String nbtHash = stack.m_41783_() != null ? String.valueOf(stack.m_41783_().toString().hashCode()) : "0";
        return String.format("%02d_%s_%s_%s", category.getPriority(), category.name(), itemName, nbtHash);
    }

    private ItemCategory getItemCategory(ItemStack stack) {
        if (stack.m_41619_()) {
            return ItemCategory.MISC;
        }
        Item item = stack.m_41720_();
        if (this.isWeapon(item, stack)) {
            return ItemCategory.WEAPONS;
        }
        if (this.isTool(item, stack)) {
            return ItemCategory.TOOLS;
        }
        if (this.isArmor(item, stack)) {
            return ItemCategory.ARMOR;
        }
        if (this.isMusic(item, stack)) {
            return ItemCategory.MUSIC;
        }
        if (this.isFood(item, stack)) {
            return ItemCategory.FOOD;
        }
        if (this.isPotion(item, stack)) {
            return ItemCategory.POTIONS;
        }
        if (this.isRedstone(item, stack)) {
            return ItemCategory.REDSTONE;
        }
        if (this.isDecoration(item, stack)) {
            return ItemCategory.DECORATIONS;
        }
        if (this.isBlock(item, stack)) {
            return ItemCategory.BLOCKS;
        }
        if (this.isMaterial(item, stack)) {
            return ItemCategory.MATERIALS;
        }
        return ItemCategory.MISC;
    }

    private boolean isMusic(Item item, ItemStack stack) {
        Block block;
        if (item instanceof RecordItem) {
            return true;
        }
        if (item instanceof BlockItem && ((block = ((BlockItem)item).m_40614_()) instanceof JukeboxBlock || block instanceof NoteBlock)) {
            return true;
        }
        if (this.isInTag(stack, "music_discs") || this.isInTag(stack, "records")) {
            return true;
        }
        String itemName = this.getItemName(item).toLowerCase();
        return itemName.contains("music_disc") || itemName.contains("record") || itemName.contains("disc") || itemName.contains("jukebox") || itemName.contains("note_block");
    }

    private boolean isWeapon(Item item, ItemStack stack) {
        if (item instanceof SwordItem || item instanceof TridentItem || item instanceof BowItem || item instanceof CrossbowItem) {
            return true;
        }
        if (stack.m_204117_(ItemTags.f_271388_) || this.isInTag(stack, "weapons") || this.isInTag(stack, "swords") || this.isInTag(stack, "bows") || this.isInTag(stack, "crossbows")) {
            return true;
        }
        if (this.getAttackDamage(item) > 2.0f && !this.isTool(item, stack)) {
            return true;
        }
        String itemName = this.getItemName(item).toLowerCase();
        return itemName.contains("sword") || itemName.contains("blade") || itemName.contains("katana") || itemName.contains("dagger") || itemName.contains("bow") || itemName.contains("crossbow") || itemName.contains("gun") || itemName.contains("rifle") || itemName.contains("pistol") || itemName.contains("weapon");
    }

    private boolean isTool(Item item, ItemStack stack) {
        if (item instanceof DiggerItem || item instanceof ShearsItem || item instanceof FlintAndSteelItem || item instanceof FishingRodItem || item instanceof CompassItem || item instanceof SpyglassItem || item instanceof BrushItem) {
            return true;
        }
        if (stack.m_204117_(ItemTags.f_271540_) || stack.m_204117_(ItemTags.f_271360_) || stack.m_204117_(ItemTags.f_271207_) || stack.m_204117_(ItemTags.f_271138_) || stack.m_204117_(ItemTags.f_271298_) || this.isInTag(stack, "tools") || this.isInTag(stack, "pickaxes") || this.isInTag(stack, "axes") || this.isInTag(stack, "shovels") || this.isInTag(stack, "hoes")) {
            return true;
        }
        if (stack.m_41763_() && item instanceof DiggerItem) {
            return true;
        }
        String itemName = this.getItemName(item).toLowerCase();
        return itemName.contains("pickaxe") || itemName.contains("axe") || itemName.contains("shovel") || itemName.contains("hoe") || itemName.contains("wrench") || itemName.contains("hammer") || itemName.contains("drill") || itemName.contains("chainsaw") || itemName.contains("tool");
    }

    private boolean isArmor(Item item, ItemStack stack) {
        if (item instanceof ArmorItem || item instanceof ElytraItem || item instanceof ShieldItem) {
            return true;
        }
        if (this.isInTag(stack, "armor") || this.isInTag(stack, "helmets") || this.isInTag(stack, "chestplates") || this.isInTag(stack, "leggings") || this.isInTag(stack, "boots") || this.isInTag(stack, "shields")) {
            return true;
        }
        if (stack.m_41763_() && this.hasArmorValue(item)) {
            return true;
        }
        String itemName = this.getItemName(item).toLowerCase();
        return itemName.contains("helmet") || itemName.contains("chestplate") || itemName.contains("leggings") || itemName.contains("boots") || itemName.contains("armor") || itemName.contains("shield") || itemName.contains("elytra");
    }

    private boolean isFood(Item item, ItemStack stack) {
        if (item.getFoodProperties(stack, null) != null) {
            return true;
        }
        if (item instanceof MilkBucketItem || item instanceof HoneyBottleItem || item instanceof SuspiciousStewItem) {
            return true;
        }
        if (this.isInTag(stack, "food") || this.isInTag(stack, "foods")) {
            return true;
        }
        String itemName = this.getItemName(item).toLowerCase();
        return itemName.contains("food") || itemName.contains("bread") || itemName.contains("meat") || itemName.contains("fish") || itemName.contains("fruit") || itemName.contains("vegetable") || itemName.contains("cake") || itemName.contains("pie") || itemName.contains("soup") || itemName.contains("stew");
    }

    private boolean isPotion(Item item, ItemStack stack) {
        if (item instanceof PotionItem || item instanceof SplashPotionItem || item instanceof LingeringPotionItem || item instanceof TippedArrowItem || item == Items.f_42590_ || item == Items.f_42612_) {
            return true;
        }
        if (this.isInTag(stack, "potions") || this.isInTag(stack, "bottles")) {
            return true;
        }
        String itemName = this.getItemName(item).toLowerCase();
        return itemName.contains("potion") || itemName.contains("bottle") || itemName.contains("elixir") || itemName.contains("tonic") || itemName.contains("brew") || itemName.contains("essence");
    }

    private boolean isRedstone(Item item, ItemStack stack) {
        Block block;
        if (this.isInTag(stack, "redstone") || this.isInTag(stack, "redstone_dusts")) {
            return true;
        }
        if (item instanceof BlockItem && ((block = ((BlockItem)item).m_40614_()) instanceof RedStoneWireBlock || block instanceof RepeaterBlock || block instanceof ComparatorBlock || block instanceof PistonBaseBlock || block instanceof DispenserBlock || block instanceof DropperBlock || block instanceof HopperBlock || block instanceof ObserverBlock || block instanceof DaylightDetectorBlock || block instanceof TripWireHookBlock || block instanceof LeverBlock || block instanceof ButtonBlock || block instanceof PressurePlateBlock || block instanceof PoweredRailBlock || block instanceof DetectorRailBlock || block instanceof RailBlock || block instanceof RedstoneLampBlock || block instanceof TargetBlock)) {
            return true;
        }
        String itemName = this.getItemName(item).toLowerCase();
        return itemName.contains("redstone") || itemName.contains("repeater") || itemName.contains("comparator") || itemName.contains("piston") || itemName.contains("dispenser") || itemName.contains("dropper") || itemName.contains("hopper") || itemName.contains("observer") || itemName.contains("lever") || itemName.contains("button") || itemName.contains("circuit") || itemName.contains("wire");
    }

    private boolean isDecoration(Item item, ItemStack stack) {
        Block block;
        if (this.isInTag(stack, "decorations") || this.isInTag(stack, "flowers") || this.isInTag(stack, "banners") || this.isInTag(stack, "candles")) {
            return true;
        }
        if (item == Items.f_42487_ || item == Items.f_42617_ || item == Items.f_151063_ || item == Items.f_42650_) {
            return true;
        }
        if (item instanceof BlockItem && ((block = ((BlockItem)item).m_40614_()) instanceof FlowerBlock || block instanceof BannerBlock || block instanceof CandleBlock || block instanceof CarpetBlock || block instanceof GlassBlock || block instanceof StainedGlassBlock)) {
            return true;
        }
        String itemName = this.getItemName(item).toLowerCase();
        return itemName.contains("decoration") || itemName.contains("flower") || itemName.contains("banner") || itemName.contains("candle") || itemName.contains("painting") || itemName.contains("frame") || itemName.contains("carpet") || itemName.contains("glass");
    }

    private boolean isBlock(Item item, ItemStack stack) {
        if (!(item instanceof BlockItem)) {
            return false;
        }
        if (this.isInTag(stack, "blocks") || this.isInTag(stack, "stone") || this.isInTag(stack, "wood") || this.isInTag(stack, "planks") || this.isInTag(stack, "logs") || this.isInTag(stack, "ores")) {
            return true;
        }
        return !this.isRedstone(item, stack) && !this.isDecoration(item, stack);
    }

    private boolean isMaterial(Item item, ItemStack stack) {
        if (this.isInTag(stack, "ingots") || this.isInTag(stack, "gems") || this.isInTag(stack, "dusts") || this.isInTag(stack, "nuggets") || this.isInTag(stack, "ores") || this.isInTag(stack, "raw_materials") || this.isInTag(stack, "dyes") || this.isInTag(stack, "seeds")) {
            return true;
        }
        if (!(stack.m_41763_() || this.isFood(item, stack) || this.isPotion(item, stack) || item instanceof BlockItem)) {
            return true;
        }
        String itemName = this.getItemName(item).toLowerCase();
        return itemName.contains("ingot") || itemName.contains("gem") || itemName.contains("dust") || itemName.contains("nugget") || itemName.contains("crystal") || itemName.contains("shard") || itemName.contains("essence") || itemName.contains("powder") || itemName.contains("seed") || itemName.contains("dye") || itemName.contains("material") || itemName.contains("component");
    }

    private float getAttackDamage(Item item) {
        if (item instanceof SwordItem) {
            return ((SwordItem)item).m_43299_();
        }
        if (item instanceof AxeItem) {
            return ((AxeItem)item).m_41008_();
        }
        if (item instanceof DiggerItem) {
            return ((DiggerItem)item).m_41008_();
        }
        return 0.0f;
    }

    private boolean hasArmorValue(Item item) {
        return item instanceof ArmorItem;
    }

    private String getItemName(Item item) {
        ResourceLocation registryName = BuiltInRegistries.f_257033_.m_7981_((Object)item);
        return registryName != null ? registryName.m_135815_() : item.toString();
    }

    private boolean isInTag(ItemStack stack, String tagName) {
        try {
            String[] namespaces;
            for (String namespace : namespaces = new String[]{"minecraft", "forge", "c", "common"}) {
                ResourceLocation tagLocation = new ResourceLocation(namespace, tagName);
                if (!BuiltInRegistries.f_257033_.m_203431_(TagKey.m_203882_((ResourceKey)BuiltInRegistries.f_257033_.m_123023_(), (ResourceLocation)tagLocation)).isPresent()) continue;
                return stack.m_204117_(TagKey.m_203882_((ResourceKey)BuiltInRegistries.f_257033_.m_123023_(), (ResourceLocation)tagLocation));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static class SlotInfo {
        int originalIndex;
        Slot slot;
        ItemStack stack;

        SlotInfo(int originalIndex, Slot slot, ItemStack stack) {
            this.originalIndex = originalIndex;
            this.slot = slot;
            this.stack = stack;
        }
    }

    private static enum ItemCategory {
        WEAPONS(1, "\u6b66\u5668"),
        TOOLS(2, "\u5de5\u5177"),
        ARMOR(3, "\u62a4\u7532"),
        MUSIC(4, "\u97f3\u4e50"),
        BLOCKS(5, "\u65b9\u5757"),
        FOOD(6, "\u98df\u7269"),
        POTIONS(7, "\u836f\u6c34"),
        REDSTONE(8, "\u7ea2\u77f3"),
        DECORATIONS(9, "\u88c5\u9970"),
        MATERIALS(10, "\u6750\u6599"),
        MISC(11, "\u6742\u9879");

        private final int priority;
        private final String displayName;

        private ItemCategory(int priority, String displayName) {
            this.priority = priority;
            this.displayName = displayName;
        }

        public int getPriority() {
            return this.priority;
        }
    }
}

