/*
 * Decompiled with CFR 0.152.
 */
package com.wzz.inventory_sort;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.fml.ModList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SophisticatedBackpacksHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static Method sortMethod = null;
    private static boolean reflectionInitialized = false;

    public static boolean hasSophisticatedBackpacksMod() {
        return ModList.get().isLoaded("sophisticatedbackpacks");
    }

    public static boolean sortBackpack(Screen screen) {
        SophisticatedBackpacksHandler.initializeReflection();
        if (sortMethod == null) {
            return false;
        }
        try {
            return (Boolean)sortMethod.invoke(null, screen);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LOGGER.error("\u8c03\u7528 Sophisticated Backpacks \u6392\u5e8f\u65b9\u6cd5\u5931\u8d25: {}", (Object)e.getMessage());
            LOGGER.debug("\u5b8c\u6574\u9519\u8bef\u4fe1\u606f:", (Throwable)e);
            return false;
        }
    }

    private static synchronized void initializeReflection() {
        if (reflectionInitialized) {
            return;
        }
        try {
            Class<?> clazz = Class.forName("net.p3pp3rf1y.sophisticatedbackpacks.client.KeybindHandler");
            sortMethod = clazz.getDeclaredMethod("tryCallSort", Screen.class);
            sortMethod.setAccessible(true);
        }
        catch (ClassNotFoundException e) {
            LOGGER.warn("Sophisticated Backpacks \u7c7b\u672a\u627e\u5230\uff0c\u53ef\u80fd\u7248\u672c\u4e0d\u517c\u5bb9");
        }
        catch (NoSuchMethodException e) {
            LOGGER.warn("Sophisticated Backpacks \u6392\u5e8f\u65b9\u6cd5\u672a\u627e\u5230\uff0c\u53ef\u80fd\u7248\u672c\u4e0d\u517c\u5bb9");
        }
        catch (Exception e) {
            LOGGER.error("\u521d\u59cb\u5316 Sophisticated Backpacks \u53cd\u5c04\u65b9\u6cd5\u5931\u8d25: {}", (Object)e.getMessage());
        }
        finally {
            reflectionInitialized = true;
        }
    }
}

