/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.baublesreforked.events;

import com.jinqinxixi.baublesreforked.attributes.ModAttributes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

@EventBusSubscriber(modid="baublesreforked")
public class AttributeEvents {
    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent.Pre event) {
        Entity entity = event.getSource().getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            AttributeEvents.handleLifeSteal(player, event.getNewDamage());
        }
    }

    private static void handleLifeSteal(Player player, float damageAmount) {
        AttributeInstance lifeStealAttr = player.getAttribute(ModAttributes.LIFE_STEAL);
        if (lifeStealAttr != null && lifeStealAttr.getValue() > 0.0) {
            float healAmount = (float)((double)damageAmount * lifeStealAttr.getValue());
            player.heal(healAmount);
            System.out.println("Life Steal Base Value: " + lifeStealAttr.getBaseValue());
            System.out.println("Life Steal Final Value: " + lifeStealAttr.getValue());
            if (healAmount > 0.0f) {
                // empty if block
            }
        }
    }
}

