/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.baublesreforked.items;

import com.jinqinxixi.baublesreforked.config.ModifierConfig;
import com.jinqinxixi.baublesreforked.data.ModComponents;
import com.jinqinxixi.baublesreforked.items.ModItems;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;

public class ModifierItem
extends Item {
    public ModifierItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public static ItemStack createWithModifier(String modifierId) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.MODIFIER_BOOK.get());
        stack.set((DataComponentType)ModComponents.MODIFIER_ID.get(), (Object)modifierId);
        stack.set((DataComponentType)ModComponents.HAS_MODIFIER.get(), (Object)true);
        return stack;
    }

    public static String getModifierId(ItemStack stack) {
        return (String)stack.getOrDefault((DataComponentType)ModComponents.MODIFIER_ID.get(), (Object)"");
    }

    public static boolean hasModifier(ItemStack stack) {
        return stack.has((DataComponentType)ModComponents.HAS_MODIFIER.get()) && stack.has((DataComponentType)ModComponents.MODIFIER_ID.get()) && stack.has((DataComponentType)ModComponents.MODIFIER_UUID.get());
    }

    public static void removeModifier(ItemStack stack) {
        stack.remove((DataComponentType)ModComponents.MODIFIER_ID.get());
        stack.remove((DataComponentType)ModComponents.HAS_MODIFIER.get());
    }

    public Component getName(ItemStack stack) {
        String modifierId = ModifierItem.getModifierId(stack);
        ModifierConfig.ModifierEntry modifier = ModifierConfig.getInstance().getModifier(modifierId);
        if (modifier != null) {
            String translationKey = "modifier.baublesreforked." + modifierId;
            MutableComponent translatedName = Component.translatable((String)translationKey);
            String translatedString = translatedName.getString();
            if (!translatedString.equals(translationKey)) {
                return translatedName.withStyle(ChatFormatting.valueOf((String)modifier.color));
            }
            return Component.literal((String)modifier.name).withStyle(ChatFormatting.valueOf((String)modifier.color));
        }
        return super.getName(stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        String modifierId = ModifierItem.getModifierId(stack);
        ModifierConfig.ModifierEntry modifier = ModifierConfig.getInstance().getModifier(modifierId);
        if (modifier != null) {
            for (ModifierConfig.AttributeEntry attr : modifier.attributes) {
                String formattedValue = attr.id.equals("baublesreforked:life_steal") || attr.id.equals("minecraft:generic.knockback_resistance") ? String.format("%+.1f%%", attr.value * 100.0) : (attr.operation.equals("ADD_VALUE") ? (attr.value == (double)((int)attr.value) ? String.format("%+d", (int)attr.value) : String.format("%+.2f", attr.value)) : String.format("%+.1f%%", attr.value * 100.0));
                MutableComponent attrComponent = Component.translatable((String)("attribute.name." + attr.id)).append(" " + formattedValue).withStyle(attr.value >= 0.0 ? ChatFormatting.GREEN : ChatFormatting.RED);
                tooltipComponents.add((Component)attrComponent);
            }
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.baublesreforked.tooltip").withStyle(ChatFormatting.BLUE));
        }
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }
}

