/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.baublesreforked.mixin;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.jinqinxixi.baublesreforked.config.ModifierConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.client.event.AddAttributeTooltipsEvent;
import net.neoforged.neoforge.client.event.GatherSkippedAttributeTooltipsEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.AttributeTooltipContext;
import net.neoforged.neoforge.common.util.AttributeUtil;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.client.ClientEventHandler;

@Mixin(value={ClientEventHandler.class})
public class CuriosTooltipMixin {
    private boolean isOurModifierAttribute(AttributeModifier modifier) {
        return modifier.id().getNamespace().equals("baublesreforked");
    }

    @Inject(method={"onAttributeTooltip"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void onAttributeTooltipInject(AddAttributeTooltipsEvent evt, CallbackInfo ci) {
        if (!ModifierConfig.getInstance().isCustomTooltipEnabled()) {
            return;
        }
        AttributeTooltipContext context = evt.getContext();
        ItemStack stack = evt.getStack();
        Player player = context.player();
        GatherSkippedAttributeTooltipsEvent skipped = (GatherSkippedAttributeTooltipsEvent)NeoForge.EVENT_BUS.post((Event)new GatherSkippedAttributeTooltipsEvent(stack, context));
        if (skipped.isSkippingAll()) {
            return;
        }
        List<String> slots = CuriosTooltipMixin.getItemStackSlots(stack, player);
        if (slots.isEmpty()) {
            return;
        }
        ArrayList<MutableComponent> attributesTooltip = new ArrayList<MutableComponent>();
        HashMap slotAttributeMap = new HashMap();
        for (String identifier : slots) {
            SlotContext slotContext = new SlotContext(identifier, (LivingEntity)player, 0, false, true);
            Multimap attributes = CuriosApi.getAttributeModifiers((SlotContext)slotContext, (ResourceLocation)CuriosApi.getSlotId((SlotContext)slotContext), (ItemStack)stack);
            attributes.values().removeIf(modifier -> skipped.isSkipped(modifier.id()));
            if (attributes.isEmpty()) continue;
            ArrayList attributeLines = new ArrayList();
            if (player != null) {
                if (ModifierConfig.getInstance().hideModifierAttributes()) {
                    HashMultimap filteredAttributes = HashMultimap.create();
                    attributes.entries().forEach(arg_0 -> this.lambda$onAttributeTooltipInject$1((Multimap)filteredAttributes, arg_0));
                    attributes = filteredAttributes;
                }
                if (!attributes.isEmpty()) {
                    AttributeUtil.applyTextFor((ItemStack)stack, attributeLines::add, (Multimap)attributes, (AttributeTooltipContext)AttributeTooltipContext.of((Player)player, (Item.TooltipContext)context, (TooltipFlag)context.flag()));
                }
            }
            if (attributeLines.isEmpty()) continue;
            slotAttributeMap.put(identifier, attributeLines);
        }
        if (!slotAttributeMap.isEmpty()) {
            attributesTooltip.add(Component.empty());
            HashMap groupedAttributes = new HashMap();
            for (Map.Entry entry : slotAttributeMap.entrySet()) {
                String slot = (String)entry.getKey();
                List attributes = (List)entry.getValue();
                boolean found = false;
                for (Map.Entry group : groupedAttributes.entrySet()) {
                    if (!attributes.equals(group.getValue())) continue;
                    ((List)group.getKey()).add(slot);
                    found = true;
                    break;
                }
                if (found) continue;
                ArrayList<String> newGroup = new ArrayList<String>();
                newGroup.add(slot);
                groupedAttributes.put(newGroup, attributes);
            }
            for (Map.Entry group : groupedAttributes.entrySet()) {
                MutableComponent slotsText = Component.empty();
                List groupSlots = (List)group.getKey();
                Collections.sort(groupSlots);
                for (int j = 0; j < groupSlots.size(); ++j) {
                    if (j > 0) {
                        slotsText.append("/");
                    }
                    slotsText.append((Component)Component.translatable((String)("curios.identifier." + (String)groupSlots.get(j))));
                }
                attributesTooltip.add(Component.translatable((String)"baublesreforked.tooltip.when_equipped", (Object[])new Object[]{slotsText}).withStyle(ChatFormatting.GOLD));
                attributesTooltip.addAll((Collection)group.getValue());
            }
        }
        evt.addTooltipLines(((List)CuriosApi.getCurio((ItemStack)stack).map(curio -> curio.getAttributesTooltip(attributesTooltip, (Item.TooltipContext)context)).orElse(attributesTooltip)).toArray(new Component[0]));
        ci.cancel();
    }

    @Inject(method={"onTooltip"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void onTooltipInject(ItemTooltipEvent evt, CallbackInfo ci) {
        if (!ModifierConfig.getInstance().isCustomTooltipEnabled()) {
            return;
        }
        ItemStack stack = evt.getItemStack();
        Player player = evt.getEntity();
        if (stack.isEmpty()) {
            return;
        }
        List<String> slots = CuriosTooltipMixin.getItemStackSlots(stack, player);
        if (slots.isEmpty()) {
            return;
        }
        MutableComponent slotsTooltip = Component.translatable((String)"curios.tooltip.slot").append(" ").withStyle(ChatFormatting.GOLD);
        for (int j = 0; j < slots.size(); ++j) {
            String key = "curios.identifier." + slots.get(j);
            MutableComponent type = Component.translatable((String)key);
            if (j < slots.size() - 1) {
                type = type.append(", ");
            }
            type = type.withStyle(ChatFormatting.YELLOW);
            slotsTooltip.append((Component)type);
        }
        Item.TooltipContext context = evt.getContext();
        List tooltip = evt.getToolTip();
        Optional curio = CuriosApi.getCurio((ItemStack)stack);
        tooltip.addAll(1, curio.map(value -> value.getSlotsTooltip(List.of(slotsTooltip), context)).orElseGet(() -> List.of(slotsTooltip)));
        ci.cancel();
    }

    private static List<String> getItemStackSlots(ItemStack stack, Player player) {
        Set<Object> tags = Set.copyOf((player != null ? CuriosApi.getItemStackSlots((ItemStack)stack, (LivingEntity)player) : CuriosApi.getItemStackSlots((ItemStack)stack, (FMLLoader.getDist() == Dist.CLIENT ? 1 : 0) != 0)).keySet());
        if (tags.contains("curio")) {
            tags = Set.of("curio");
        }
        return new ArrayList<String>(tags);
    }

    private /* synthetic */ void lambda$onAttributeTooltipInject$1(Multimap filteredAttributes, Map.Entry entry) {
        if (!this.isOurModifierAttribute((AttributeModifier)entry.getValue())) {
            filteredAttributes.put((Object)((Holder)entry.getKey()), (Object)((AttributeModifier)entry.getValue()));
        }
    }
}

