/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.baublesreforked.modifier;

import com.jinqinxixi.baublesreforked.config.ModifierConfig;
import com.jinqinxixi.baublesreforked.data.ModComponents;
import com.jinqinxixi.baublesreforked.items.ModifierItem;
import com.jinqinxixi.baublesreforked.modifier.AttributeResolver;
import com.jinqinxixi.baublesreforked.network.NetworkHandler;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AnvilUpdateEvent;
import net.neoforged.neoforge.event.entity.player.AnvilRepairEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.theillusivec4.curios.api.event.CurioAttributeModifierEvent;
import top.theillusivec4.curios.api.event.CurioChangeEvent;

@EventBusSubscriber(modid="baublesreforked")
public class CurioAttributeEvents {
    private static final Logger LOGGER = LoggerFactory.getLogger(CurioAttributeEvents.class);
    private static ModifierConfig config;
    public static final int DEFAULT_MATERIAL_COST = 1;

    public static void init() {
        ModifierConfig.getInstance();
        config = ModifierConfig.getInstance();
        AttributeResolver.initializeCache();
    }

    @SubscribeEvent
    public static void onLivingUpdate(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        player.getInventory().items.forEach(stack -> {
            String itemId = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString();
            if (config.isItemModifiable(itemId)) {
                CurioAttributeEvents.checkAndInitializeModifier(stack, player);
            }
        });
    }

    private static void processAttribute(ModifierConfig.AttributeEntry attr, UUID baseUuid, String itemId, ModifierConfig.ModifierEntry modifier, AttributeProcessor processor) {
        if (attr == null || baseUuid == null || itemId == null || modifier == null || processor == null) {
            LOGGER.warn("Null parameter passed to processAttribute");
            return;
        }
        try {
            Attribute attribute = AttributeResolver.resolveAttribute(attr.id);
            if (attribute == null) {
                LOGGER.error("Could not resolve attribute: {}", (Object)attr.id);
                return;
            }
            String modifierIdStr = config.getModifierIdByName(modifier.name);
            if (modifierIdStr == null) {
                LOGGER.error("Could not find modifier ID for name: {}", (Object)modifier.name);
                return;
            }
            ResourceLocation modifierId = ResourceLocation.fromNamespaceAndPath((String)"baublesreforked", (String)String.format("%s_%s_%s", modifierIdStr, attr.id.replace(':', '_'), baseUuid.toString().substring(0, 8)).toLowerCase());
            AttributeModifier attributeModifier = new AttributeModifier(modifierId, attr.value, AttributeModifier.Operation.valueOf((String)attr.operation));
            processor.process(attribute, attributeModifier);
        }
        catch (Exception e) {
            LOGGER.error("Error processing attribute {} for item {}: {}", new Object[]{attr.id, itemId, e.getMessage()});
        }
    }

    private static void checkAndInitializeModifier(ItemStack stack, Player player) {
        UUID modifierUUID;
        String currentModifierId;
        ModifierConfig.ModifierEntry modifier;
        if (stack.isEmpty()) {
            return;
        }
        String itemId = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString();
        boolean needsSync = false;
        if (!stack.has((DataComponentType)ModComponents.IS_INITIALIZED.get())) {
            boolean shouldHaveModifier;
            double modifierChance = config.getModifierChance();
            boolean bl = shouldHaveModifier = (double)player.getRandom().nextFloat() < modifierChance;
            if (shouldHaveModifier) {
                try {
                    ModifierConfig.ModifierEntry randomModifier = config.getRandomModifier();
                    if (randomModifier != null) {
                        UUID modifierUUID2 = UUID.randomUUID();
                        String modifierId = config.getModifierIdByName(randomModifier.name);
                        if (modifierId != null) {
                            stack.set((DataComponentType)ModComponents.MODIFIER_ID.get(), (Object)modifierId);
                            stack.set((DataComponentType)ModComponents.MODIFIER_UUID.get(), (Object)modifierUUID2);
                            stack.set((DataComponentType)ModComponents.HAS_MODIFIER.get(), (Object)true);
                            needsSync = true;
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Failed to generate modifier for item {}: {}", (Object)itemId, (Object)e.getMessage());
                }
            }
            stack.set((DataComponentType)ModComponents.IS_INITIALIZED.get(), (Object)true);
        } else if (ModifierItem.hasModifier(stack) && (modifier = config.getModifier(currentModifierId = ModifierItem.getModifierId(stack))) == null) {
            try {
                ModifierConfig.ModifierEntry randomModifier = config.getRandomModifier();
                if (randomModifier != null) {
                    modifierUUID = UUID.randomUUID();
                    String modifierId = config.getModifierIdByName(randomModifier.name);
                    if (modifierId != null) {
                        stack.set((DataComponentType)ModComponents.MODIFIER_ID.get(), (Object)modifierId);
                        stack.set((DataComponentType)ModComponents.MODIFIER_UUID.get(), (Object)modifierUUID);
                        stack.set((DataComponentType)ModComponents.HAS_MODIFIER.get(), (Object)true);
                        needsSync = true;
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to regenerate modifier for item {}: {}", (Object)itemId, (Object)e.getMessage());
            }
        }
        if (needsSync && !player.level().isClientSide && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            int slot = player.getInventory().findSlotMatchingItem(stack);
            if (slot >= 0) {
                String modifierId = (String)stack.getOrDefault((DataComponentType)ModComponents.MODIFIER_ID.get(), (Object)"");
                modifierUUID = (UUID)stack.getOrDefault((DataComponentType)ModComponents.MODIFIER_UUID.get(), null);
                if (!modifierId.isEmpty() && modifierUUID != null) {
                    NetworkHandler.sendToClient(serverPlayer, stack, modifierId, modifierUUID, slot);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onCurioAttributeModifier(CurioAttributeModifierEvent event) {
        ItemStack stack = event.getItemStack();
        String itemId = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString();
        if (!config.isItemModifiable(itemId)) {
            return;
        }
        if (!ModifierItem.hasModifier(stack)) {
            return;
        }
        try {
            String modifierId = ModifierItem.getModifierId(stack);
            UUID baseUuid = (UUID)stack.getOrDefault((DataComponentType)ModComponents.MODIFIER_UUID.get(), null);
            ModifierConfig.ModifierEntry modifier = config.getModifier(modifierId);
            if (modifier == null || baseUuid == null) {
                return;
            }
            for (ModifierConfig.AttributeEntry attr : modifier.attributes) {
                CurioAttributeEvents.processAttribute(attr, baseUuid, itemId, modifier, (attribute, attributeModifier) -> {
                    Holder.Reference attributeHolder = BuiltInRegistries.ATTRIBUTE.getHolderOrThrow((ResourceKey)BuiltInRegistries.ATTRIBUTE.getResourceKey((Object)attribute).get());
                    event.addModifier((Holder)attributeHolder, attributeModifier);
                });
            }
        }
        catch (Exception e) {
            LOGGER.error("Error applying modifier for item {}: {}", (Object)itemId, (Object)e.getMessage());
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        float maxHealth;
        Player player = event.getEntity();
        float currentHealth = player.getHealth();
        if (currentHealth > (maxHealth = player.getMaxHealth())) {
            player.hurt(player.damageSources().generic(), 0.0f);
            player.setHealth(maxHealth);
        } else if (Math.abs(currentHealth - player.getHealth()) > 0.01f) {
            player.hurt(player.damageSources().generic(), 0.0f);
            player.setHealth(currentHealth);
        }
    }

    @SubscribeEvent
    public static void onCurioChange(CurioChangeEvent event) {
        ItemStack removedStack = event.getFrom();
        ItemStack addedStack = event.getTo();
        if (removedStack.isEmpty()) {
            return;
        }
        String itemId = BuiltInRegistries.ITEM.getKey((Object)removedStack.getItem()).toString();
        if (!config.isItemModifiable(itemId)) {
            return;
        }
        if (CurioAttributeEvents.hasSameModifier(removedStack, addedStack)) {
            return;
        }
        CurioAttributeEvents.removeModifierFromStack(removedStack, (Entity)event.getEntity());
    }

    private static boolean hasSameModifier(ItemStack stack1, ItemStack stack2) {
        if (stack1.isEmpty() || stack2.isEmpty()) {
            return false;
        }
        if (!ModifierItem.hasModifier(stack1) || !ModifierItem.hasModifier(stack2)) {
            return false;
        }
        UUID uuid1 = (UUID)stack1.getOrDefault((DataComponentType)ModComponents.MODIFIER_UUID.get(), null);
        UUID uuid2 = (UUID)stack2.getOrDefault((DataComponentType)ModComponents.MODIFIER_UUID.get(), null);
        return uuid1 != null && uuid1.equals(uuid2);
    }

    private static void removeModifierFromStack(ItemStack stack, Entity entity) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!ModifierItem.hasModifier(stack)) {
            return;
        }
        try {
            String modifierId = ModifierItem.getModifierId(stack);
            UUID baseUuid = (UUID)stack.getOrDefault((DataComponentType)ModComponents.MODIFIER_UUID.get(), null);
            ModifierConfig.ModifierEntry modifier = config.getModifier(modifierId);
            if (modifier == null || baseUuid == null) {
                return;
            }
            for (ModifierConfig.AttributeEntry attr : modifier.attributes) {
                CurioAttributeEvents.processAttribute(attr, baseUuid, BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString(), modifier, (attribute, attributeModifier) -> {
                    Holder.Reference attributeHolder = BuiltInRegistries.ATTRIBUTE.getHolderOrThrow((ResourceKey)BuiltInRegistries.ATTRIBUTE.getResourceKey((Object)attribute).get());
                    AttributeInstance instance = player.getAttribute((Holder)attributeHolder);
                    if (instance != null) {
                        instance.removeModifier(attributeModifier.id());
                        if (attributeHolder.value() == Attributes.MAX_HEALTH) {
                            player.setHealth(Math.min(player.getHealth(), player.getMaxHealth()));
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            LOGGER.error("Error removing modifier from item {}: {}", (Object)BuiltInRegistries.ITEM.getKey((Object)stack.getItem()), (Object)e.getMessage());
        }
    }

    @SubscribeEvent
    public static void onAnvilUpdate(AnvilUpdateEvent event) {
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        if (left.isEmpty() || right.isEmpty()) {
            return;
        }
        String leftItemId = BuiltInRegistries.ITEM.getKey((Object)left.getItem()).toString();
        if (!config.isItemModifiable(leftItemId)) {
            return;
        }
        if (right.getItem() instanceof ModifierItem) {
            CurioAttributeEvents.handleModifierBook(event, left, right);
            return;
        }
        String rightItemId = BuiltInRegistries.ITEM.getKey((Object)right.getItem()).toString();
        ModifierConfig.ReforgeConfig reforgeConfig = config.getReforgeConfig(leftItemId);
        if (reforgeConfig != null && rightItemId.equals(reforgeConfig.requiredItem)) {
            CurioAttributeEvents.handleReforge(event, left, reforgeConfig);
        }
    }

    private static void handleModifierBook(AnvilUpdateEvent event, ItemStack left, ItemStack right) {
        String modifierId = ModifierItem.getModifierId(right);
        if (modifierId.isEmpty()) {
            return;
        }
        ModifierConfig.ModifierEntry modifier = config.getModifier(modifierId);
        if (modifier == null) {
            return;
        }
        ItemStack output = left.copy();
        output.set((DataComponentType)ModComponents.MODIFIER_ID.get(), (Object)modifierId);
        output.set((DataComponentType)ModComponents.MODIFIER_UUID.get(), (Object)UUID.randomUUID());
        output.set((DataComponentType)ModComponents.HAS_MODIFIER.get(), (Object)true);
        String newName = event.getName();
        if (newName != null && !newName.isEmpty() && !newName.equals(left.getHoverName().getString())) {
            output.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)newName));
        }
        event.setOutput(output);
        event.setCost((long)config.getModifierBookExperience());
        event.setMaterialCost(1);
    }

    private static void handleReforge(AnvilUpdateEvent event, ItemStack left, ModifierConfig.ReforgeConfig reforgeConfig) {
        String newName;
        String modifierId;
        ItemStack output = left.copy();
        ModifierItem.removeModifier(output);
        ModifierConfig.ModifierEntry newModifier = config.getRandomModifier();
        if (newModifier != null && (modifierId = config.getModifierIdByName(newModifier.name)) != null) {
            output.set((DataComponentType)ModComponents.MODIFIER_ID.get(), (Object)modifierId);
            output.set((DataComponentType)ModComponents.MODIFIER_UUID.get(), (Object)UUID.randomUUID());
            output.set((DataComponentType)ModComponents.HAS_MODIFIER.get(), (Object)true);
        }
        if ((newName = event.getName()) != null && !newName.isEmpty() && !newName.equals(left.getHoverName().getString())) {
            output.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)newName));
        }
        event.setOutput(output);
        event.setCost((long)reforgeConfig.experienceCost);
        event.setMaterialCost(reforgeConfig.materialCost);
    }

    @SubscribeEvent
    public static void onAnvilRepair(AnvilRepairEvent event) {
        ItemStack result = event.getOutput();
        ItemStack right = event.getRight();
        if (result.isEmpty()) {
            return;
        }
        String itemId = BuiltInRegistries.ITEM.getKey((Object)result.getItem()).toString();
        if (!config.isItemModifiable(itemId)) {
            return;
        }
        try {
            String modifierId;
            if (right.getItem() instanceof ModifierItem && !(modifierId = ModifierItem.getModifierId(right)).isEmpty() && !ModifierItem.hasModifier(result)) {
                result.set((DataComponentType)ModComponents.MODIFIER_ID.get(), (Object)modifierId);
                result.set((DataComponentType)ModComponents.MODIFIER_UUID.get(), (Object)UUID.randomUUID());
                result.set((DataComponentType)ModComponents.HAS_MODIFIER.get(), (Object)true);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error applying modifier for anvil result {}: {}", (Object)itemId, (Object)e.getMessage());
        }
    }

    @FunctionalInterface
    private static interface AttributeProcessor {
        public void process(Attribute var1, AttributeModifier var2);
    }
}

