/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.baublesreforked.modifier;

import com.jinqinxixi.baublesreforked.config.ModifierConfig;
import com.jinqinxixi.baublesreforked.data.ModComponents;
import com.jinqinxixi.baublesreforked.items.ModifierItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AnvilScreen;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

@EventBusSubscriber(value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.GAME)
public class ModifierTooltipHelper {
    private static MutableComponent getModifierDisplayName(String modifierId, ModifierConfig.ModifierEntry modifier) {
        String translationKey = "modifier.baublesreforked." + modifierId;
        MutableComponent translatedName = Component.translatable((String)translationKey);
        String translatedString = translatedName.getString();
        if (!translatedString.equals(translationKey)) {
            return translatedName.append("\uff1a").withStyle(ChatFormatting.valueOf((String)modifier.color));
        }
        return Component.literal((String)(modifier.name + "\uff1a")).withStyle(ChatFormatting.valueOf((String)modifier.color));
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onItemTooltip(ItemTooltipEvent event) {
        boolean isInitialized;
        AnvilScreen anvilScreen;
        ItemStack resultSlotItem;
        if (!ModifierConfig.getInstance().useModifierTooltip()) {
            return;
        }
        ItemStack stack = event.getItemStack();
        List tooltip = event.getToolTip();
        String itemId = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString();
        ModifierConfig config = ModifierConfig.getInstance();
        if (!config.isItemModifiable(itemId)) {
            return;
        }
        boolean isAnvilPreview = false;
        boolean isRenamingOnly = false;
        ItemStack rightSlotItem = null;
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof AnvilScreen && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)(resultSlotItem = ((AnvilMenu)(anvilScreen = (AnvilScreen)screen).getMenu()).getSlot(2).getItem()))) {
            isAnvilPreview = true;
            rightSlotItem = ((AnvilMenu)anvilScreen.getMenu()).getSlot(1).getItem();
            ItemStack leftSlotItem = ((AnvilMenu)anvilScreen.getMenu()).getSlot(0).getItem();
            if (rightSlotItem.isEmpty()) {
                isRenamingOnly = true;
            } else {
                String rightItemId = BuiltInRegistries.ITEM.getKey((Object)rightSlotItem.getItem()).toString();
                ModifierConfig.ReforgeConfig reforgeConfig = config.getReforgeConfig(itemId);
                if (reforgeConfig == null || !rightItemId.equals(reforgeConfig.requiredItem)) {
                    isRenamingOnly = true;
                }
            }
        }
        boolean bl = isInitialized = stack.has((DataComponentType)ModComponents.IS_INITIALIZED.get()) && (Boolean)stack.get((DataComponentType)ModComponents.IS_INITIALIZED.get()) != false;
        if (isAnvilPreview) {
            ModifierTooltipHelper.handleAnvilPreview(tooltip, stack, rightSlotItem, isRenamingOnly, config);
        } else if (!isInitialized) {
            tooltip.add(Component.translatable((String)"tooltip.baublesreforked.unidentified").withStyle(ChatFormatting.GRAY));
        } else if (ModifierItem.hasModifier(stack)) {
            ModifierTooltipHelper.handleModifierDisplay(tooltip, stack, config);
        }
    }

    private static void handleAnvilPreview(List<Component> tooltip, ItemStack stack, ItemStack rightSlotItem, boolean isRenamingOnly, ModifierConfig config) {
        if (isRenamingOnly) {
            if (ModifierItem.hasModifier(stack)) {
                ModifierTooltipHelper.handleModifierDisplay(tooltip, stack, config);
            }
        } else if (rightSlotItem != null && rightSlotItem.getItem() instanceof ModifierItem) {
            ModifierConfig.ModifierEntry modifier;
            String modifierId = ModifierItem.getModifierId(rightSlotItem);
            if (!modifierId.isEmpty() && (modifier = config.getModifier(modifierId)) != null) {
                tooltip.add((Component)ModifierTooltipHelper.getModifierDisplayName(modifierId, modifier));
                ModifierTooltipHelper.addAttributesTooltips(tooltip, modifier);
            }
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.baublesreforked.unidentified").withStyle(ChatFormatting.GRAY));
        }
    }

    private static void handleModifierDisplay(List<Component> tooltip, ItemStack stack, ModifierConfig config) {
        try {
            String modifierId = ModifierItem.getModifierId(stack);
            ModifierConfig.ModifierEntry modifier = config.getModifier(modifierId);
            if (modifier != null) {
                tooltip.add((Component)ModifierTooltipHelper.getModifierDisplayName(modifierId, modifier));
                ModifierTooltipHelper.addAttributesTooltips(tooltip, modifier);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void addAttributesTooltips(List<Component> tooltip, ModifierConfig.ModifierEntry modifier) {
        for (ModifierConfig.AttributeEntry attr : modifier.attributes) {
            String formattedValue = attr.id.equals("baublesreforked:life_steal") || attr.id.equals("minecraft:generic.knockback_resistance") ? String.format("%+.1f%%", attr.value * 100.0) : (AttributeModifier.Operation.valueOf((String)attr.operation) == AttributeModifier.Operation.ADD_VALUE ? (attr.value == (double)((int)attr.value) ? String.format("%+d", (int)attr.value) : String.format("%+.2f", attr.value)) : String.format("%+.1f%%", attr.value * 100.0));
            tooltip.add((Component)Component.translatable((String)("attribute.name." + attr.id)).withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)(" " + formattedValue)).withStyle(attr.value >= 0.0 ? ChatFormatting.GREEN : ChatFormatting.RED)));
        }
    }
}

