/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.baublesreforked.network;

import com.jinqinxixi.baublesreforked.data.ModComponents;
import com.jinqinxixi.baublesreforked.items.ModifierItem;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ModifierSyncMessage(String modifierId, UUID modifierUUID, int slot) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"baublesreforked", (String)"modifier_sync");
    public static final CustomPacketPayload.Type<ModifierSyncMessage> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<FriendlyByteBuf, ModifierSyncMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, ModifierSyncMessage::modifierId, (StreamCodec)UUIDUtil.STREAM_CODEC, ModifierSyncMessage::modifierUUID, (StreamCodec)ByteBufCodecs.INT, ModifierSyncMessage::slot, ModifierSyncMessage::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(ModifierSyncMessage message, IPayloadContext context) {
        context.enqueueWork(() -> {
            ItemStack stack;
            if (context.player() != null && !(stack = (ItemStack)context.player().getInventory().items.get(message.slot())).isEmpty()) {
                if (message.modifierId() != null && !message.modifierId().isEmpty() && message.modifierUUID() != null) {
                    stack.set((DataComponentType)ModComponents.MODIFIER_ID.get(), (Object)message.modifierId());
                    stack.set((DataComponentType)ModComponents.MODIFIER_UUID.get(), (Object)message.modifierUUID());
                    stack.set((DataComponentType)ModComponents.HAS_MODIFIER.get(), (Object)true);
                } else {
                    ModifierItem.removeModifier(stack);
                }
                stack.set((DataComponentType)ModComponents.IS_INITIALIZED.get(), (Object)true);
            }
        });
    }
}

