/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.baublesreforked.config;

import com.jinqinxixi.baublesreforked.BaublesReforkedMod;
import com.jinqinxixi.baublesreforked.modifier.AttributeResolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.loading.FMLLoader;
import org.apache.commons.lang3.tuple.Pair;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="baublesreforked", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModifierConfig {
    public static final ForgeConfigSpec SPEC;
    public static final ModifierConfig INSTANCE;
    private final ForgeConfigSpec.BooleanValue globalReforgeEnabled;
    private final ForgeConfigSpec.ConfigValue<String> globalReforgeItem;
    private final ForgeConfigSpec.IntValue globalReforgeExperience;
    private final ForgeConfigSpec.IntValue globalReforgeMaterial;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> modifiableItemsList;
    private final ForgeConfigSpec.BooleanValue autoDetectCurios;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> blacklistedItems;
    private final ForgeConfigSpec.IntValue modifierBookExperience;
    private final ForgeConfigSpec.BooleanValue hideModifierAttributes;
    private final ForgeConfigSpec.BooleanValue useModifierTooltip;
    private final ForgeConfigSpec.BooleanValue enableCustomTooltip;
    private final ForgeConfigSpec.DoubleValue modifierApplyProbability;
    private final ForgeConfigSpec.BooleanValue defaultModifiersEnabled;
    private final Map<String, ModifierData> defaultModifiers = new HashMap<String, ModifierData>();
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> customModifiers;
    private Map<String, ModifierEntry> modifiers = new HashMap<String, ModifierEntry>();
    private Map<String, ReforgeConfig> modifiableItems = new HashMap<String, ReforgeConfig>();
    private GlobalReforgeConfig globalReforge = new GlobalReforgeConfig();
    private static final Set<String> VALID_COLORS;
    private static final String DEFAULT_COLOR = "GRAY";

    public ModifierConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("\u9970\u54c1\u91cd\u94f8 - \u914d\u7f6e\u6587\u4ef6").push("general");
        builder.comment("\u81ea\u52a8\u68c0\u6d4b\u8bbe\u7f6e").push("autoDetect");
        this.autoDetectCurios = builder.comment(new String[]{"\u662f\u5426\u81ea\u52a8\u68c0\u6d4b\u6240\u6709\u652f\u6301Curios API\u7684\u9970\u54c1", "\u542f\u7528\u540e,\u6240\u6709Curios\u9970\u54c1\u90fd\u53ef\u4ee5\u83b7\u5f97\u968f\u673a\u5c5e\u6027\u5e76\u652f\u6301\u91cd\u94f8"}).define("enableCuriosAutoDetect", true);
        builder.pop();
        builder.comment("\u663e\u793a\u8bbe\u7f6e").push("display");
        this.enableCustomTooltip = builder.comment(new String[]{"\u542f\u7528Curios\u9970\u54c1\u5c5e\u6027\u63d0\u793a\u4fe1\u606f\u5904\u7406", "true - \u5408\u5e76\u663e\u793a(\u591a\u4e2a\u76f8\u540c\u5c5e\u6027\u7684\u69fd\u4f4d\u4f1a\u5408\u5e76\u5728\u4e00\u8d77\u663e\u793a)", "false - Curios\u9ed8\u8ba4\u5904\u7406(\u6bcf\u4e2a\u69fd\u4f4d\u5355\u72ec\u663e\u793a\u5c5e\u6027)"}).define("enableCustomTooltip", true);
        this.hideModifierAttributes = builder.comment(new String[]{"\u662f\u5426\u5728Curios\u5c5e\u6027\u663e\u793a\u90e8\u5206\u9690\u85cf\u672c\u6a21\u7ec4\u7684\u4fee\u9970\u7b26\u5c5e\u6027", "true - \u9690\u85cf\u672c\u6a21\u7ec4\u6dfb\u52a0\u7684\u4fee\u9970\u7b26\u5c5e\u6027", "false - \u663e\u793a\u672c\u6a21\u7ec4\u6dfb\u52a0\u7684\u4fee\u9970\u7b26\u5c5e\u6027"}).define("hideModifierAttributes", true);
        this.useModifierTooltip = builder.comment(new String[]{"\u662f\u5426\u4f7f\u7528\u4fee\u9970\u7b26\u7684\u81ea\u5b9a\u4e49\u63d0\u793a\u6846", "true - \u4f7f\u7528\u81ea\u5b9a\u4e49\u63d0\u793a\u6846\u663e\u793a\u4fee\u9970\u7b26\u540d\u79f0\u548c\u5c5e\u6027", "false - \u4f7f\u7528\u539f\u7248Curios\u7684\u5c5e\u6027\u663e\u793a\u65b9\u5f0f"}).define("useModifierTooltip", true);
        builder.pop();
        builder.comment("\u6982\u7387\u8bbe\u7f6e").push("probability");
        this.modifierApplyProbability = builder.comment(new String[]{"\u9970\u54c1\u83b7\u5f97\u4fee\u9970\u7b26\u7684\u6982\u7387 (0.0 - 1.0)", "\u9ed8\u8ba4\u503c: 1.0 (100%\u6982\u7387)", "\u8bbe\u7f6e\u4e3a 0.0 \u8868\u793a\u6c38\u8fdc\u4e0d\u4f1a\u83b7\u5f97\u4fee\u9970\u7b26", "\u8bbe\u7f6e\u4e3a 1.0 \u8868\u793a\u603b\u662f\u83b7\u5f97\u4fee\u9970\u7b26"}).defineInRange("modifierApplyProbability", 1.0, 0.0, 1.0);
        builder.pop();
        builder.comment("\u5168\u5c40\u91cd\u94f8\u8bbe\u7f6e").push("globalReforge");
        this.globalReforgeEnabled = builder.comment("\u662f\u5426\u542f\u7528\u5168\u5c40\u91cd\u94f8\u8bbe\u7f6e").define("enabled", false);
        this.globalReforgeItem = builder.comment("\u91cd\u94f8\u6240\u9700\u7269\u54c1").define("requiredItem", (Object)"minecraft:diamond");
        this.globalReforgeExperience = builder.comment(new String[]{"\u91cd\u94f8\u6240\u9700\u7ecf\u9a8c\u7b49\u7ea7", "min\uff1a0  max\uff1a2147483647"}).defineInRange("experienceCost", 5, 0, Integer.MAX_VALUE);
        this.globalReforgeMaterial = builder.comment(new String[]{"\u91cd\u94f8\u6240\u9700\u6750\u6599\u6570\u91cf", "min\uff1a0  max\uff1a2147483647"}).defineInRange("materialCost", 1, 0, Integer.MAX_VALUE);
        builder.pop();
        builder.comment("\u4fee\u9970\u7b26\u4e66\u8bbe\u7f6e").push("modifierBook");
        this.modifierBookExperience = builder.comment("\u4f7f\u7528\u4fee\u9970\u7b26\u4e66\u6240\u9700\u7684\u7ecf\u9a8c\u7b49\u7ea7").defineInRange("experienceCost", 5, 0, Integer.MAX_VALUE);
        builder.pop();
        builder.comment("\u53ef\u91cd\u94f8\u7269\u54c1\u8bbe\u7f6e").push("modifiableItems");
        this.modifiableItemsList = builder.comment(new String[]{"\u53ef\u91cd\u94f8\u7269\u54c1\u5217\u8868", "\u683c\u5f0f\u8bf4\u660e\uff1a\u7269\u54c1ID|\u91cd\u94f8\u6750\u6599|\u7ecf\u9a8c\u6d88\u8017|\u6750\u6599\u6d88\u8017", "\u793a\u4f8b\u683c\u5f0f:", "items = [", "    \"artifacts:cross_necklace|minecraft:diamond|5|1\",", "    \"artifacts:feral_claws|minecraft:diamond|10|2\"", "]"}).defineList("items", new ArrayList(), obj -> obj instanceof String);
        builder.pop();
        builder.comment("\u9ed1\u540d\u5355\u8bbe\u7f6e").push("blacklist");
        this.blacklistedItems = builder.comment(new String[]{"\u81ea\u52a8\u68c0\u6d4b\u9ed1\u540d\u5355", "\u5728\u8fd9\u91cc\u6dfb\u52a0\u4e0d\u60f3\u88ab\u81ea\u52a8\u68c0\u6d4b\u7684\u7269\u54c1ID", "\u5373\u4f7f\u7269\u54c1\u652f\u6301Curios\uff0c\u4e5f\u4e0d\u4f1a\u88ab\u81ea\u52a8\u6dfb\u52a0\u5230\u91cd\u94f8\u7cfb\u7edf\u4e2d", "\u683c\u5f0f\uff1a\u6bcf\u884c\u4e00\u4e2a\u7269\u54c1ID\uff0c\u6bcf\u4e2aID\u90fd\u9700\u8981\u7528\u5f15\u53f7\u5305\u88f9\uff0c\u7528\u9017\u53f7\u5206\u9694", "\u793a\u4f8b\u683c\u5f0f\uff1a", "items = [", "    \"minecraft:bundle\",", "    \"sophisticatedbackpacks:backpack\",", "    \"somemod:someitem\"", "]"}).defineList("items", new ArrayList(), obj -> obj instanceof String);
        builder.pop();
        builder.comment("\u4fee\u9970\u7b26\u8bbe\u7f6e").push("modifiers");
        builder.comment(new String[]{"\u4fee\u9970\u7b26\u5217\u8868", "", "=== \u683c\u5f0f\u8bf4\u660e ===", "\u683c\u5f0f\uff1a\u4fee\u9970\u7b26ID|\u663e\u793a\u540d\u79f0|\u989c\u8272|\u5c5e\u6027\u5217\u8868|\u6743\u91cd", "\u5c5e\u6027\u5217\u8868\u683c\u5f0f\uff1a\u5c5e\u6027ID,\u6570\u503c,\u64cd\u4f5c\u7c7b\u578b#\u5c5e\u6027ID2,\u6570\u503c2,\u64cd\u4f5c\u7c7b\u578b2", "- \u4fee\u9970\u7b26ID\uff1a\u7528\u4e8e\u5185\u90e8\u8bc6\u522b\u7684\u552f\u4e00\u6807\u8bc6\u7b26", "- \u663e\u793a\u540d\u79f0\uff1a\u6e38\u620f\u4e2d\u663e\u793a\u7684\u540d\u79f0", "- \u989c\u8272\uff1a\u4f7f\u7528Minecraft\u7684\u989c\u8272\u4ee3\u7801\uff08\u5982AQUA, LIGHT_PURPLE\u7b49\uff09", "- \u5c5e\u6027\u5217\u8868\uff1a\u7528#\u5206\u9694\u7684\u591a\u4e2a\u5c5e\u6027\u914d\u7f6e", "- \u6743\u91cd\uff1a\u4fee\u9970\u7b26\u51fa\u73b0\u7684\u6982\u7387\u6743\u91cd", "", "=== \u4fee\u9970\u7b26ID\u8bf4\u660e ===", "\u5728\u914d\u7f6e\u4e2d\uff0c\u6bcf\u4e2a\u4fee\u9970\u7b26\u90fd\u9700\u8981\u4e00\u4e2a\u552f\u4e00\u7684ID\u4f5c\u4e3a\u6807\u8bc6\u7b26", "\u4f8b\u5982\uff1a\"tank\": { \"name\": \"\u5766\u514b\", ... }", "\u5176\u4e2d \"tank\" \u662f\u4fee\u9970\u7b26ID\uff0c\"\u5766\u514b\" \u662f\u6e38\u620f\u4e2d\u663e\u793a\u7684\u540d\u79f0", "", "ID\u547d\u540d\u89c4\u5219\uff1a", "1. \u5fc5\u987b\u662f\u552f\u4e00\u7684", "2. \u5efa\u8bae\u4f7f\u7528\u5c0f\u5199\u5b57\u6bcd", "3. \u53ef\u4ee5\u5305\u542b\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u4e0b\u5212\u7ebf", "4. \u4e0d\u8981\u4f7f\u7528\u7a7a\u683c\u548c\u7279\u6b8a\u5b57\u7b26", "5. \u5efa\u8bae\u4f7f\u7528\u6709\u610f\u4e49\u7684\u82f1\u6587\u5355\u8bcd", "", "\u6b63\u786e\u793a\u4f8b\uff1a", "\"fire_resistance\" - { \"name\": \"\u70c8\u7130\u5b88\u62a4\" }", "\"swift_striker\"  - { \"name\": \"\u5feb\u901f\u6253\u51fb\" }", "\"nature_boost\"   - { \"name\": \"\u81ea\u7136\u4e4b\u529b\" }", "", "\u9519\u8bef\u793a\u4f8b\uff1a", "\"123\"         - \u4e0d\u8981\u7528\u7eaf\u6570\u5b57", "\"\u4fee\u9970\u7b26\"      - \u4e0d\u8981\u7528\u4e2d\u6587\u4f5c\u4e3aID", "\"my modifier\" - \u4e0d\u8981\u5305\u542b\u7a7a\u683c", "", "=== \u6743\u91cd\u8bf4\u660e ===", "3.0 - \u5e38\u89c1\u4fee\u9970\u7b26\uff08\u7ea654.5%\u6982\u7387\uff09", "2.0 - \u4f18\u79c0\u4fee\u9970\u7b26\uff08\u7ea636.4%\u6982\u7387\uff09", "1.0 - \u7a00\u6709\u4fee\u9970\u7b26\uff08\u7ea618.2%\u6982\u7387\uff09", "0.5 - \u53f2\u8bd7\u4fee\u9970\u7b26\uff08\u7ea69.1%\u6982\u7387\uff09", "", "=== \u53ef\u7528\u989c\u8272 ===", "BLACK       - \u9ed1\u8272        DARK_BLUE   - \u6df1\u84dd\u8272", "DARK_GREEN  - \u6df1\u7eff\u8272      DARK_AQUA   - \u6df1\u9752\u8272", "DARK_RED    - \u6df1\u7ea2\u8272      DARK_PURPLE - \u6df1\u7d2b\u8272", "GOLD        - \u91d1\u8272        GRAY        - \u7070\u8272", "DARK_GRAY   - \u6df1\u7070\u8272      BLUE        - \u84dd\u8272", "GREEN       - \u7eff\u8272        AQUA        - \u9752\u8272", "RED         - \u7ea2\u8272        LIGHT_PURPLE- \u6de1\u7d2b\u8272", "YELLOW      - \u9ec4\u8272        WHITE       - \u767d\u8272", "", "=== \u64cd\u4f5c\u7c7b\u578b ===", "ADDITION       - \u52a0\u6cd5\uff0c\u76f4\u63a5\u589e\u52a0\u6216\u51cf\u5c11\u6570\u503c", "MULTIPLY_BASE  - \u57fa\u7840\u4e58\u6cd5\uff0c\u57fa\u4e8e\u57fa\u7840\u503c\u7684\u767e\u5206\u6bd4\u589e\u51cf", "MULTIPLY_TOTAL - \u603b\u503c\u4e58\u6cd5\uff0c\u57fa\u4e8e\u6700\u7ec8\u503c\u7684\u767e\u5206\u6bd4\u589e\u51cf", "", "=== \u53ef\u7528\u5c5e\u6027ID ===", "\u5c5e\u6027ID\u683c\u5f0f: modid:attribute_name", "\u4f8b\u5982: minecraft:generic.max_health \u6216 somemod:special_attribute", "\u4f60\u53ef\u4ee5\u4f7f\u7528\u4efb\u4f55\u5df2\u5b89\u88c5\u6a21\u7ec4\u6ce8\u518c\u7684\u5c5e\u6027,\u53ea\u9700\u8981\u63d0\u4f9b\u6b63\u786e\u7684\u5c5e\u6027ID\u5373\u53ef", "\u6e38\u620f\u4e2d\u53ef\u4ee5\u901a\u8fc7\u6307\u4ee4 /listattributes \u67e5\u770b\u5230\u6240\u6709\u5df2\u6ce8\u518c\u7684\u5c5e\u6027ID", "", "\u57fa\u7840\u5c5e\u6027\uff1a", "minecraft:generic.max_health           - \u6700\u5927\u751f\u547d\u503c", "minecraft:generic.follow_range         - \u8ddf\u968f\u8303\u56f4", "minecraft:generic.knockback_resistance - \u51fb\u9000\u6297\u6027 (0.0-1.0, 1.0\u4e3a\u5b8c\u5168\u514d\u75ab)", "minecraft:generic.movement_speed       - \u79fb\u52a8\u901f\u5ea6", "minecraft:generic.flying_speed         - \u98de\u884c\u901f\u5ea6", "minecraft:generic.attack_damage        - \u653b\u51fb\u4f24\u5bb3", "minecraft:generic.attack_knockback     - \u51fb\u9000\u5f3a\u5ea6", "minecraft:generic.attack_speed         - \u653b\u51fb\u901f\u5ea6", "minecraft:generic.armor                - \u62a4\u7532\u503c", "minecraft:generic.armor_toughness      - \u62a4\u7532\u97e7\u6027", "minecraft:generic.luck                 - \u5e78\u8fd0\u503c", "", "Forge\u5c5e\u6027\uff1a", "forge:swim_speed            - \u6e38\u6cf3\u901f\u5ea6", "forge:entity_gravity        - \u5b9e\u4f53\u91cd\u529b", "forge:block_reach           - \u65b9\u5757\u4ea4\u4e92\u8ddd\u79bb", "forge:entity_reach          - \u5b9e\u4f53\u4ea4\u4e92\u8ddd\u79bb", "forge:nametag_distance      - \u540d\u79f0\u6807\u7b7e\u663e\u793a\u8ddd\u79bb", "forge:step_height_addition  - \u6b65\u9ad8\u589e\u52a0", "", "\u672c\u6a21\u7ec4\u5c5e\u6027\uff1a", "baublesreforked:jump_strength  -\u8df3\u8dc3\u529b", "baublesreforked:life_steal     -\u5438\u8840", ""});
        builder.comment("\u9ed8\u8ba4\u4fee\u9970\u7b26\u8bbe\u7f6e").push("defaultModifierSettings");
        this.defaultModifiersEnabled = builder.comment("\u662f\u5426\u542f\u7528\u9ed8\u8ba4\u4fee\u9970\u7b26").define("enabled", true);
        builder.pop();
        builder.comment("\u81ea\u5b9a\u4e49\u4fee\u9970\u7b26\u8bbe\u7f6e").push("customModifiers");
        this.customModifiers = builder.comment(new String[]{"\u81ea\u5b9a\u4e49\u4fee\u9970\u7b26\u5217\u8868", "\u5728\u8fd9\u91cc\u6dfb\u52a0\u4f60\u7684\u81ea\u5b9a\u4e49\u4fee\u9970\u7b26", "\u683c\u5f0f\uff1a\u4fee\u9970\u7b26ID|\u663e\u793a\u540d\u79f0|\u989c\u8272|\u5c5e\u6027\u5217\u8868|\u6743\u91cd", "\u5c5e\u6027\u5217\u8868\u683c\u5f0f\uff1a\u5c5e\u6027ID,\u6570\u503c,\u64cd\u4f5c\u7c7b\u578b#\u5c5e\u6027ID2,\u6570\u503c2,\u64cd\u4f5c\u7c7b\u578b2", "\u793a\u4f8b\u683c\u5f0f:", "modifiers = [", "    \"mystic|\u795e\u79d8|LIGHT_PURPLE|minecraft:generic.max_health,2.0,ADDITION#minecraft:generic.luck,1.0,ADDITION|1.0\",", "    \"agile|\u7075\u5de7|AQUA|minecraft:generic.movement_speed,0.2,MULTIPLY_BASE#minecraft:generic.attack_speed,0.1,MULTIPLY_BASE|2.0\"", "]"}).defineList("modifiers", new ArrayList(), obj -> obj instanceof String);
        builder.pop();
        builder.comment("\u9ed8\u8ba4\u4fee\u9970\u7b26\u914d\u7f6e").push("defaultModifiers");
        this.addAllDefaultModifiers(builder);
        builder.pop();
        builder.pop();
        builder.pop();
    }

    private void addAllDefaultModifiers(ForgeConfigSpec.Builder builder) {
        this.addDefaultModifier(builder, "healthy", "\u751f\u673a", "GREEN", "minecraft:generic.max_health,2.0,ADDITION", 3.0);
        this.addDefaultModifier(builder, "armored", "\u88c5\u7532", DEFAULT_COLOR, "minecraft:generic.armor,1.0,ADDITION", 3.0);
        this.addDefaultModifier(builder, "powerful", "\u529b\u91cf", "RED", "minecraft:generic.attack_damage,0.1,MULTIPLY_BASE", 3.0);
        this.addDefaultModifier(builder, "swift", "\u8fc5\u6377", "YELLOW", "minecraft:generic.attack_speed,0.05,MULTIPLY_BASE", 3.0);
        this.addDefaultModifier(builder, "quick", "\u654f\u6377", "AQUA", "minecraft:generic.movement_speed,0.1,MULTIPLY_BASE", 3.0);
        this.addDefaultModifier(builder, "steady", "\u7a33\u56fa", "DARK_GRAY", "minecraft:generic.knockback_resistance,0.05,ADDITION", 3.0);
        this.addDefaultModifier(builder, "lucky_basic", "\u5e78\u8fd0", "GREEN", "minecraft:generic.luck,0.5,ADDITION", 3.0);
        this.addDefaultModifier(builder, "tough", "\u575a\u97e7", "DARK_GREEN", "minecraft:generic.armor_toughness,1.0,ADDITION", 3.0);
        this.addDefaultModifier(builder, "jumper", "\u8df3\u8dc3", "AQUA", "baublesreforked:jump_strength,0.3,MULTIPLY_BASE", 2.0);
        this.addDefaultModifier(builder, "focused", "\u4e13\u6ce8", "LIGHT_PURPLE", "minecraft:generic.attack_speed,0.05,MULTIPLY_BASE#minecraft:generic.luck,0.5,ADDITION", 2.0);
        this.addDefaultModifier(builder, "aquatic", "\u6c34\u7075", "DARK_AQUA", "forge:swim_speed,0.15,MULTIPLY_BASE#minecraft:generic.movement_speed,0.05,MULTIPLY_BASE", 2.0);
        this.addDefaultModifier(builder, "reach", "\u5ef6\u4f38", "BLUE", "forge:block_reach,1.0,ADDITION#forge:entity_reach,1.0,ADDITION", 2.0);
        this.addDefaultModifier(builder, "nimble", "\u8f7b\u76c8", "YELLOW", "forge:step_height_addition,0.3,ADDITION#minecraft:generic.movement_speed,0.05,MULTIPLY_BASE", 2.0);
        this.addDefaultModifier(builder, "battle_master", "\u6218\u6597\u5927\u5e08", "RED", "minecraft:generic.attack_damage,0.05,MULTIPLY_BASE#minecraft:generic.attack_speed,0.05,MULTIPLY_BASE", 2.0);
        this.addDefaultModifier(builder, "defender", "\u9632\u5fa1\u8005", DEFAULT_COLOR, "minecraft:generic.armor,1.0,ADDITION#minecraft:generic.knockback_resistance,0.05,ADDITION", 2.0);
        this.addDefaultModifier(builder, "sprinter", "\u75be\u8dd1\u8005", "AQUA", "minecraft:generic.movement_speed,0.1,MULTIPLY_BASE#forge:step_height_addition,0.2,ADDITION", 2.0);
        this.addDefaultModifier(builder, "durable", "\u8010\u4e45", "DARK_GRAY", "minecraft:generic.max_health,2.0,ADDITION#minecraft:generic.armor_toughness,0.5,ADDITION", 2.0);
        this.addDefaultModifier(builder, "advanced_jumper", "\u7075\u8dc3", "LIGHT_PURPLE", "baublesreforked:jump_strength,0.5,MULTIPLY_BASE#minecraft:generic.movement_speed,0.1,MULTIPLY_BASE", 1.0);
        this.addDefaultModifier(builder, "vampiric", "\u5438\u8840", "DARK_RED", "minecraft:generic.attack_damage,0.1,MULTIPLY_BASE#minecraft:generic.max_health,1.0,ADDITION#minecraft:generic.armor,-0.5,ADDITION#baublesreforked:life_steal,0.1,ADDITION", 1.5);
        this.addDefaultModifier(builder, "scholar", "\u5b66\u8005", "AQUA", "minecraft:generic.luck,1.0,ADDITION#forge:block_reach,0.5,ADDITION#forge:entity_reach,0.5,ADDITION", 1.5);
        this.addDefaultModifier(builder, "hunter", "\u730e\u624b", "DARK_GREEN", "minecraft:generic.attack_damage,0.1,MULTIPLY_BASE#minecraft:generic.movement_speed,0.1,MULTIPLY_BASE#minecraft:generic.armor,-0.5,ADDITION", 1.5);
        this.addDefaultModifier(builder, "warrior", "\u6218\u58eb", "RED", "minecraft:generic.attack_damage,0.15,MULTIPLY_BASE#minecraft:generic.armor,1.0,ADDITION#minecraft:generic.movement_speed,-0.03,MULTIPLY_BASE", 1.5);
        this.addDefaultModifier(builder, "guardian", "\u5b88\u62a4", "BLUE", "minecraft:generic.armor,2.0,ADDITION#minecraft:generic.knockback_resistance,0.1,ADDITION#minecraft:generic.movement_speed,-0.05,MULTIPLY_BASE", 1.5);
        this.addDefaultModifier(builder, "super_jumper", "\u8dc3\u5929", "GOLD", "baublesreforked:jump_strength,1.0,MULTIPLY_BASE#minecraft:generic.movement_speed,0.1,MULTIPLY_BASE#minecraft:generic.armor,-1.0,ADDITION", 0.5);
        this.addDefaultModifier(builder, "paladin", "\u5723\u9a91\u58eb", "GOLD", "minecraft:generic.max_health,2.0,ADDITION#minecraft:generic.armor,1.0,ADDITION#minecraft:generic.attack_damage,0.05,MULTIPLY_BASE#minecraft:generic.luck,0.5,ADDITION#minecraft:generic.movement_speed,-0.05,MULTIPLY_BASE", 1.0);
        this.addDefaultModifier(builder, "berserker", "\u72c2\u6218\u58eb", "DARK_RED", "minecraft:generic.attack_damage,0.15,MULTIPLY_BASE#minecraft:generic.attack_speed,0.1,MULTIPLY_BASE#minecraft:generic.movement_speed,0.05,MULTIPLY_BASE#minecraft:generic.max_health,-1.0,ADDITION", 1.0);
        this.addDefaultModifier(builder, "rogue", "\u76d7\u8d3c", "DARK_GRAY", "minecraft:generic.movement_speed,0.15,MULTIPLY_BASE#minecraft:generic.attack_speed,0.1,MULTIPLY_BASE#forge:entity_reach,0.5,ADDITION#minecraft:generic.armor,-1.0,ADDITION", 1.0);
        this.addDefaultModifier(builder, "monk", "\u6b66\u50e7", "YELLOW", "minecraft:generic.attack_speed,0.15,MULTIPLY_BASE#minecraft:generic.movement_speed,0.1,MULTIPLY_BASE#forge:step_height_addition,0.5,ADDITION#minecraft:generic.armor,-0.5,ADDITION", 1.0);
        this.addDefaultModifier(builder, "samurai", "\u6b66\u58eb", DEFAULT_COLOR, "minecraft:generic.attack_damage,0.1,MULTIPLY_BASE#minecraft:generic.attack_speed,0.1,MULTIPLY_BASE#minecraft:generic.movement_speed,0.05,MULTIPLY_BASE#minecraft:generic.armor,-0.5,ADDITION", 1.0);
        this.addDefaultModifier(builder, "frost", "\u971c\u51bb", "AQUA", "minecraft:generic.attack_speed,-0.1,MULTIPLY_BASE#minecraft:generic.armor,2.0,ADDITION#minecraft:generic.knockback_resistance,0.1,ADDITION#forge:swim_speed,0.15,MULTIPLY_BASE", 1.0);
        this.addDefaultModifier(builder, "flame", "\u70c8\u7130", "RED", "minecraft:generic.attack_damage,0.15,MULTIPLY_BASE#minecraft:generic.attack_speed,0.05,MULTIPLY_BASE#minecraft:generic.max_health,-1.0,ADDITION#minecraft:generic.movement_speed,0.05,MULTIPLY_BASE", 1.0);
        this.addDefaultModifier(builder, "thunder", "\u96f7\u9706", "YELLOW", "minecraft:generic.attack_speed,0.15,MULTIPLY_BASE#minecraft:generic.movement_speed,0.1,MULTIPLY_BASE#minecraft:generic.attack_damage,0.05,MULTIPLY_BASE#minecraft:generic.armor,-1.0,ADDITION", 1.0);
        this.addDefaultModifier(builder, "earth", "\u5927\u5730", "DARK_GREEN", "minecraft:generic.max_health,3.0,ADDITION#minecraft:generic.armor,1.5,ADDITION#minecraft:generic.knockback_resistance,0.1,ADDITION#minecraft:generic.movement_speed,-0.1,MULTIPLY_BASE", 1.0);
        this.addDefaultModifier(builder, "wind", "\u75be\u98ce", "WHITE", "minecraft:generic.movement_speed,0.15,MULTIPLY_BASE#minecraft:generic.attack_speed,0.1,MULTIPLY_BASE#forge:entity_gravity,-0.05,ADDITION#minecraft:generic.armor,-1.0,ADDITION", 1.0);
        this.addDefaultModifier(builder, "glass_cannon", "\u73bb\u7483\u5927\u70ae", "LIGHT_PURPLE", "minecraft:generic.attack_damage,0.25,MULTIPLY_BASE#minecraft:generic.attack_speed,0.1,MULTIPLY_BASE#minecraft:generic.armor,-2.0,ADDITION#minecraft:generic.max_health,-2.0,ADDITION", 1.0);
        this.addDefaultModifier(builder, "juggernaut", "\u4e3b\u5bb0", "GOLD", "minecraft:generic.max_health,4.0,ADDITION#minecraft:generic.armor,2.0,ADDITION#minecraft:generic.knockback_resistance,0.1,ADDITION#minecraft:generic.movement_speed,-0.1,MULTIPLY_BASE#minecraft:generic.attack_speed,-0.1,MULTIPLY_BASE", 1.0);
        this.addDefaultModifier(builder, "assassin", "\u523a\u5ba2", "DARK_RED", "minecraft:generic.attack_damage,0.3,MULTIPLY_BASE#minecraft:generic.attack_speed,0.15,MULTIPLY_BASE#minecraft:generic.movement_speed,0.1,MULTIPLY_BASE#minecraft:generic.max_health,-3.0,ADDITION#minecraft:generic.armor,-1.5,ADDITION", 1.0);
        this.addDefaultModifier(builder, "titan", "\u6cf0\u5766", "DARK_GRAY", "minecraft:generic.max_health,6.0,ADDITION#minecraft:generic.armor,3.0,ADDITION#minecraft:generic.knockback_resistance,0.15,ADDITION#minecraft:generic.movement_speed,-0.15,MULTIPLY_BASE#minecraft:generic.attack_speed,-0.15,MULTIPLY_BASE#minecraft:generic.attack_damage,-0.05,MULTIPLY_BASE", 1.0);
        this.addDefaultModifier(builder, "storm", "\u98ce\u66b4", "AQUA", "minecraft:generic.attack_speed,0.2,MULTIPLY_BASE#minecraft:generic.movement_speed,0.2,MULTIPLY_BASE#forge:swim_speed,0.15,MULTIPLY_BASE#minecraft:generic.max_health,-2.0,ADDITION#minecraft:generic.armor,-1.0,ADDITION#minecraft:generic.attack_damage,-0.05,MULTIPLY_BASE", 1.0);
        this.addDefaultModifier(builder, "cursed", "\u8bc5\u5492", "DARK_PURPLE", "minecraft:generic.max_health,-1.0,ADDITION#minecraft:generic.movement_speed,-0.05,MULTIPLY_BASE#minecraft:generic.luck,-0.5,ADDITION", 1.0);
        this.addDefaultModifier(builder, "heavy", "\u6c89\u91cd", "DARK_GRAY", "minecraft:generic.armor,1.0,ADDITION#minecraft:generic.movement_speed,-0.1,MULTIPLY_BASE#minecraft:generic.attack_speed,-0.05,MULTIPLY_BASE", 1.0);
        this.addDefaultModifier(builder, "fragile", "\u8106\u5f31", DEFAULT_COLOR, "minecraft:generic.attack_damage,0.1,MULTIPLY_BASE#minecraft:generic.armor,-1.0,ADDITION#minecraft:generic.max_health,-1.0,ADDITION", 1.0);
        this.addDefaultModifier(builder, "clumsy", "\u7b28\u62d9", "DARK_GRAY", "minecraft:generic.attack_speed,-0.1,MULTIPLY_BASE#minecraft:generic.movement_speed,-0.1,MULTIPLY_BASE#forge:block_reach,-0.5,ADDITION", 1.0);
        this.addDefaultModifier(builder, "unlucky", "\u4e0d\u5e78", "DARK_PURPLE", "minecraft:generic.luck,-1.0,ADDITION#minecraft:generic.attack_speed,-0.05,MULTIPLY_BASE#minecraft:generic.movement_speed,-0.05,MULTIPLY_BASE", 1.0);
        this.addDefaultModifier(builder, "acrobat", "\u6742\u6280", "YELLOW", "minecraft:generic.movement_speed,0.1,MULTIPLY_BASE#forge:step_height_addition,0.5,ADDITION#forge:entity_gravity,-0.05,ADDITION#minecraft:generic.max_health,-1.0,ADDITION", 1.0);
        this.addDefaultModifier(builder, "tank", "\u5766\u514b", "BLUE", "minecraft:generic.max_health,4.0,ADDITION#minecraft:generic.armor,2.0,ADDITION#minecraft:generic.armor_toughness,1.0,ADDITION#minecraft:generic.knockback_resistance,0.05,ADDITION#minecraft:generic.movement_speed,-0.03,MULTIPLY_BASE", 1.0);
        this.addDefaultModifier(builder, "duelist", "\u51b3\u6597\u8005", "GOLD", "minecraft:generic.attack_damage,0.1,MULTIPLY_BASE#minecraft:generic.attack_speed,0.1,MULTIPLY_BASE#minecraft:generic.armor,1.0,ADDITION#minecraft:generic.movement_speed,-0.05,MULTIPLY_BASE", 1.0);
        this.addDefaultModifier(builder, "scout", "\u65a5\u5019", "GREEN", "minecraft:generic.movement_speed,0.15,MULTIPLY_BASE#forge:entity_reach,1.0,ADDITION#minecraft:generic.luck,0.5,ADDITION#minecraft:generic.max_health,-1.0,ADDITION", 1.0);
        this.addDefaultModifier(builder, "warlock", "\u672f\u58eb", "DARK_PURPLE", "minecraft:generic.attack_damage,0.1,MULTIPLY_BASE#forge:entity_reach,1.0,ADDITION#minecraft:generic.luck,0.5,ADDITION#minecraft:generic.armor,-1.0,ADDITION", 1.0);
        this.addDefaultModifier(builder, "celestial", "\u5929\u754c", "LIGHT_PURPLE", "minecraft:generic.max_health,2.0,ADDITION#minecraft:generic.armor,1.0,ADDITION#minecraft:generic.luck,0.5,ADDITION#minecraft:generic.movement_speed,0.05,MULTIPLY_BASE#forge:step_height_addition,0.5,ADDITION", 0.5);
        this.addDefaultModifier(builder, "demonic", "\u6076\u9b54", "DARK_RED", "minecraft:generic.attack_damage,0.15,MULTIPLY_BASE#minecraft:generic.attack_speed,0.1,MULTIPLY_BASE#minecraft:generic.max_health,2.0,ADDITION#minecraft:generic.armor,-1.0,ADDITION#minecraft:generic.luck,-0.5,ADDITION", 0.5);
        this.addDefaultModifier(builder, "dragon", "\u9f99\u9b42", "GOLD", "minecraft:generic.max_health,3.0,ADDITION#minecraft:generic.attack_damage,0.15,MULTIPLY_BASE#minecraft:generic.movement_speed,0.1,MULTIPLY_BASE#forge:entity_gravity,-0.05,ADDITION#minecraft:generic.armor,1.0,ADDITION", 0.5);
        this.addDefaultModifier(builder, "angel", "\u5929\u4f7f", "WHITE", "minecraft:generic.max_health,3.0,ADDITION#minecraft:generic.armor,1.5,ADDITION#minecraft:generic.luck,1.0,ADDITION#forge:entity_gravity,-0.05,ADDITION#minecraft:generic.movement_speed,0.1,MULTIPLY_BASE", 0.5);
        this.addDefaultModifier(builder, "ancient", "\u8fdc\u53e4", "DARK_AQUA", "minecraft:generic.max_health,4.0,ADDITION#minecraft:generic.armor,2.0,ADDITION#minecraft:generic.attack_damage,0.1,MULTIPLY_BASE#minecraft:generic.luck,0.5,ADDITION#minecraft:generic.movement_speed,-0.05,MULTIPLY_BASE", 0.5);
    }

    private void addDefaultModifier(ForgeConfigSpec.Builder builder, String id, String name, String color, String attributes, double weight) {
        builder.push(id);
        this.defaultModifiers.put(id, new ModifierData((ForgeConfigSpec.ConfigValue<String>)builder.define("value", (Object)String.format("%s|%s|%s|%s|%.1f", id, name, color, attributes, weight)), builder.comment("\u8bbe\u7f6e\u4e3a false \u4ee5\u7981\u7528\u6b64\u4fee\u9970\u7b26").define("enabled", true)));
        builder.pop();
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        INSTANCE.loadConfig();
    }

    @SubscribeEvent
    public static void onReload(ModConfigEvent.Reloading configEvent) {
        INSTANCE.loadConfig();
    }

    public void loadConfig() {
        if (AttributeResolver.ATTRIBUTE_CACHE.isEmpty()) {
            AttributeResolver.initializeCache();
        }
        this.saveStandardizedConfig();
        BaublesReforkedMod.LOGGER.info("Loading BaublesReforked configuration...");
        try {
            this.globalReforge.enabled = (Boolean)this.globalReforgeEnabled.get();
            this.globalReforge.requiredItem = (String)this.globalReforgeItem.get();
            this.globalReforge.experienceCost = (Integer)this.globalReforgeExperience.get();
            this.globalReforge.materialCost = (Integer)this.globalReforgeMaterial.get();
            BaublesReforkedMod.LOGGER.debug("Loaded global reforge settings: enabled={}, item={}, exp={}, material={}", new Object[]{this.globalReforge.enabled, this.globalReforge.requiredItem, this.globalReforge.experienceCost, this.globalReforge.materialCost});
            this.modifiableItems.clear();
            for (String string : (List)this.modifiableItemsList.get()) {
                try {
                    String[] parts = string.split("\\|");
                    if (parts.length >= 4) {
                        String itemId = parts[0].trim();
                        this.modifiableItems.put(itemId, new ReforgeConfig(parts[1].trim(), Integer.parseInt(parts[2].trim()), Integer.parseInt(parts[3].trim())));
                        BaublesReforkedMod.LOGGER.debug("Added modifiable item: {} with reforge config", (Object)itemId);
                        continue;
                    }
                    BaublesReforkedMod.LOGGER.warn("Invalid modifiable item format: {}", (Object)string);
                }
                catch (Exception e) {
                    BaublesReforkedMod.LOGGER.error("Error parsing modifiable item: " + string, (Throwable)e);
                }
            }
            this.modifiers.clear();
            if (((Boolean)this.defaultModifiersEnabled.get()).booleanValue()) {
                BaublesReforkedMod.LOGGER.info("Loading default modifiers...");
                for (Map.Entry entry : this.defaultModifiers.entrySet()) {
                    if (((Boolean)((ModifierData)entry.getValue()).enabled.get()).booleanValue()) {
                        String modifierStr = (String)((ModifierData)entry.getValue()).value.get();
                        BaublesReforkedMod.LOGGER.debug("Processing default modifier: {}", entry.getKey());
                        this.parseModifier(modifierStr);
                        continue;
                    }
                    BaublesReforkedMod.LOGGER.debug("Skipping disabled default modifier: {}", entry.getKey());
                }
            } else {
                BaublesReforkedMod.LOGGER.info("Default modifiers are disabled");
            }
            BaublesReforkedMod.LOGGER.info("Loading custom modifiers...");
            for (String string : (List)this.customModifiers.get()) {
                BaublesReforkedMod.LOGGER.debug("Processing custom modifier: {}", (Object)string);
                this.parseModifier(string);
            }
            this.standardizeModifierAttributes();
            BaublesReforkedMod.LOGGER.info("Loaded {} modifiers", (Object)this.modifiers.size());
            if (BaublesReforkedMod.LOGGER.isDebugEnabled()) {
                this.modifiers.forEach((id, modifier) -> {
                    BaublesReforkedMod.LOGGER.debug("Loaded modifier: {} ({})", id, (Object)modifier.name);
                    modifier.attributes.forEach(attr -> BaublesReforkedMod.LOGGER.debug("  Attribute: {} = {} ({})", new Object[]{attr.id, attr.value, attr.operation}));
                });
            }
            this.validateConfiguration();
        }
        catch (Exception e) {
            BaublesReforkedMod.LOGGER.error("Error loading configuration", (Throwable)e);
        }
    }

    private void standardizeModifierAttributes() {
        BaublesReforkedMod.LOGGER.debug("Starting attribute standardization...");
        for (ModifierEntry modifier : this.modifiers.values()) {
            for (AttributeEntry attr : modifier.attributes) {
                String originalId = attr.id;
                String standardId = AttributeResolver.getStandardFormat(attr.id);
                if (originalId.equals(standardId)) continue;
                BaublesReforkedMod.LOGGER.debug("Standardizing attribute ID in modifier {}: {} -> {}", new Object[]{modifier.name, originalId, standardId});
                attr.id = standardId;
            }
        }
        BaublesReforkedMod.LOGGER.debug("Attribute standardization completed");
    }

    private void validateConfiguration() {
        BaublesReforkedMod.LOGGER.debug("Validating configuration...");
        if (this.globalReforge.enabled) {
            try {
                ResourceLocation itemLocation = new ResourceLocation(this.globalReforge.requiredItem);
                if (!BuiltInRegistries.f_257033_.m_7804_(itemLocation)) {
                    BaublesReforkedMod.LOGGER.warn("Global reforge item not found: {}", (Object)this.globalReforge.requiredItem);
                }
            }
            catch (Exception e) {
                BaublesReforkedMod.LOGGER.error("Invalid global reforge item format: {}", (Object)this.globalReforge.requiredItem);
            }
        }
        for (Map.Entry<String, ReforgeConfig> entry : this.modifiableItems.entrySet()) {
            try {
                ResourceLocation materialLocation;
                ResourceLocation itemLocation = new ResourceLocation(entry.getKey());
                if (!BuiltInRegistries.f_257033_.m_7804_(itemLocation)) {
                    BaublesReforkedMod.LOGGER.warn("Modifiable item not found: {}", (Object)entry.getKey());
                }
                if (BuiltInRegistries.f_257033_.m_7804_(materialLocation = new ResourceLocation(entry.getValue().requiredItem))) continue;
                BaublesReforkedMod.LOGGER.warn("Reforge material not found for item {}: {}", (Object)entry.getKey(), (Object)entry.getValue().requiredItem);
            }
            catch (Exception e) {
                BaublesReforkedMod.LOGGER.error("Invalid item ID format: {}", (Object)entry.getKey());
            }
        }
        for (Map.Entry<String, Object> entry : this.modifiers.entrySet()) {
            String modifierId = entry.getKey();
            ModifierEntry modifier = (ModifierEntry)entry.getValue();
            if (modifier.attributes.isEmpty()) {
                BaublesReforkedMod.LOGGER.warn("Modifier {} has no attributes", (Object)modifierId);
            }
            for (AttributeEntry attr : modifier.attributes) {
                if (!AttributeResolver.isValidAttributeId(attr.id)) {
                    BaublesReforkedMod.LOGGER.warn("Invalid attribute ID in modifier {}: {}", (Object)modifierId, (Object)attr.id);
                }
                try {
                    AttributeModifier.Operation.valueOf((String)attr.operation);
                }
                catch (IllegalArgumentException e) {
                    BaublesReforkedMod.LOGGER.warn("Invalid operation type in modifier {}: {}", (Object)modifierId, (Object)attr.operation);
                }
            }
        }
        BaublesReforkedMod.LOGGER.debug("Configuration validation completed");
    }

    private void parseModifier(String modifierStr) {
        block13: {
            try {
                BaublesReforkedMod.LOGGER.debug("Parsing modifier string: {}", (Object)modifierStr);
                String[] parts = modifierStr.split("\\|");
                if (parts.length >= 5) {
                    String[] attributes;
                    String id = parts[0].trim();
                    String name = parts[1].trim();
                    String color = parts[2].trim();
                    String attributesStr = parts[3].trim();
                    double weight = Double.parseDouble(parts[4].trim());
                    ModifierEntry entry = new ModifierEntry(name, weight, color);
                    for (String attr : attributes = attributesStr.split("#")) {
                        String[] attrParts = attr.split(",");
                        if (attrParts.length == 3) {
                            try {
                                String rawAttributeId = attrParts[0].trim();
                                String standardizedId = AttributeResolver.getStandardFormat(rawAttributeId);
                                if (AttributeResolver.resolveAttribute(standardizedId) != null) {
                                    double value = Double.parseDouble(attrParts[1].trim());
                                    String operation = attrParts[2].trim().toUpperCase();
                                    try {
                                        AttributeModifier.Operation.valueOf((String)operation);
                                    }
                                    catch (IllegalArgumentException e) {
                                        BaublesReforkedMod.LOGGER.error("Invalid operation type in modifier {}: {}", (Object)id, (Object)operation);
                                        continue;
                                    }
                                    entry.attributes.add(new AttributeEntry(standardizedId, value, operation));
                                    BaublesReforkedMod.LOGGER.debug("Added attribute to modifier {}: {} = {} ({})", new Object[]{id, standardizedId, value, operation});
                                    continue;
                                }
                                BaublesReforkedMod.LOGGER.error("Invalid attribute ID in modifier {}: {}", (Object)id, (Object)rawAttributeId);
                            }
                            catch (NumberFormatException e) {
                                BaublesReforkedMod.LOGGER.error("Invalid attribute value in modifier {}: {}", (Object)id, (Object)attrParts[1]);
                            }
                            catch (Exception e) {
                                BaublesReforkedMod.LOGGER.error("Error parsing attribute in modifier {}: {}", new Object[]{id, attr, e});
                            }
                            continue;
                        }
                        BaublesReforkedMod.LOGGER.error("Invalid attribute format in modifier {}: {}", (Object)id, (Object)attr);
                    }
                    if (!entry.attributes.isEmpty()) {
                        this.modifiers.put(id, entry);
                        BaublesReforkedMod.LOGGER.debug("Successfully added modifier {} with {} attributes", (Object)id, (Object)entry.attributes.size());
                    } else {
                        BaublesReforkedMod.LOGGER.warn("Modifier {} was not added because it has no valid attributes", (Object)id);
                    }
                    break block13;
                }
                BaublesReforkedMod.LOGGER.error("Invalid modifier format: {}", (Object)modifierStr);
            }
            catch (Exception e) {
                BaublesReforkedMod.LOGGER.error("Error parsing modifier: " + modifierStr, (Throwable)e);
            }
        }
    }

    public void saveStandardizedConfig() {
        try {
            if (((Boolean)this.defaultModifiersEnabled.get()).booleanValue()) {
                boolean needsSave = false;
                for (ModifierData data : this.defaultModifiers.values()) {
                    String standardized;
                    String modifierStr = (String)data.value.get();
                    if (modifierStr.equals(standardized = this.standardizeModifierString(modifierStr))) continue;
                    data.value.set((Object)standardized);
                    needsSave = true;
                }
                if (needsSave && SPEC != null) {
                    SPEC.save();
                }
            }
        }
        catch (Exception e) {
            BaublesReforkedMod.LOGGER.error("Error saving standardized configuration", (Throwable)e);
        }
    }

    private String standardizeModifierString(String modifierStr) {
        try {
            BaublesReforkedMod.LOGGER.info("\u5f00\u59cb\u6807\u51c6\u5316\u4fee\u9970\u7b26\u5b57\u7b26\u4e32: {}", (Object)modifierStr);
            String[] parts = modifierStr.split("\\|");
            if (parts.length >= 2) {
                String id = parts[0].trim();
                String name = parts[1].trim();
                String color = DEFAULT_COLOR;
                ArrayList<String> attributeList = new ArrayList<String>();
                String weight = "1.0";
                for (int i = 2; i < parts.length; ++i) {
                    String part = parts[i].trim();
                    if (part.contains(",")) {
                        String[] attributeParts;
                        for (String attr : attributeParts = part.split("#")) {
                            String rawAttributeId;
                            String standardizedId;
                            String[] attrComponents = attr.split(",");
                            if (attrComponents.length != 3 || AttributeResolver.resolveAttribute(standardizedId = AttributeResolver.getStandardFormat(rawAttributeId = attrComponents[0].trim())) == null) continue;
                            String standardizedAttr = String.format("%s,%s,%s", standardizedId, attrComponents[1].trim(), attrComponents[2].trim().toUpperCase());
                            attributeList.add(standardizedAttr);
                            BaublesReforkedMod.LOGGER.debug("\u6dfb\u52a0\u5c5e\u6027: {}", (Object)standardizedAttr);
                        }
                        continue;
                    }
                    if (this.isColor(part)) {
                        String validatedColor = this.validateColor(part);
                        if (!validatedColor.equals(part)) {
                            BaublesReforkedMod.LOGGER.warn("Invalid color '{}', using default color '{}'", (Object)part, (Object)validatedColor);
                        }
                        color = validatedColor;
                        BaublesReforkedMod.LOGGER.debug("\u8bbe\u7f6e\u989c\u8272: {}", (Object)color);
                        continue;
                    }
                    if (!this.isWeight(part)) continue;
                    weight = part;
                    BaublesReforkedMod.LOGGER.debug("\u8bbe\u7f6e\u6743\u91cd: {}", (Object)weight);
                }
                Collections.sort(attributeList);
                String attributesStr = attributeList.isEmpty() ? "" : String.join((CharSequence)"#", attributeList);
                String result = String.format("%s|%s|%s|%s|%s", id, name, color, attributesStr, weight);
                BaublesReforkedMod.LOGGER.info("\u6807\u51c6\u5316\u5b8c\u6210 - \u539f\u59cb: {} -> \u7ed3\u679c: {}", (Object)modifierStr, (Object)result);
                return result;
            }
            BaublesReforkedMod.LOGGER.warn("\u65e0\u6548\u7684\u4fee\u9970\u7b26\u683c\u5f0f: {}", (Object)modifierStr);
            return modifierStr;
        }
        catch (Exception e) {
            BaublesReforkedMod.LOGGER.error("\u6807\u51c6\u5316\u8fc7\u7a0b\u53d1\u751f\u9519\u8bef: {} - {}", (Object)modifierStr, (Object)e.getMessage());
            return modifierStr;
        }
    }

    private String validateColor(String color) {
        return VALID_COLORS.contains(color) ? color : DEFAULT_COLOR;
    }

    private boolean isColor(String str) {
        return str.matches("^[A-Z_]+$") && !str.contains(",");
    }

    private boolean isWeight(String str) {
        try {
            double value = Double.parseDouble(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static ModifierConfig getInstance() {
        return INSTANCE;
    }

    public boolean isItemModifiable(String itemId) {
        try {
            if (((List)this.blacklistedItems.get()).contains(itemId)) {
                return false;
            }
            if (this.modifiableItems.containsKey(itemId)) {
                return true;
            }
            if (!((Boolean)this.autoDetectCurios.get()).booleanValue()) {
                return false;
            }
            ResourceLocation resourceLocation = ResourceLocation.m_135820_((String)itemId);
            if (resourceLocation == null) {
                return false;
            }
            Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(resourceLocation);
            if (item == null || item == Items.f_41852_) {
                return false;
            }
            ItemStack stack = new ItemStack((ItemLike)item);
            Map map = CuriosApi.getItemStackSlots((ItemStack)stack, (FMLLoader.getDist() == Dist.CLIENT ? 1 : 0) != 0);
            return !map.isEmpty();
        }
        catch (Exception e) {
            BaublesReforkedMod.LOGGER.error("Error in isItemModifiable for item: " + itemId, (Throwable)e);
            return false;
        }
    }

    public ReforgeConfig getReforgeConfig(String itemId) {
        if (this.modifiableItems.containsKey(itemId)) {
            return this.modifiableItems.get(itemId);
        }
        if (((Boolean)this.autoDetectCurios.get()).booleanValue() && this.isItemModifiable(itemId)) {
            if (this.globalReforge.enabled) {
                return new ReforgeConfig(this.globalReforge.requiredItem, this.globalReforge.experienceCost, this.globalReforge.materialCost);
            }
            return new ReforgeConfig("minecraft:diamond", 5, 1);
        }
        return null;
    }

    public Map<String, ModifierEntry> getModifiers() {
        return this.modifiers;
    }

    public ModifierEntry getRandomModifier() {
        double totalWeight = this.modifiers.values().stream().mapToDouble(entry -> entry.weight).sum();
        double random = Math.random() * totalWeight;
        double currentWeight = 0.0;
        for (ModifierEntry modifier : this.modifiers.values()) {
            if (!(random <= (currentWeight += modifier.weight))) continue;
            return modifier;
        }
        return this.modifiers.values().iterator().next();
    }

    public ModifierEntry getModifier(String id) {
        return this.modifiers.get(id);
    }

    public String getModifierIdByName(String name) {
        for (Map.Entry<String, ModifierEntry> entry : this.modifiers.entrySet()) {
            if (!entry.getValue().name.equals(name)) continue;
            return entry.getKey();
        }
        return null;
    }

    public int getModifierBookExperience() {
        return (Integer)this.modifierBookExperience.get();
    }

    public boolean hideModifierAttributes() {
        return (Boolean)this.hideModifierAttributes.get();
    }

    public boolean useModifierTooltip() {
        return (Boolean)this.useModifierTooltip.get();
    }

    public List<? extends String> getBlacklistedItems() {
        return (List)this.blacklistedItems.get();
    }

    public boolean isCustomTooltipEnabled() {
        return (Boolean)this.enableCustomTooltip.get();
    }

    public double getModifierApplyProbability() {
        return (Double)this.modifierApplyProbability.get();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ModifierConfig::new);
        SPEC = (ForgeConfigSpec)specPair.getRight();
        INSTANCE = (ModifierConfig)specPair.getLeft();
        VALID_COLORS = Set.of("BLACK", "DARK_BLUE", "DARK_GREEN", "DARK_AQUA", "DARK_RED", "DARK_PURPLE", "GOLD", DEFAULT_COLOR, "DARK_GRAY", "BLUE", "GREEN", "AQUA", "RED", "LIGHT_PURPLE", "YELLOW", "WHITE");
    }

    public static class GlobalReforgeConfig {
        public boolean enabled = false;
        public String requiredItem;
        public int experienceCost;
        public int materialCost;

        public GlobalReforgeConfig() {
            this.requiredItem = "";
            this.experienceCost = 0;
            this.materialCost = 0;
        }

        public GlobalReforgeConfig(String requiredItem, int experienceCost, int materialCost) {
            this.requiredItem = requiredItem;
            this.experienceCost = experienceCost;
            this.materialCost = materialCost;
        }
    }

    private static class ModifierData {
        final ForgeConfigSpec.ConfigValue<String> value;
        final ForgeConfigSpec.BooleanValue enabled;

        ModifierData(ForgeConfigSpec.ConfigValue<String> value, ForgeConfigSpec.BooleanValue enabled) {
            this.value = value;
            this.enabled = enabled;
        }
    }

    public static class ReforgeConfig {
        public String requiredItem;
        public int experienceCost;
        public int materialCost;

        public ReforgeConfig(String requiredItem, int experienceCost, int materialCost) {
            this.requiredItem = requiredItem;
            this.experienceCost = experienceCost;
            this.materialCost = materialCost;
        }
    }

    public static class ModifierEntry {
        public String name;
        public double weight;
        public String color;
        public List<AttributeEntry> attributes;

        public ModifierEntry(String name, double weight, String color) {
            this.name = name;
            this.weight = weight;
            this.color = color;
            this.attributes = new ArrayList<AttributeEntry>();
        }
    }

    public static class AttributeEntry {
        public String id;
        public double value;
        public String operation;

        public AttributeEntry(String id, double value, String operation) {
            this.id = id;
            this.value = value;
            this.operation = operation;
        }
    }
}

