/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.baublesreforked.events;

import com.jinqinxixi.baublesreforked.attributes.ModAttributes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="baublesreforked")
public class AttributeEvents {
    @SubscribeEvent
    public static void onLivingJump(LivingEvent.LivingJumpEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            AttributeEvents.handleJumpBoost(player);
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            AttributeEvents.handleLifeSteal(player, event.getAmount());
        }
    }

    private static void handleJumpBoost(Player player) {
        AttributeInstance jumpAttribute = player.m_21051_((Attribute)ModAttributes.JUMP_STRENGTH.get());
        if (jumpAttribute != null && jumpAttribute.m_22135_() != 1.0) {
            Vec3 motion = player.m_20184_();
            player.m_20334_(motion.f_82479_, motion.f_82480_ * jumpAttribute.m_22135_(), motion.f_82481_);
        }
    }

    private static void handleLifeSteal(Player player, float damageAmount) {
        AttributeInstance lifeStealAttr = player.m_21051_((Attribute)ModAttributes.LIFE_STEAL.get());
        if (lifeStealAttr != null && lifeStealAttr.m_22135_() > 0.0) {
            float healAmount = (float)((double)damageAmount * lifeStealAttr.m_22135_());
            player.m_5634_(healAmount);
            System.out.println("Life Steal Base Value: " + lifeStealAttr.m_22115_());
            System.out.println("Life Steal Final Value: " + lifeStealAttr.m_22135_());
            if (healAmount > 0.0f) {
                // empty if block
            }
        }
    }
}

