/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.baublesreforked.items;

import com.jinqinxixi.baublesreforked.config.ModifierConfig;
import com.jinqinxixi.baublesreforked.items.ModItems;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ModifierItem
extends Item {
    public static final String MODIFIER_ID_TAG = "baublesreforked.ModifierId";

    public ModifierItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public static ItemStack createWithModifier(String modifierId) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.MODIFIER_BOOK.get());
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_(MODIFIER_ID_TAG, modifierId);
        return stack;
    }

    public static String getModifierId(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null ? tag.m_128461_(MODIFIER_ID_TAG) : "";
    }

    public Component m_7626_(ItemStack stack) {
        String modifierId = ModifierItem.getModifierId(stack);
        ModifierConfig.ModifierEntry modifier = ModifierConfig.getInstance().getModifier(modifierId);
        if (modifier != null) {
            String translationKey = "modifier.baublesreforked." + modifierId;
            MutableComponent translatedName = Component.m_237115_((String)translationKey);
            String translatedString = translatedName.getString();
            if (!translatedString.equals(translationKey)) {
                return translatedName.m_130940_(ChatFormatting.valueOf((String)modifier.color));
            }
            return Component.m_237113_((String)modifier.name).m_130940_(ChatFormatting.valueOf((String)modifier.color));
        }
        return super.m_7626_(stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        String modifierId = ModifierItem.getModifierId(stack);
        ModifierConfig.ModifierEntry modifier = ModifierConfig.getInstance().getModifier(modifierId);
        if (modifier != null) {
            for (ModifierConfig.AttributeEntry attr : modifier.attributes) {
                String formattedValue = attr.id.equals("baublesreforked:life_steal") || attr.id.equals("minecraft:generic.knockback_resistance") ? String.format("%+.1f%%", attr.value * 100.0) : (attr.operation.equals("ADDITION") ? (attr.value == (double)((int)attr.value) ? String.format("%+d", (int)attr.value) : String.format("%+.2f", attr.value)) : String.format("%+.1f%%", attr.value * 100.0));
                MutableComponent attrComponent = Component.m_237115_((String)("attribute.name." + attr.id)).m_130946_(" " + formattedValue).m_130940_(attr.value >= 0.0 ? ChatFormatting.GREEN : ChatFormatting.RED);
                tooltipComponents.add((Component)attrComponent);
            }
            tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.baublesreforked.tooltip").m_130940_(ChatFormatting.BLUE));
        }
    }

    public boolean m_5812_(ItemStack stack) {
        return true;
    }
}

