/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.baublesreforked.mixin;

import com.google.common.collect.Multimap;
import com.jinqinxixi.baublesreforked.config.ModifierConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.loading.FMLLoader;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotAttribute;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.ISlotType;
import top.theillusivec4.curios.client.ClientEventHandler;

@Mixin(value={ClientEventHandler.class})
public class CuriosTooltipMixin {
    private static final UUID ATTACK_DAMAGE_MODIFIER = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
    private static final UUID ATTACK_SPEED_MODIFIER = UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA3");
    private static final String TAG_MODIFIER_ID = "baublesreforked.ModifierId";

    private boolean isOurModifierAttribute(AttributeModifier modifier) {
        String name = modifier.m_22214_();
        return name.startsWith("baublesreforked.");
    }

    @Inject(method={"onTooltip"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void onTooltipInject(ItemTooltipEvent evt, CallbackInfo ci) {
        if (!ModifierConfig.getInstance().isCustomTooltipEnabled()) {
            return;
        }
        ItemStack stack = evt.getItemStack();
        Player player = evt.getEntity();
        if (!stack.m_41619_()) {
            ArrayList slots;
            List tooltip = evt.getToolTip();
            ModifierConfig config = ModifierConfig.getInstance();
            boolean hideModifierAttrs = config.hideModifierAttributes();
            for (int i = 0; i < tooltip.size(); ++i) {
                Component component = (Component)tooltip.get(i);
                ComponentContents componentContents = component.m_214077_();
                if (!(componentContents instanceof TranslatableContents)) continue;
                TranslatableContents contents = (TranslatableContents)componentContents;
                boolean replace = false;
                Object[] args = contents.m_237523_();
                if (args != null) {
                    for (int i1 = 0; i1 < args.length; ++i1) {
                        TranslatableContents contents1;
                        MutableComponent mutableComponent;
                        ComponentContents componentContents2;
                        Iterator arg = args[i1];
                        if (!(arg instanceof MutableComponent) || !((componentContents2 = (mutableComponent = (MutableComponent)arg).m_214077_()) instanceof TranslatableContents) || !(contents1 = (TranslatableContents)componentContents2).m_237508_().startsWith("curios.slot.")) continue;
                        String actualKey = contents1.m_237508_().replace(".slot.", ".identifier.");
                        contents.m_237523_()[i1] = Component.m_237110_((String)actualKey, (Object[])contents1.m_237523_());
                        replace = true;
                        break;
                    }
                }
                if (!replace) continue;
                tooltip.set(i, Component.m_237110_((String)contents.m_237508_().replace("attribute.modifier.", "curios.modifiers.slots."), (Object[])contents.m_237523_()).m_130948_(component.m_7383_()));
            }
            CompoundTag tag = stack.m_41783_();
            int i = 0;
            if (tag != null && tag.m_128425_("HideFlags", 99)) {
                i = tag.m_128451_("HideFlags");
            }
            HashMap map = player != null ? CuriosApi.getItemStackSlots((ItemStack)stack, (LivingEntity)player) : CuriosApi.getItemStackSlots((ItemStack)stack, (FMLLoader.getDist() == Dist.CLIENT ? 1 : 0) != 0);
            map = new HashMap(map);
            HashSet<String> toRemove = new HashSet<String>();
            block2: for (ISlotType value : map.values()) {
                for (ResourceLocation validator : value.getValidators()) {
                    if (!validator.m_135827_().equals("curios") || !validator.m_135815_().equals("all")) continue;
                    toRemove.add(value.getIdentifier());
                    continue block2;
                }
            }
            for (String s : toRemove) {
                map.remove(s);
            }
            Set<Object> curioTags = Set.copyOf(map.keySet());
            if (curioTags.contains("curio")) {
                curioTags = Set.of("curio");
            }
            if (!(slots = new ArrayList(curioTags)).isEmpty()) {
                ArrayList<MutableComponent> tagTooltips = new ArrayList<MutableComponent>();
                MutableComponent slotsTooltip = Component.m_237115_((String)"curios.tooltip.slot").m_130946_(" ").m_130940_(ChatFormatting.GOLD);
                for (int j = 0; j < slots.size(); ++j) {
                    String key = "curios.identifier." + (String)slots.get(j);
                    MutableComponent type = Component.m_237115_((String)key);
                    if (j < slots.size() - 1) {
                        type = type.m_130946_(", ");
                    }
                    type = type.m_130940_(ChatFormatting.YELLOW);
                    slotsTooltip.m_7220_((Component)type);
                }
                tagTooltips.add(slotsTooltip);
                LazyOptional optionalCurio = CuriosApi.getCurio((ItemStack)stack);
                optionalCurio.ifPresent(curio -> {
                    List actualSlotsTooltip = curio.getSlotsTooltip(tagTooltips);
                    if (!actualSlotsTooltip.isEmpty()) {
                        tooltip.addAll(1, actualSlotsTooltip);
                    }
                });
                if (!optionalCurio.isPresent()) {
                    tooltip.addAll(1, tagTooltips);
                }
                boolean hideOurModifierAttrs = hideModifierAttrs && tag != null && tag.m_128441_(TAG_MODIFIER_ID);
                HashMap slotAttributeMap = new HashMap();
                for (String identifier : slots) {
                    Multimap multimap = CuriosApi.getAttributeModifiers((SlotContext)new SlotContext(identifier, (LivingEntity)player, 0, false, true), (UUID)UUID.randomUUID(), (ItemStack)stack);
                    if (multimap.isEmpty() || (i & 2) != 0) continue;
                    ArrayList<MutableComponent> attributeLines = new ArrayList<MutableComponent>();
                    for (Map.Entry entry : multimap.entries()) {
                        MutableComponent attributeLine;
                        if (entry.getKey() == null || hideOurModifierAttrs && this.isOurModifierAttribute((AttributeModifier)entry.getValue())) continue;
                        double amount = ((AttributeModifier)entry.getValue()).m_22218_();
                        boolean flag = false;
                        if (player == null) continue;
                        if (((AttributeModifier)entry.getValue()).m_22209_() == ATTACK_DAMAGE_MODIFIER) {
                            AttributeInstance att = player.m_21051_(Attributes.f_22281_);
                            if (att != null) {
                                amount += att.m_22115_();
                            }
                            amount += (double)EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)MobType.f_21640_);
                            flag = true;
                        } else if (((AttributeModifier)entry.getValue()).m_22209_() == ATTACK_SPEED_MODIFIER) {
                            AttributeInstance att = player.m_21051_(Attributes.f_22283_);
                            if (att != null) {
                                amount += att.m_22115_();
                            }
                            flag = true;
                        }
                        double d1 = ((AttributeModifier)entry.getValue()).m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && ((AttributeModifier)entry.getValue()).m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? (((Attribute)entry.getKey()).equals(Attributes.f_22278_) ? amount * 10.0 : amount) : amount * 100.0;
                        Object k = entry.getKey();
                        if (k instanceof SlotAttribute) {
                            SlotAttribute slotAttribute = (SlotAttribute)k;
                            attributeLine = amount > 0.0 ? Component.m_237110_((String)("curios.modifiers.slots.plus." + ((AttributeModifier)entry.getValue()).m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1), Component.m_237115_((String)("curios.identifier." + slotAttribute.getIdentifier()))}).m_130940_(ChatFormatting.BLUE) : Component.m_237110_((String)("curios.modifiers.slots.take." + ((AttributeModifier)entry.getValue()).m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1 *= -1.0), Component.m_237115_((String)("curios.identifier." + slotAttribute.getIdentifier()))}).m_130940_(ChatFormatting.RED);
                        } else {
                            attributeLine = flag ? Component.m_237113_((String)" ").m_7220_((Component)Component.m_237110_((String)("attribute.modifier.equals." + ((AttributeModifier)entry.getValue()).m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1), Component.m_237115_((String)((Attribute)entry.getKey()).m_22087_())})).m_130940_(ChatFormatting.DARK_GREEN) : (amount > 0.0 ? Component.m_237110_((String)("attribute.modifier.plus." + ((AttributeModifier)entry.getValue()).m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1), Component.m_237115_((String)((Attribute)entry.getKey()).m_22087_())}).m_130940_(ChatFormatting.BLUE) : Component.m_237110_((String)("attribute.modifier.take." + ((AttributeModifier)entry.getValue()).m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1 *= -1.0), Component.m_237115_((String)((Attribute)entry.getKey()).m_22087_())}).m_130940_(ChatFormatting.RED));
                        }
                        attributeLines.add(attributeLine);
                    }
                    if (attributeLines.isEmpty()) continue;
                    slotAttributeMap.put(identifier, attributeLines);
                }
                ArrayList<MutableComponent> attributeTooltip = new ArrayList<MutableComponent>();
                if (!slotAttributeMap.isEmpty()) {
                    attributeTooltip.add(Component.m_237119_());
                    HashMap groupedAttributes = new HashMap();
                    for (Map.Entry entry : slotAttributeMap.entrySet()) {
                        String slot = (String)entry.getKey();
                        List attributes = (List)entry.getValue();
                        boolean found = false;
                        for (Map.Entry group : groupedAttributes.entrySet()) {
                            if (!attributes.equals(group.getValue())) continue;
                            ((List)group.getKey()).add(slot);
                            found = true;
                            break;
                        }
                        if (found) continue;
                        ArrayList<String> newGroup = new ArrayList<String>();
                        newGroup.add(slot);
                        groupedAttributes.put(newGroup, attributes);
                    }
                    for (Map.Entry group : groupedAttributes.entrySet()) {
                        MutableComponent slotsText = Component.m_237119_();
                        List groupSlots = (List)group.getKey();
                        Collections.sort(groupSlots);
                        for (int j = 0; j < groupSlots.size(); ++j) {
                            if (j > 0) {
                                slotsText.m_130946_("/");
                            }
                            slotsText.m_7220_((Component)Component.m_237115_((String)("curios.identifier." + (String)groupSlots.get(j))));
                        }
                        attributeTooltip.add(Component.m_237110_((String)"baublesreforked.tooltip.when_equipped", (Object[])new Object[]{slotsText}).m_130940_(ChatFormatting.GOLD));
                        attributeTooltip.addAll((Collection)group.getValue());
                    }
                }
                optionalCurio.ifPresent(curio -> {
                    List actualAttributeTooltips = curio.getAttributesTooltip(attributeTooltip);
                    if (!actualAttributeTooltips.isEmpty()) {
                        tooltip.addAll(actualAttributeTooltips);
                    }
                });
                if (!optionalCurio.isPresent()) {
                    tooltip.addAll(attributeTooltip);
                }
            }
        }
        ci.cancel();
    }
}

