/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.baublesreforked.modifier;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(AttributeResolver.class);
    public static final Map<String, AttributeInfo> ATTRIBUTE_CACHE = new HashMap<String, AttributeInfo>();

    public static void initializeCache() {
        LOGGER.info("Initializing attribute resolver cache...");
        ATTRIBUTE_CACHE.clear();
        BuiltInRegistries.f_256951_.forEach(attribute -> {
            ResourceLocation registryName = BuiltInRegistries.f_256951_.m_7981_(attribute);
            if (registryName != null) {
                String originalId = registryName.toString();
                String strippedId = AttributeResolver.stripSymbols(originalId);
                ATTRIBUTE_CACHE.put(strippedId, new AttributeInfo((Attribute)attribute, originalId, strippedId));
                String pathOnly = AttributeResolver.stripSymbols(registryName.m_135815_());
                if (!ATTRIBUTE_CACHE.containsKey(pathOnly)) {
                    ATTRIBUTE_CACHE.put(pathOnly, new AttributeInfo((Attribute)attribute, originalId, pathOnly));
                }
                LOGGER.debug("Cached attribute: {} (stripped: {})", (Object)originalId, (Object)strippedId);
            }
        });
        LOGGER.info("Cached {} attribute variations", (Object)ATTRIBUTE_CACHE.size());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Available attributes:");
            BuiltInRegistries.f_256951_.forEach(attr -> {
                ResourceLocation id = BuiltInRegistries.f_256951_.m_7981_(attr);
                if (id != null) {
                    LOGGER.debug("  - {} ({})", (Object)id, (Object)attr.m_22082_());
                }
            });
        }
    }

    private static int calculateMatchScore(String input, String candidate) {
        int score = 0;
        StringBuilder scoreLog = new StringBuilder();
        scoreLog.append(String.format("\u8ba1\u7b97 '%s' \u4e0e '%s' \u7684\u5339\u914d\u5ea6:\n", input, candidate));
        int levenshteinScore = 1000 / (AttributeResolver.calculateLevenshteinDistance(input, candidate) + 1);
        score = (int)((double)score + (double)levenshteinScore * 0.3);
        scoreLog.append(String.format("- Levenshtein\u5f97\u5206: %d * 0.3 = %.2f\n", levenshteinScore, (double)levenshteinScore * 0.3));
        int jaroWinklerScore = (int)(AttributeResolver.calculateJaroWinklerSimilarity(input, candidate) * 1000.0);
        score = (int)((double)score + (double)jaroWinklerScore * 0.4);
        scoreLog.append(String.format("- Jaro-Winkler\u5f97\u5206: %d * 0.4 = %.2f\n", jaroWinklerScore, (double)jaroWinklerScore * 0.4));
        int featureScore = 0;
        if (input.equals(candidate)) {
            featureScore += 1000;
            scoreLog.append("- \u5b8c\u5168\u5339\u914d: +1000\n");
        }
        if (candidate.contains(input)) {
            featureScore += 300;
            scoreLog.append("- \u5305\u542b\u5b8c\u6574\u8f93\u5165: +300\n");
        }
        if (candidate.startsWith("minecraft")) {
            featureScore += 50;
            scoreLog.append("- Minecraft\u547d\u540d\u7a7a\u95f4: +50\n");
        }
        for (AttributeInfo info : ATTRIBUTE_CACHE.values()) {
            String[] pathParts;
            String[] parts = info.strippedId.split(":");
            if (parts.length <= 1) continue;
            String attributePath = parts[1];
            for (String part : pathParts = attributePath.split("(?<=.)(?=\\p{Upper})|_")) {
                if (!input.contains(part.toLowerCase()) || !candidate.contains(part.toLowerCase())) continue;
                featureScore += 100;
                scoreLog.append(String.format("- \u5c5e\u6027\u90e8\u5206\u5339\u914d '%s': +100\n", part));
            }
        }
        score = (int)((double)score + (double)featureScore * 0.3);
        scoreLog.append(String.format("- \u7279\u5f81\u5f97\u5206: %d * 0.3 = %.2f\n", featureScore, (double)featureScore * 0.3));
        scoreLog.append(String.format("\u603b\u5206: %d\n", score));
        LOGGER.debug(scoreLog.toString());
        return score;
    }

    private static int calculateLevenshteinDistance(String s1, String s2) {
        int i;
        int[][] dp = new int[s1.length() + 1][s2.length() + 1];
        for (i = 0; i <= s1.length(); ++i) {
            dp[i][0] = i;
        }
        for (int j = 0; j <= s2.length(); ++j) {
            dp[0][j] = j;
        }
        for (i = 1; i <= s1.length(); ++i) {
            for (int j = 1; j <= s2.length(); ++j) {
                dp[i][j] = s1.charAt(i - 1) == s2.charAt(j - 1) ? dp[i - 1][j - 1] : Math.min(dp[i - 1][j - 1] + 1, Math.min(dp[i - 1][j] + 1, dp[i][j - 1] + 1));
            }
        }
        return dp[s1.length()][s2.length()];
    }

    private static double calculateJaroWinklerSimilarity(String s1, String s2) {
        int len1 = s1.length();
        int len2 = s2.length();
        if (len1 == 0 || len2 == 0) {
            return 0.0;
        }
        int matchDistance = Math.max(len1, len2) / 2 - 1;
        boolean[] s1Matches = new boolean[len1];
        boolean[] s2Matches = new boolean[len2];
        int matches = 0;
        block0: for (int i = 0; i < len1; ++i) {
            int start = Math.max(0, i - matchDistance);
            int end = Math.min(i + matchDistance + 1, len2);
            for (int j = start; j < end; ++j) {
                if (s2Matches[j] || s1.charAt(i) != s2.charAt(j)) continue;
                s1Matches[i] = true;
                s2Matches[j] = true;
                ++matches;
                continue block0;
            }
        }
        if (matches == 0) {
            return 0.0;
        }
        int transpositions = 0;
        int k = 0;
        for (int i = 0; i < len1; ++i) {
            if (!s1Matches[i]) continue;
            while (!s2Matches[k]) {
                ++k;
            }
            if (s1.charAt(i) != s2.charAt(k)) {
                ++transpositions;
            }
            ++k;
        }
        double jaro = ((double)matches / (double)len1 + (double)matches / (double)len2 + (double)(matches - transpositions / 2) / (double)matches) / 3.0;
        int prefixLength = 0;
        for (int i = 0; i < Math.min(4, Math.min(len1, len2)) && s1.charAt(i) == s2.charAt(i); ++i) {
            ++prefixLength;
        }
        return jaro + (double)prefixLength * 0.1 * (1.0 - jaro);
    }

    public static String getOriginalAttributeId(Attribute attribute) {
        ResourceLocation key = BuiltInRegistries.f_256951_.m_7981_((Object)attribute);
        return key != null ? key.toString() : null;
    }

    private static String stripSymbols(String input) {
        return input.toLowerCase().replaceAll("[^a-z0-9]", "");
    }

    private static AttributeInfo findBestMatch(String stripped, List<AttributeInfo> candidates) {
        AttributeInfo bestMatch = null;
        int bestScore = -1;
        for (AttributeInfo candidate : candidates) {
            int score = AttributeResolver.calculateMatchScore(stripped, candidate.strippedId);
            if (score <= bestScore) continue;
            bestScore = score;
            bestMatch = candidate;
        }
        return bestMatch;
    }

    public static String getStandardFormat(String attributeId) {
        try {
            LOGGER.debug("\u5c1d\u8bd5\u6807\u51c6\u5316\u5c5e\u6027ID: '{}'", (Object)attributeId);
            String strippedInput = AttributeResolver.stripSymbols(attributeId);
            for (AttributeInfo info : ATTRIBUTE_CACHE.values()) {
                if (!info.strippedId.equals(strippedInput)) continue;
                LOGGER.debug("\u627e\u5230\u5b8c\u5168\u5339\u914d: {}", (Object)info.originalId);
                return info.originalId;
            }
            LOGGER.warn("\u672a\u627e\u5230\u5339\u914d\u7684\u5c5e\u6027ID: '{}'", (Object)attributeId);
            LOGGER.debug("\u5c1d\u8bd5\u6a21\u7cca\u5339\u914d\u5904\u7406");
            AttributeInfo bestMatch = null;
            int bestScore = -1;
            for (AttributeInfo info : ATTRIBUTE_CACHE.values()) {
                int score = AttributeResolver.calculateMatchScore(strippedInput, info.strippedId);
                LOGGER.debug("\u6bd4\u8f83\u4e0e '{}' \u7684\u76f8\u4f3c\u5ea6: {}", (Object)info.originalId, (Object)score);
                if (score <= bestScore) continue;
                bestScore = score;
                bestMatch = info;
            }
            if (bestMatch != null) {
                LOGGER.info("\u627e\u5230\u6700\u4f73\u5339\u914d - \u8f93\u5165: '{}' -> \u5339\u914d: '{}' (\u76f8\u4f3c\u5ea6: {})", new Object[]{attributeId, bestMatch.originalId, bestScore});
                return bestMatch.originalId;
            }
            LOGGER.warn("\u672a\u627e\u5230\u5339\u914d\u7684\u5c5e\u6027ID: '{}'", (Object)attributeId);
            return attributeId;
        }
        catch (Exception e) {
            LOGGER.error("\u6807\u51c6\u5316\u5c5e\u6027ID\u65f6\u53d1\u751f\u9519\u8bef '{}': {}", (Object)attributeId, (Object)e.getMessage());
            return attributeId;
        }
    }

    public static Attribute resolveAttribute(String input) {
        if (input == null || input.isEmpty()) {
            LOGGER.warn("Null or empty attribute ID provided");
            return null;
        }
        try {
            AttributeInfo bestMatch;
            for (AttributeInfo info : ATTRIBUTE_CACHE.values()) {
                if (!info.originalId.equals(input)) continue;
                LOGGER.debug("\u627e\u5230\u5b8c\u5168\u5339\u914d\u7684\u5c5e\u6027: {}", (Object)input);
                return info.attribute;
            }
            LOGGER.debug("\u5f00\u59cb\u6807\u51c6\u5316\u5904\u7406: '{}'", (Object)input);
            String strippedInput = AttributeResolver.stripSymbols(input);
            LOGGER.debug("\u53bb\u9664\u7b26\u53f7\u540e\u7684ID: '{}'", (Object)strippedInput);
            ArrayList<AttributeInfo> possibleMatches = new ArrayList<AttributeInfo>();
            for (AttributeInfo info : ATTRIBUTE_CACHE.values()) {
                if (!info.strippedId.contains(strippedInput) && !strippedInput.contains(info.strippedId)) continue;
                possibleMatches.add(info);
            }
            if (!possibleMatches.isEmpty() && (bestMatch = AttributeResolver.findBestMatch(strippedInput, possibleMatches)) != null) {
                LOGGER.debug("\u627e\u5230\u6700\u4f73\u5339\u914d: {} -> {}", (Object)input, (Object)bestMatch.originalId);
                return bestMatch.attribute;
            }
            LOGGER.warn("\u65e0\u6cd5\u627e\u5230\u5339\u914d\u7684\u5c5e\u6027: '{}'", (Object)input);
            return null;
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u5c5e\u6027\u65f6\u53d1\u751f\u9519\u8bef '{}': {}", (Object)input, (Object)e.getMessage());
            return null;
        }
    }

    public static boolean isValidAttributeId(String attributeId) {
        try {
            try {
                ResourceLocation location = new ResourceLocation(attributeId);
                if (BuiltInRegistries.f_256951_.m_7804_(location)) {
                    return true;
                }
            }
            catch (Exception location) {
                // empty catch block
            }
            String strippedInput = AttributeResolver.stripSymbols(attributeId);
            for (AttributeInfo info : ATTRIBUTE_CACHE.values()) {
                if (!info.strippedId.equals(strippedInput)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static class AttributeInfo {
        public final Attribute attribute;
        public final String originalId;
        public final String strippedId;

        public AttributeInfo(Attribute attribute, String originalId, String strippedId) {
            this.attribute = attribute;
            this.originalId = originalId;
            this.strippedId = strippedId;
        }
    }
}

