/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.baublesreforked.modifier;

import com.jinqinxixi.baublesreforked.config.ModifierConfig;
import com.jinqinxixi.baublesreforked.items.ModifierItem;
import com.jinqinxixi.baublesreforked.modifier.AttributeResolver;
import com.jinqinxixi.baublesreforked.network.ModifierNetworkHandler;
import java.util.UUID;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.theillusivec4.curios.api.event.CurioAttributeModifierEvent;
import top.theillusivec4.curios.api.event.CurioChangeEvent;

@Mod.EventBusSubscriber(modid="baublesreforked")
public class CurioAttributeEvents {
    private static final Logger LOGGER = LoggerFactory.getLogger(CurioAttributeEvents.class);
    private static ModifierConfig config;
    public static final String TAG_MODIFIER_ID = "baublesreforked.ModifierId";
    public static final String TAG_MODIFIER_UUID = "baublesreforked.ModifierUUID";
    public static final String DEFAULT_NAMESPACE = "minecraft";
    public static final int DEFAULT_MATERIAL_COST = 1;

    public static void init() {
        ModifierConfig.getInstance();
        config = ModifierConfig.getInstance();
        AttributeResolver.initializeCache();
    }

    @SubscribeEvent
    public static void onLivingUpdate(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        player.m_150109_().f_35974_.forEach(stack -> {
            String itemId = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()).toString();
            if (config.isItemModifiable(itemId)) {
                CurioAttributeEvents.checkAndInitializeModifier(stack, player);
            }
        });
    }

    private static void processAttribute(ModifierConfig.AttributeEntry attr, UUID baseUuid, String itemId, ModifierConfig.ModifierEntry modifier, AttributeProcessor processor) {
        if (attr == null || baseUuid == null || itemId == null || modifier == null || processor == null) {
            LOGGER.warn("Null parameter passed to processAttribute");
            return;
        }
        Attribute attribute = AttributeResolver.resolveAttribute(attr.id);
        if (attribute == null) {
            LOGGER.error("Could not resolve attribute: {}", (Object)attr.id);
            return;
        }
        String standardAttributeId = AttributeResolver.getOriginalAttributeId(attribute);
        LOGGER.debug("Resolved attribute {} to standard format: {}", (Object)attr.id, (Object)standardAttributeId);
        UUID attrUuid = new UUID(baseUuid.getMostSignificantBits(), baseUuid.getLeastSignificantBits() ^ (long)attribute.hashCode());
        AttributeModifier attributeModifier = new AttributeModifier(attrUuid, String.format("%s.%s.%s", "baublesreforked", modifier.name, attribute.m_22087_()), attr.value, AttributeModifier.Operation.valueOf((String)attr.operation));
        processor.process(attribute, attributeModifier);
    }

    private static void checkAndInitializeModifier(ItemStack stack, Player player) {
        Object modifierUUID;
        String currentModifierId;
        ModifierConfig.ModifierEntry modifier;
        if (stack.m_41619_()) {
            return;
        }
        String itemId = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()).toString();
        CompoundTag tag = stack.m_41784_();
        boolean needsSync = false;
        if (!tag.m_128441_("IsInitialized")) {
            boolean shouldHaveModifier;
            double probability = config.getModifierApplyProbability();
            boolean bl = shouldHaveModifier = (double)player.m_217043_().m_188501_() < probability;
            if (shouldHaveModifier) {
                try {
                    ModifierConfig.ModifierEntry randomModifier = config.getRandomModifier();
                    if (randomModifier != null) {
                        UUID modifierUUID2 = UUID.randomUUID();
                        String modifierId = config.getModifierIdByName(randomModifier.name);
                        if (modifierId != null) {
                            tag.m_128359_(TAG_MODIFIER_ID, modifierId);
                            tag.m_128359_(TAG_MODIFIER_UUID, modifierUUID2.toString());
                            needsSync = true;
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Failed to generate modifier for item {}: {}", (Object)itemId, (Object)e.getMessage());
                }
            }
            tag.m_128379_("IsInitialized", true);
        } else if (tag.m_128441_(TAG_MODIFIER_ID) && (modifier = config.getModifier(currentModifierId = tag.m_128461_(TAG_MODIFIER_ID))) == null) {
            try {
                ModifierConfig.ModifierEntry randomModifier = config.getRandomModifier();
                if (randomModifier != null) {
                    modifierUUID = UUID.randomUUID();
                    String modifierId = config.getModifierIdByName(randomModifier.name);
                    if (modifierId != null) {
                        tag.m_128359_(TAG_MODIFIER_ID, modifierId);
                        tag.m_128359_(TAG_MODIFIER_UUID, ((UUID)modifierUUID).toString());
                        needsSync = true;
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to regenerate modifier for item {}: {}", (Object)itemId, (Object)e.getMessage());
            }
        }
        if (needsSync && !player.m_9236_().f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            int slot = player.m_150109_().m_36030_(stack);
            if (slot >= 0) {
                String modifierId = tag.m_128461_(TAG_MODIFIER_ID);
                modifierUUID = tag.m_128461_(TAG_MODIFIER_UUID);
                if (!modifierId.isEmpty() && !((String)modifierUUID).isEmpty()) {
                    ModifierNetworkHandler.sendToPlayer(serverPlayer, stack, modifierId, (String)modifierUUID, slot);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onCurioAttributeModifier(CurioAttributeModifierEvent event) {
        ItemStack stack = event.getItemStack();
        String itemId = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()).toString();
        if (!config.isItemModifiable(itemId)) {
            return;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_(TAG_MODIFIER_ID) || !tag.m_128441_(TAG_MODIFIER_UUID)) {
            return;
        }
        try {
            String modifierId = tag.m_128461_(TAG_MODIFIER_ID);
            String uuidString = tag.m_128461_(TAG_MODIFIER_UUID);
            ModifierConfig.ModifierEntry modifier = config.getModifier(modifierId);
            if (modifier == null) {
                return;
            }
            UUID baseUuid = UUID.fromString(uuidString);
            for (ModifierConfig.AttributeEntry attr : modifier.attributes) {
                CurioAttributeEvents.processAttribute(attr, baseUuid, itemId, modifier, (attribute, attributeModifier) -> event.addModifier(attribute, attributeModifier));
            }
        }
        catch (Exception e) {
            LOGGER.error("Error applying modifier for item {}: {}", (Object)itemId, (Object)e.getMessage());
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        float maxHealth;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        float currentHealth = player.m_21223_();
        if (currentHealth > (maxHealth = player.m_21233_())) {
            player.m_6469_(player.m_269291_().m_269264_(), 0.0f);
            player.m_21153_(maxHealth);
        } else if (Math.abs(currentHealth - player.m_21223_()) > 0.01f) {
            player.m_6469_(player.m_269291_().m_269264_(), 0.0f);
            player.m_21153_(currentHealth);
        }
    }

    @SubscribeEvent
    public static void onCurioChange(CurioChangeEvent event) {
        ItemStack removedStack = event.getFrom();
        ItemStack addedStack = event.getTo();
        if (removedStack.m_41619_()) {
            return;
        }
        String itemId = BuiltInRegistries.f_257033_.m_7981_((Object)removedStack.m_41720_()).toString();
        if (!config.isItemModifiable(itemId)) {
            return;
        }
        if (CurioAttributeEvents.hasSameModifier(removedStack, addedStack)) {
            return;
        }
        CurioAttributeEvents.removeModifierFromStack(removedStack, (Entity)event.getEntity());
    }

    private static boolean hasSameModifier(ItemStack stack1, ItemStack stack2) {
        if (stack1.m_41619_() || stack2.m_41619_()) {
            return false;
        }
        CompoundTag tag1 = stack1.m_41783_();
        CompoundTag tag2 = stack2.m_41783_();
        if (tag1 == null || tag2 == null) {
            return false;
        }
        if (!tag1.m_128441_(TAG_MODIFIER_UUID) || !tag2.m_128441_(TAG_MODIFIER_UUID)) {
            return false;
        }
        String uuid1 = tag1.m_128461_(TAG_MODIFIER_UUID);
        String uuid2 = tag2.m_128461_(TAG_MODIFIER_UUID);
        return uuid1.equals(uuid2);
    }

    private static void removeModifierFromStack(ItemStack stack, Entity entity) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_(TAG_MODIFIER_ID) || !tag.m_128441_(TAG_MODIFIER_UUID)) {
            return;
        }
        try {
            String modifierId = tag.m_128461_(TAG_MODIFIER_ID);
            String uuidString = tag.m_128461_(TAG_MODIFIER_UUID);
            ModifierConfig.ModifierEntry modifier = config.getModifier(modifierId);
            if (modifier == null) {
                return;
            }
            UUID baseUuid = UUID.fromString(uuidString);
            for (ModifierConfig.AttributeEntry attr : modifier.attributes) {
                CurioAttributeEvents.processAttribute(attr, baseUuid, BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()).toString(), modifier, (attribute, attributeModifier) -> {
                    AttributeInstance instance = player.m_21051_(attribute);
                    if (instance != null) {
                        instance.m_22120_(attributeModifier.m_22209_());
                        if (attribute == Attributes.f_22276_) {
                            player.m_21153_(Math.min(player.m_21223_(), player.m_21233_()));
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            LOGGER.error("Error removing modifier from item {}: {}", (Object)BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()), (Object)e.getMessage());
        }
    }

    @SubscribeEvent
    public static void onAnvilUpdate(AnvilUpdateEvent event) {
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        if (left.m_41619_() || right.m_41619_()) {
            return;
        }
        String leftItemId = BuiltInRegistries.f_257033_.m_7981_((Object)left.m_41720_()).toString();
        if (!config.isItemModifiable(leftItemId)) {
            return;
        }
        if (right.m_41720_() instanceof ModifierItem) {
            CurioAttributeEvents.handleModifierBook(event, left, right);
            return;
        }
        String rightItemId = BuiltInRegistries.f_257033_.m_7981_((Object)right.m_41720_()).toString();
        ModifierConfig.ReforgeConfig reforgeConfig = config.getReforgeConfig(leftItemId);
        if (reforgeConfig != null && rightItemId.equals(reforgeConfig.requiredItem)) {
            CurioAttributeEvents.handleReforge(event, left, reforgeConfig);
        }
    }

    private static void handleModifierBook(AnvilUpdateEvent event, ItemStack left, ItemStack right) {
        String modifierId = ModifierItem.getModifierId(right);
        if (modifierId.isEmpty()) {
            return;
        }
        ModifierConfig.ModifierEntry modifier = config.getModifier(modifierId);
        if (modifier == null) {
            return;
        }
        ItemStack output = left.m_41777_();
        CompoundTag tag = output.m_41784_();
        if (tag.m_128441_(TAG_MODIFIER_ID)) {
            tag.m_128473_(TAG_MODIFIER_ID);
        }
        if (tag.m_128441_(TAG_MODIFIER_UUID)) {
            tag.m_128473_(TAG_MODIFIER_UUID);
        }
        tag.m_128359_(TAG_MODIFIER_ID, modifierId);
        tag.m_128359_(TAG_MODIFIER_UUID, UUID.randomUUID().toString());
        String newName = event.getName();
        if (newName != null && !newName.isEmpty() && !newName.equals(left.m_41786_().getString())) {
            output.m_41714_((Component)Component.m_237113_((String)newName));
        }
        event.setOutput(output);
        event.setCost(config.getModifierBookExperience());
        event.setMaterialCost(1);
    }

    private static void handleReforge(AnvilUpdateEvent event, ItemStack left, ModifierConfig.ReforgeConfig reforgeConfig) {
        ModifierConfig.ModifierEntry newModifier;
        ItemStack output = left.m_41777_();
        CompoundTag outputTag = output.m_41784_();
        if (outputTag.m_128441_(TAG_MODIFIER_ID)) {
            outputTag.m_128473_(TAG_MODIFIER_ID);
        }
        if (outputTag.m_128441_(TAG_MODIFIER_UUID)) {
            outputTag.m_128473_(TAG_MODIFIER_UUID);
        }
        if ((newModifier = config.getRandomModifier()) != null) {
            String modifierId = config.getModifierIdByName(newModifier.name);
            if (modifierId != null) {
                outputTag.m_128359_(TAG_MODIFIER_ID, modifierId);
                outputTag.m_128359_(TAG_MODIFIER_UUID, UUID.randomUUID().toString());
                LOGGER.debug("Applied random modifier {} to item during reforge in AnvilUpdateEvent", (Object)modifierId);
            }
        } else {
            LOGGER.warn("Failed to get random modifier for reforge");
        }
        String newName = event.getName();
        if (newName != null && !newName.isEmpty() && !newName.equals(left.m_41786_().getString())) {
            output.m_41714_((Component)Component.m_237113_((String)newName));
        }
        event.setOutput(output);
        event.setCost(reforgeConfig.experienceCost);
        event.setMaterialCost(reforgeConfig.materialCost);
        LOGGER.debug("Reforge handled in AnvilUpdateEvent - Cost: {}, MaterialCost: {}", (Object)reforgeConfig.experienceCost, (Object)reforgeConfig.materialCost);
    }

    @SubscribeEvent
    public static void onAnvilRepair(AnvilRepairEvent event) {
        LOGGER.debug("AnvilRepairEvent triggered - Output: {}, Player: {}", (Object)event.getOutput().m_41720_(), (Object)event.getEntity().m_7755_().getString());
        ItemStack result = event.getOutput();
        ItemStack right = event.getRight();
        if (result.m_41619_()) {
            LOGGER.debug("AnvilRepairEvent output is empty, skipping");
            return;
        }
        String itemId = BuiltInRegistries.f_257033_.m_7981_((Object)result.m_41720_()).toString();
        if (!config.isItemModifiable(itemId)) {
            return;
        }
        try {
            CompoundTag tag;
            String modifierId;
            if (right.m_41720_() instanceof ModifierItem && !(modifierId = ModifierItem.getModifierId(right)).isEmpty() && !(tag = result.m_41784_()).m_128441_(TAG_MODIFIER_ID)) {
                tag.m_128359_(TAG_MODIFIER_ID, modifierId);
                tag.m_128359_(TAG_MODIFIER_UUID, UUID.randomUUID().toString());
                LOGGER.debug("Applied modifier book modifier {} in AnvilRepairEvent", (Object)modifierId);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error applying modifier for anvil result {}: {}", (Object)itemId, (Object)e.getMessage());
        }
    }

    @FunctionalInterface
    private static interface AttributeProcessor {
        public void process(Attribute var1, AttributeModifier var2);
    }
}

