/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.baublesreforked.modifier;

import com.jinqinxixi.baublesreforked.config.ModifierConfig;
import com.jinqinxixi.baublesreforked.items.ModifierItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AnvilScreen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ModifierTooltipHelper {
    private static MutableComponent getModifierDisplayName(String modifierId, ModifierConfig.ModifierEntry modifier) {
        String translationKey = "modifier.baublesreforked." + modifierId;
        MutableComponent translatedName = Component.m_237115_((String)translationKey);
        String translatedString = translatedName.getString();
        if (!translatedString.equals(translationKey)) {
            return translatedName.m_130946_("\uff1a").m_130940_(ChatFormatting.valueOf((String)modifier.color));
        }
        return Component.m_237113_((String)(modifier.name + "\uff1a")).m_130940_(ChatFormatting.valueOf((String)modifier.color));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onItemTooltip(ItemTooltipEvent event) {
        AnvilScreen anvilScreen;
        ItemStack resultSlotItem;
        if (!ModifierConfig.getInstance().useModifierTooltip()) {
            return;
        }
        ItemStack stack = event.getItemStack();
        List tooltip = event.getToolTip();
        String itemId = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()).toString();
        ModifierConfig config = ModifierConfig.getInstance();
        if (!config.isItemModifiable(itemId)) {
            return;
        }
        boolean isAnvilPreview = false;
        boolean isRenamingOnly = false;
        ItemStack rightSlotItem = null;
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof AnvilScreen && stack == (resultSlotItem = ((AnvilMenu)(anvilScreen = (AnvilScreen)screen).m_6262_()).m_38853_(2).m_7993_())) {
            isAnvilPreview = true;
            rightSlotItem = ((AnvilMenu)anvilScreen.m_6262_()).m_38853_(1).m_7993_();
            ItemStack leftSlotItem = ((AnvilMenu)anvilScreen.m_6262_()).m_38853_(0).m_7993_();
            if (rightSlotItem.m_41619_()) {
                isRenamingOnly = true;
            } else {
                String rightItemId = BuiltInRegistries.f_257033_.m_7981_((Object)rightSlotItem.m_41720_()).toString();
                ModifierConfig.ReforgeConfig reforgeConfig = config.getReforgeConfig(itemId);
                if (reforgeConfig == null || !rightItemId.equals(reforgeConfig.requiredItem)) {
                    isRenamingOnly = true;
                }
            }
        }
        CompoundTag tag = stack.m_41783_();
        if (isAnvilPreview) {
            if (isRenamingOnly) {
                if (tag == null || !tag.m_128441_("baublesreforked.ModifierId")) return;
                try {
                    modifierId = tag.m_128461_("baublesreforked.ModifierId");
                    modifier = config.getModifier(modifierId);
                    if (modifier == null) return;
                    tooltip.add(ModifierTooltipHelper.getModifierDisplayName(modifierId, modifier));
                    for (ModifierConfig.AttributeEntry attr : modifier.attributes) {
                        String formattedValue = ModifierTooltipHelper.formatAttributeValue(attr);
                        MutableComponent attrComponent = Component.m_237115_((String)("attribute.name." + attr.id)).m_130940_(ChatFormatting.GOLD).m_130946_(" " + formattedValue).m_130940_(attr.value >= 0.0 ? ChatFormatting.GREEN : ChatFormatting.RED);
                        tooltip.add(attrComponent);
                    }
                    return;
                }
                catch (Exception modifierId) {
                    return;
                }
            } else if (rightSlotItem != null && rightSlotItem.m_41720_() instanceof ModifierItem) {
                modifierId = ModifierItem.getModifierId(rightSlotItem);
                if (modifierId.isEmpty() || (modifier = config.getModifier(modifierId)) == null) return;
                tooltip.add(ModifierTooltipHelper.getModifierDisplayName(modifierId, modifier));
                for (ModifierConfig.AttributeEntry attr : modifier.attributes) {
                    String formattedValue = ModifierTooltipHelper.formatAttributeValue(attr);
                    MutableComponent attrComponent = Component.m_237115_((String)("attribute.name." + attr.id)).m_130940_(ChatFormatting.GOLD).m_130946_(" " + formattedValue).m_130940_(attr.value >= 0.0 ? ChatFormatting.GREEN : ChatFormatting.RED);
                    tooltip.add(attrComponent);
                }
                return;
            } else {
                tooltip.add(Component.m_237115_((String)"tooltip.baublesreforked.unidentified").m_130940_(ChatFormatting.GRAY));
            }
            return;
        } else if (tag != null) {
            if (tag.m_128441_("IsInitialized")) {
                if (!tag.m_128441_("baublesreforked.ModifierId")) return;
                try {
                    modifierId = tag.m_128461_("baublesreforked.ModifierId");
                    modifier = config.getModifier(modifierId);
                    if (modifier == null) return;
                    tooltip.add(ModifierTooltipHelper.getModifierDisplayName(modifierId, modifier));
                    for (ModifierConfig.AttributeEntry attr : modifier.attributes) {
                        String formattedValue = ModifierTooltipHelper.formatAttributeValue(attr);
                        tooltip.add(Component.m_237115_((String)("attribute.name." + attr.id)).m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)(" " + formattedValue)).m_130940_(attr.value >= 0.0 ? ChatFormatting.GREEN : ChatFormatting.RED)));
                    }
                    return;
                }
                catch (Exception exception) {
                    return;
                }
            } else {
                tooltip.add(Component.m_237115_((String)"tooltip.baublesreforked.unidentified").m_130940_(ChatFormatting.GRAY));
            }
            return;
        } else {
            tooltip.add(Component.m_237115_((String)"tooltip.baublesreforked.unidentified").m_130940_(ChatFormatting.GRAY));
        }
    }

    private static String formatAttributeValue(ModifierConfig.AttributeEntry attr) {
        if (attr.id.equals("baublesreforked:life_steal") || attr.id.equals("minecraft:generic.knockback_resistance")) {
            return String.format("%+.1f%%", attr.value * 100.0);
        }
        if (AttributeModifier.Operation.valueOf((String)attr.operation) == AttributeModifier.Operation.ADDITION) {
            if (attr.value == (double)((int)attr.value)) {
                return String.format("%+d", (int)attr.value);
            }
            return String.format("%+.2f", attr.value);
        }
        return String.format("%+.1f%%", attr.value * 100.0);
    }
}

