/*
 * Decompiled with CFR 0.152.
 */
package com.jinqinxixi.baublesreforked.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class ModifierNetworkHandler {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("baublesreforked", "modifier_sync"), () -> "1", "1"::equals, "1"::equals);

    public static void register() {
        int id = 0;
        INSTANCE.messageBuilder(SyncModifierDataPacket.class, id++).encoder(SyncModifierDataPacket::encode).decoder(SyncModifierDataPacket::decode).consumerMainThread(SyncModifierDataPacket::handle).add();
    }

    public static void sendToPlayer(ServerPlayer player, ItemStack stack, String modifierId, String modifierUUID, int slot) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncModifierDataPacket(stack, modifierId, modifierUUID, slot));
    }

    public static class SyncModifierDataPacket {
        private final ItemStack stack;
        private final String modifierId;
        private final String modifierUUID;
        private final int inventorySlot;

        public SyncModifierDataPacket(ItemStack stack, String modifierId, String modifierUUID, int slot) {
            this.stack = stack;
            this.modifierId = modifierId;
            this.modifierUUID = modifierUUID;
            this.inventorySlot = slot;
        }

        public static void encode(SyncModifierDataPacket packet, FriendlyByteBuf buffer) {
            buffer.m_130055_(packet.stack);
            buffer.m_130070_(packet.modifierId);
            buffer.m_130070_(packet.modifierUUID);
            buffer.writeInt(packet.inventorySlot);
        }

        public static SyncModifierDataPacket decode(FriendlyByteBuf buffer) {
            return new SyncModifierDataPacket(buffer.m_130267_(), buffer.m_130277_(), buffer.m_130277_(), buffer.readInt());
        }

        public static void handle(SyncModifierDataPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (context.getDirection().getReceptionSide().isClient()) {
                    ItemStack stack;
                    Minecraft minecraft = Minecraft.m_91087_();
                    if (minecraft.f_91074_ != null && !(stack = minecraft.f_91074_.m_150109_().m_8020_(packet.inventorySlot)).m_41619_()) {
                        stack.m_41784_().m_128379_("IsInitialized", true);
                        if (!packet.modifierId.isEmpty() && !packet.modifierUUID.isEmpty()) {
                            stack.m_41784_().m_128359_("baublesreforked.ModifierId", packet.modifierId);
                            stack.m_41784_().m_128359_("baublesreforked.ModifierUUID", packet.modifierUUID);
                        } else if (stack.m_41783_() != null) {
                            stack.m_41783_().m_128473_("baublesreforked.ModifierId");
                            stack.m_41783_().m_128473_("baublesreforked.ModifierUUID");
                        }
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }
}

