/*
 * Decompiled with CFR 0.152.
 */
package net.infugogr.barracuda.block;

import java.util.Locale;
import net.infugogr.barracuda.block.entity.LVcableBlockEntity;
import net.infugogr.barracuda.block.entity.ModBlockEntityType;
import net.infugogr.barracuda.util.TickableBlockEntity;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_247;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3542;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_6760;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;

public class LVcableBlock
extends class_2248
implements class_3737,
class_2343 {
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2754<ConnectorType> NORTH = class_2754.method_11850((String)"north", ConnectorType.class);
    public static final class_2754<ConnectorType> SOUTH = class_2754.method_11850((String)"south", ConnectorType.class);
    public static final class_2754<ConnectorType> WEST = class_2754.method_11850((String)"west", ConnectorType.class);
    public static final class_2754<ConnectorType> EAST = class_2754.method_11850((String)"east", ConnectorType.class);
    public static final class_2754<ConnectorType> UP = class_2754.method_11850((String)"up", ConnectorType.class);
    public static final class_2754<ConnectorType> DOWN = class_2754.method_11850((String)"down", ConnectorType.class);
    private static final class_265 SHAPE_CABLE_NORTH = class_259.method_1081((double)0.4375, (double)0.4375, (double)0.0, (double)0.5625, (double)0.5625, (double)0.4375);
    private static final class_265 SHAPE_CABLE_SOUTH = class_259.method_1081((double)0.4375, (double)0.4375, (double)0.5625, (double)0.5625, (double)0.5625, (double)1.0);
    private static final class_265 SHAPE_CABLE_WEST = class_259.method_1081((double)0.0, (double)0.4375, (double)0.4375, (double)0.4375, (double)0.5625, (double)0.5625);
    private static final class_265 SHAPE_CABLE_EAST = class_259.method_1081((double)0.5625, (double)0.4375, (double)0.4375, (double)1.0, (double)0.5625, (double)0.5625);
    private static final class_265 SHAPE_CABLE_UP = class_259.method_1081((double)0.4375, (double)0.5625, (double)0.4375, (double)0.5625, (double)1.0, (double)0.5625);
    private static final class_265 SHAPE_CABLE_DOWN = class_259.method_1081((double)0.4375, (double)0.0, (double)0.4375, (double)0.5625, (double)0.4375, (double)0.5625);
    private static final class_265 SHAPE_BLOCK_NORTH = class_259.method_1081((double)0.4375, (double)0.4375, (double)0.0, (double)0.5625, (double)0.5625, (double)0.125);
    private static final class_265 SHAPE_BLOCK_SOUTH = class_259.method_1081((double)0.4375, (double)0.4375, (double)0.875, (double)0.5625, (double)0.5625, (double)1.0);
    private static final class_265 SHAPE_BLOCK_WEST = class_259.method_1081((double)0.0, (double)0.4375, (double)0.4375, (double)0.125, (double)0.5625, (double)0.5625);
    private static final class_265 SHAPE_BLOCK_EAST = class_259.method_1081((double)0.875, (double)0.4375, (double)0.4375, (double)1.0, (double)0.5625, (double)0.5625);
    private static final class_265 SHAPE_BLOCK_UP = class_259.method_1081((double)0.4375, (double)0.875, (double)0.4375, (double)0.5625, (double)1.0, (double)0.5625);
    private static final class_265 SHAPE_BLOCK_DOWN = class_259.method_1081((double)0.4375, (double)0.0, (double)0.4375, (double)0.5625, (double)0.125, (double)0.5625);
    private static class_265[] shapeCache = null;

    public LVcableBlock(class_4970.class_2251 settings) {
        super(settings);
        LVcableBlock.createShapes();
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    private static int calculateShapeIndex(ConnectorType north, ConnectorType south, ConnectorType west, ConnectorType east, ConnectorType up, ConnectorType down) {
        int size = ConnectorType.values().length;
        return ((((south.ordinal() * size + north.ordinal()) * size + west.ordinal()) * size + east.ordinal()) * size + up.ordinal()) * size + down.ordinal();
    }

    private static void createShapes() {
        if (shapeCache == null) {
            int length = ConnectorType.values().length;
            shapeCache = new class_265[length * length * length * length * length * length];
            for (ConnectorType up : ConnectorType.VALUES) {
                for (ConnectorType down : ConnectorType.VALUES) {
                    for (ConnectorType north : ConnectorType.VALUES) {
                        for (ConnectorType south : ConnectorType.VALUES) {
                            for (ConnectorType east : ConnectorType.VALUES) {
                                for (ConnectorType west : ConnectorType.VALUES) {
                                    int idx = LVcableBlock.calculateShapeIndex(north, south, west, east, up, down);
                                    LVcableBlock.shapeCache[idx] = LVcableBlock.createShape(north, south, west, east, up, down);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private static class_265 createShape(ConnectorType north, ConnectorType south, ConnectorType west, ConnectorType east, ConnectorType up, ConnectorType down) {
        class_265 shape = class_259.method_1081((double)0.4375, (double)0.4375, (double)0.4375, (double)0.5625, (double)0.5625, (double)0.5625);
        shape = LVcableBlock.combineShape(shape, north, SHAPE_CABLE_NORTH, SHAPE_BLOCK_NORTH);
        shape = LVcableBlock.combineShape(shape, south, SHAPE_CABLE_SOUTH, SHAPE_BLOCK_SOUTH);
        shape = LVcableBlock.combineShape(shape, west, SHAPE_CABLE_WEST, SHAPE_BLOCK_WEST);
        shape = LVcableBlock.combineShape(shape, east, SHAPE_CABLE_EAST, SHAPE_BLOCK_EAST);
        shape = LVcableBlock.combineShape(shape, up, SHAPE_CABLE_UP, SHAPE_BLOCK_UP);
        shape = LVcableBlock.combineShape(shape, down, SHAPE_CABLE_DOWN, SHAPE_BLOCK_DOWN);
        return shape;
    }

    private static class_265 combineShape(class_265 shape, ConnectorType connectorType, class_265 cableShape, class_265 blockShape) {
        if (connectorType == ConnectorType.CABLE) {
            return class_259.method_1082((class_265)shape, (class_265)cableShape, (class_247)class_247.field_1366);
        }
        if (connectorType == ConnectorType.BLOCK) {
            return class_259.method_1082((class_265)shape, (class_265)class_259.method_1082((class_265)blockShape, (class_265)cableShape, (class_247)class_247.field_1366), (class_247)class_247.field_1366);
        }
        return shape;
    }

    private static ConnectorType getConnectorType(class_1937 world, class_2338 connectorPos, class_2350 facing) {
        class_2338 pos = connectorPos.method_10093(facing);
        class_2680 state = world.method_8320(pos);
        class_2248 block = state.method_26204();
        if (block instanceof LVcableBlock) {
            return ConnectorType.CABLE;
        }
        if (LVcableBlock.isConnectable(world, connectorPos, facing)) {
            return ConnectorType.BLOCK;
        }
        return ConnectorType.NONE;
    }

    public static boolean isConnectable(class_1937 world, class_2338 connectorPos, class_2350 facing) {
        class_2338 pos = connectorPos.method_10093(facing);
        class_2680 state = world.method_8320(pos);
        if (state.method_26215()) {
            return false;
        }
        return EnergyStorage.SIDED.find(world, pos, (Object)facing.method_10153()) != null;
    }

    @NotNull
    public static class_2680 calculateState(class_1937 world, class_2338 pos, class_2680 state) {
        ConnectorType north = LVcableBlock.getConnectorType(world, pos, class_2350.field_11043);
        ConnectorType south = LVcableBlock.getConnectorType(world, pos, class_2350.field_11035);
        ConnectorType west = LVcableBlock.getConnectorType(world, pos, class_2350.field_11039);
        ConnectorType east = LVcableBlock.getConnectorType(world, pos, class_2350.field_11034);
        ConnectorType up = LVcableBlock.getConnectorType(world, pos, class_2350.field_11036);
        ConnectorType down = LVcableBlock.getConnectorType(world, pos, class_2350.field_11033);
        return (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)state.method_11657(NORTH, (Comparable)((Object)north))).method_11657(SOUTH, (Comparable)((Object)south))).method_11657(WEST, (Comparable)((Object)west))).method_11657(EAST, (Comparable)((Object)east))).method_11657(UP, (Comparable)((Object)up))).method_11657(DOWN, (Comparable)((Object)down));
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        ConnectorType north = (ConnectorType)((Object)state.method_11654(NORTH));
        ConnectorType south = (ConnectorType)((Object)state.method_11654(SOUTH));
        ConnectorType west = (ConnectorType)((Object)state.method_11654(WEST));
        ConnectorType east = (ConnectorType)((Object)state.method_11654(EAST));
        ConnectorType up = (ConnectorType)((Object)state.method_11654(UP));
        ConnectorType down = (ConnectorType)((Object)state.method_11654(DOWN));
        int index = LVcableBlock.calculateShapeIndex(north, south, west, east, up, down);
        return shapeCache[index];
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_8405().method_39363(new class_6760((Object)class_3612.field_15910, pos, (long)class_3612.field_15910.method_15789((class_4538)world), 0L));
        }
        return LVcableBlock.calculateState((class_1937)world, pos, state);
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        class_2680 blockState;
        class_2586 class_25862;
        super.method_9612(state, world, pos, sourceBlock, sourcePos, notify);
        if (!world.field_9236 && (class_25862 = world.method_8321(pos)) instanceof LVcableBlockEntity) {
            LVcableBlockEntity cable = (LVcableBlockEntity)class_25862;
            cable.method_5431();
        }
        if ((blockState = LVcableBlock.calculateState(world, pos, state)) != state) {
            world.method_8501(pos, blockState);
        }
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{WATERLOGGED, NORTH, SOUTH, WEST, EAST, UP, DOWN});
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_1937 world = ctx.method_8045();
        class_2338 pos = ctx.method_8037();
        class_2680 state = (class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(world.method_8316(pos).method_15772() == class_3612.field_15910));
        return LVcableBlock.calculateState(world, pos, state);
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return ModBlockEntityType.LVCABLE.method_11032(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return TickableBlockEntity.createTicker(world);
    }

    public static enum ConnectorType implements class_3542
    {
        NONE,
        CABLE,
        BLOCK;

        public static final ConnectorType[] VALUES;

        @NotNull
        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            VALUES = ConnectorType.values();
        }
    }
}

