/*
 * Decompiled with CFR 0.152.
 */
package net.infugogr.barracuda.block.entity;

import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.infugogr.barracuda.Barracuda;
import net.infugogr.barracuda.block.entity.ModBlockEntityType;
import net.infugogr.barracuda.screenhandler.FuelGeneratorScreenHandler;
import net.infugogr.barracuda.util.SyncableStorage;
import net.infugogr.barracuda.util.SyncableTickableBlockEntity;
import net.infugogr.barracuda.util.UpdatableBlockEntity;
import net.infugogr.barracuda.util.energy.EnergySpreader;
import net.infugogr.barracuda.util.energy.SyncingEnergyStorage;
import net.infugogr.barracuda.util.energy.WrappedEnergyStorage;
import net.infugogr.barracuda.util.inventory.SyncingSimpleInventory;
import net.infugogr.barracuda.util.inventory.WrappedInventoryStorage;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2609;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.base.SimpleEnergyStorage;

public class FuelGeneratorBlockEntity
extends UpdatableBlockEntity
implements SyncableTickableBlockEntity,
EnergySpreader,
ExtendedScreenHandlerFactory {
    public static final class_2561 TITLE = Barracuda.containerTitle("fuel_generator");
    private final WrappedEnergyStorage energyStorage = new WrappedEnergyStorage();
    private final WrappedInventoryStorage<class_1277> inventoryStorage = new WrappedInventoryStorage();
    protected final class_3913 propertyDelegate;
    private int progress = 0;
    private int maxProgress = 0;
    private int output = 0;

    public FuelGeneratorBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntityType.FUEL_GENERATOR, pos, state);
        this.energyStorage.addStorage(new SyncingEnergyStorage(this, 5000L, 0L, 100L));
        this.inventoryStorage.addInventory(new SyncingSimpleInventory((UpdatableBlockEntity)this, 1));
        this.propertyDelegate = new class_3913(){

            public int method_17390(int index) {
                return switch (index) {
                    case 0 -> FuelGeneratorBlockEntity.this.progress;
                    case 1 -> FuelGeneratorBlockEntity.this.maxProgress;
                    case 2 -> (int)FuelGeneratorBlockEntity.this.energyStorage.getStorage(null).getAmount();
                    case 3 -> (int)FuelGeneratorBlockEntity.this.energyStorage.getStorage(null).getCapacity();
                    default -> 0;
                };
            }

            public void method_17391(int index, int value) {
            }

            public int method_17389() {
                return 4;
            }
        };
    }

    @Override
    public List<SyncableStorage> getSyncableStorages() {
        SyncingEnergyStorage energy = (SyncingEnergyStorage)this.energyStorage.getStorage(null);
        SyncingSimpleInventory inventory = (SyncingSimpleInventory)this.inventoryStorage.getInventory(0);
        assert (inventory != null);
        return List.of(energy, inventory);
    }

    @Override
    public void onTick() {
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        SimpleEnergyStorage energyStorage = this.energyStorage.getStorage(null);
        this.spread(this.field_11863, this.field_11867, energyStorage);
        if (this.progress > 0) {
            --this.progress;
        }
        if (energyStorage.getAmount() >= energyStorage.getCapacity()) {
            if (energyStorage.getAmount() > energyStorage.getCapacity()) {
                energyStorage.amount -= energyStorage.getAmount() - energyStorage.getCapacity();
            }
            return;
        }
        if (this.progress > 0) {
            energyStorage.amount += (long)this.output;
        } else {
            class_1277 inventory = this.inventoryStorage.getInventory(0);
            assert (inventory != null);
            class_1799 stack = inventory.method_5438(0);
            if (this.isFuel(stack)) {
                this.maxProgress = this.getFuelTime(stack);
                this.progress = this.getFuelTime(stack);
                this.output = this.getFuelTime(stack) / 220;
                stack.method_7934(1);
                this.update();
            }
        }
    }

    @Override
    public void writeScreenOpeningData(class_3222 serverPlayerEntity, class_2540 packetByteBuf) {
        packetByteBuf.method_10807(this.field_11867);
    }

    public void method_11007(class_2487 nbt) {
        nbt.method_10566("EnergyStorage", (class_2520)this.energyStorage.writeNbt());
        nbt.method_10566("Inventory", (class_2520)this.inventoryStorage.writeNbt());
        nbt.method_10569("BurnTime", this.progress);
        nbt.method_10569("FuelTime", this.maxProgress);
    }

    public void method_11014(class_2487 nbt) {
        this.energyStorage.readNbt(nbt.method_10554("EnergyStorage", 10));
        this.inventoryStorage.readNbt(nbt.method_10554("Inventory", 10));
        this.progress = nbt.method_10550("BurnTime");
        this.maxProgress = nbt.method_10550("FuelTime");
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public class_2561 method_5476() {
        return TITLE;
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new FuelGeneratorScreenHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    public boolean isFuel(class_1799 stack) {
        return class_2609.method_11196().containsKey(stack.method_7909());
    }

    public int getFuelTime(class_1799 stack) {
        return class_2609.method_11196().getOrDefault(stack.method_7909(), 0);
    }

    public WrappedInventoryStorage<class_1277> getWrappedInventoryStorage() {
        return this.inventoryStorage;
    }

    public EnergyStorage getEnergyProvider(class_2350 direction) {
        return this.energyStorage.getStorage(direction);
    }

    public boolean isValid(class_1799 itemStack, int slot) {
        return slot == 0 && this.isFuel(itemStack);
    }

    public InventoryStorage getInventoryProvider(class_2350 direction) {
        return this.inventoryStorage.getStorage(direction);
    }

    public class_1799 getRenderStack() {
        return Objects.requireNonNull(this.inventoryStorage.getInventory(0)).method_5438(0);
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }
}

