/*
 * Decompiled with CFR 0.152.
 */
package net.infugogr.barracuda.block.entity;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.infugogr.barracuda.block.entity.ModBlockEntityType;
import net.infugogr.barracuda.util.SyncableStorage;
import net.infugogr.barracuda.util.SyncableTickableBlockEntity;
import net.infugogr.barracuda.util.UpdatableBlockEntity;
import net.infugogr.barracuda.util.energy.SyncingEnergyStorage;
import net.infugogr.barracuda.util.energy.WrappedEnergyStorage;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.base.SimpleEnergyStorage;

public class LVcableBlockEntity
extends UpdatableBlockEntity
implements SyncableTickableBlockEntity {
    private final WrappedEnergyStorage wrappedEnergyStorage = new WrappedEnergyStorage();
    private Set<class_2338> connectedBlocks = null;

    protected LVcableBlockEntity(class_2591<?> blockEntityType, class_2338 blockPos, class_2680 blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public LVcableBlockEntity(class_2338 blockPos, class_2680 blockState) {
        this(ModBlockEntityType.LVCABLE, blockPos, blockState);
        this.wrappedEnergyStorage.addStorage(new SyncingEnergyStorage(this, 1000L, 100L, 0L));
    }

    private void checkOutputs() {
        if (this.connectedBlocks == null && this.field_11863 != null) {
            this.connectedBlocks = new HashSet<class_2338>();
            this.traverse(this.field_11867, cable -> {
                for (class_2350 direction : class_2350.values()) {
                    class_2338 pos = cable.method_11016().method_10093(direction);
                    EnergyStorage storage = (EnergyStorage)EnergyStorage.SIDED.find(this.field_11863, pos, (Object)direction.method_10153());
                    if (storage == null || !storage.supportsInsertion() || this.field_11863.method_8321(pos) instanceof LVcableBlockEntity) continue;
                    this.connectedBlocks.add(pos);
                }
            });
        }
    }

    private void traverse(class_2338 pos, Consumer<LVcableBlockEntity> consumer) {
        HashSet<class_2338> traversed = new HashSet<class_2338>();
        traversed.add(pos);
        consumer.accept(this);
        this.traverse(pos, traversed, consumer);
    }

    private void traverse(class_2338 pos, Set<class_2338> traversed, Consumer<LVcableBlockEntity> consumer) {
        if (this.field_11863 == null) {
            return;
        }
        for (class_2350 direction : class_2350.values()) {
            class_2338 offset = pos.method_10093(direction);
            if (traversed.contains(offset)) continue;
            traversed.add(offset);
            class_2586 class_25862 = this.field_11863.method_8321(offset);
            if (!(class_25862 instanceof LVcableBlockEntity)) continue;
            LVcableBlockEntity cable = (LVcableBlockEntity)class_25862;
            consumer.accept(cable);
            cable.traverse(offset, traversed, consumer);
        }
    }

    @Override
    public List<SyncableStorage> getSyncableStorages() {
        return List.of((SyncableStorage)this.wrappedEnergyStorage.getStorage(null));
    }

    @Override
    public void onTick() {
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        SimpleEnergyStorage energy = this.getEnergy();
        if (energy.amount > 0L) {
            this.checkOutputs();
            if (this.connectedBlocks.isEmpty()) {
                return;
            }
            long amount = energy.getAmount() / (long)this.connectedBlocks.size();
            try (Transaction transaction = Transaction.openOuter();){
                for (class_2338 pos : this.connectedBlocks) {
                    EnergyStorage storage;
                    class_2350 direction = class_2350.method_50026((int)(this.field_11867.method_10263() - pos.method_10263()), (int)(this.field_11867.method_10264() - pos.method_10264()), (int)(this.field_11867.method_10260() - pos.method_10260()));
                    if (direction == null || (storage = (EnergyStorage)EnergyStorage.SIDED.find(this.field_11863, pos, (Object)direction)) == null || !storage.supportsInsertion()) continue;
                    energy.amount -= storage.insert(amount, (TransactionContext)transaction);
                }
                transaction.commit();
            }
        }
    }

    @Override
    public void writeScreenOpeningData(class_3222 serverPlayerEntity, class_2540 packetByteBuf) {
    }

    public void method_5431() {
        this.traverse(this.field_11867, cable -> {
            cable.connectedBlocks = null;
        });
    }

    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10566("Energy", (class_2520)this.wrappedEnergyStorage.writeNbt());
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        if (nbt.method_10573("Energy", 9)) {
            this.wrappedEnergyStorage.readNbt(nbt.method_10554("Energy", 10));
        }
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public SimpleEnergyStorage getEnergy() {
        return this.wrappedEnergyStorage.getStorage(null);
    }

    public SimpleEnergyStorage getEnergyProvider(class_2350 direction) {
        return this.wrappedEnergyStorage.getStorage(direction);
    }
}

