/*
 * Decompiled with CFR 0.152.
 */
package net.infugogr.barracuda.block.entity;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.infugogr.barracuda.Barracuda;
import net.infugogr.barracuda.block.entity.ModBlockEntityType;
import net.infugogr.barracuda.screenhandler.SMESScreenHandler;
import net.infugogr.barracuda.util.SyncableStorage;
import net.infugogr.barracuda.util.SyncableTickableBlockEntity;
import net.infugogr.barracuda.util.UpdatableBlockEntity;
import net.infugogr.barracuda.util.energy.EnergySpreader;
import net.infugogr.barracuda.util.energy.SyncingEnergyStorage;
import net.infugogr.barracuda.util.energy.WrappedEnergyStorage;
import net.infugogr.barracuda.util.inventory.SyncingSimpleInventory;
import net.infugogr.barracuda.util.inventory.WrappedInventoryStorage;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.base.SimpleEnergyStorage;

public class SMESblockEntity
extends UpdatableBlockEntity
implements SyncableTickableBlockEntity,
EnergySpreader,
ExtendedScreenHandlerFactory {
    public static final class_2561 TITLE = Barracuda.containerTitle("battery");
    public static final class_2561 CHARGE_MODE_BUTTON_TOOLTIP_TEXT = class_2561.method_43471((String)"gui.barracuda.battery.charge_mode_button.tooltip");
    private final WrappedInventoryStorage<class_1277> wrappedInventoryStorage = new WrappedInventoryStorage();
    private final WrappedEnergyStorage wrappedEnergyStorage = new WrappedEnergyStorage();
    protected final class_3913 propertyDelegate;
    private ChargeMode chargeMode = ChargeMode.DISCHARGE;

    public SMESblockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntityType.SMES, pos, state);
        this.wrappedInventoryStorage.addInventory(new SyncingSimpleInventory((UpdatableBlockEntity)this, 1));
        this.wrappedEnergyStorage.addStorage(new SyncingEnergyStorage(this, 5000000L, 100L, 100L));
        this.propertyDelegate = new class_3913(){

            public int method_17390(int index) {
                return switch (index) {
                    case 0 -> (int)SMESblockEntity.this.wrappedEnergyStorage.getStorage(null).getAmount();
                    case 1 -> (int)SMESblockEntity.this.wrappedEnergyStorage.getStorage(null).getCapacity();
                    default -> 0;
                };
            }

            public void method_17391(int index, int value) {
            }

            public int method_17389() {
                return 2;
            }
        };
    }

    @Override
    public List<SyncableStorage> getSyncableStorages() {
        SyncingSimpleInventory input = (SyncingSimpleInventory)this.wrappedInventoryStorage.getInventory(0);
        SyncingEnergyStorage energy = (SyncingEnergyStorage)this.wrappedEnergyStorage.getStorage(null);
        assert (input != null);
        return List.of(input, energy);
    }

    @Override
    public void onTick() {
        EnergyStorage itemEnergyStorage;
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        SimpleEnergyStorage energyStorage = this.wrappedEnergyStorage.getStorage(null);
        if (energyStorage == null) {
            return;
        }
        class_1799 stack = this.getInventory().method_5438(0);
        if (!stack.method_7960() && (itemEnergyStorage = (EnergyStorage)ContainerItemContext.withConstant((class_1799)stack).find(EnergyStorage.ITEM)) != null) {
            try (Transaction transaction = Transaction.openOuter();){
                if (this.chargeMode == ChargeMode.CHARGE && itemEnergyStorage.supportsInsertion() && itemEnergyStorage.getAmount() < itemEnergyStorage.getCapacity()) {
                    long attemptToInsert = Math.min(Math.min(energyStorage.getAmount(), itemEnergyStorage.getCapacity() - itemEnergyStorage.getAmount()), energyStorage.maxExtract);
                    if (attemptToInsert <= 0L) {
                        return;
                    }
                    long inserted = itemEnergyStorage.insert(attemptToInsert, (TransactionContext)transaction);
                    if (inserted <= 0L) {
                        return;
                    }
                    energyStorage.amount -= inserted;
                    transaction.commit();
                    this.update();
                } else if (this.chargeMode == ChargeMode.DISCHARGE && itemEnergyStorage.supportsExtraction() && energyStorage.getAmount() < energyStorage.getCapacity()) {
                    long attemptToExtract = Math.min(Math.min(itemEnergyStorage.getAmount(), energyStorage.getCapacity() - energyStorage.getAmount()), energyStorage.maxInsert);
                    if (attemptToExtract <= 0L) {
                        return;
                    }
                    long extracted = itemEnergyStorage.extract(attemptToExtract, (TransactionContext)transaction);
                    if (extracted <= 0L) {
                        return;
                    }
                    energyStorage.amount += extracted;
                    transaction.commit();
                    this.update();
                }
            }
        }
        this.spread(this.field_11863, this.field_11867, energyStorage);
    }

    @Override
    public void writeScreenOpeningData(class_3222 serverPlayerEntity, class_2540 packetByteBuf) {
        packetByteBuf.method_10807(this.field_11867);
    }

    public class_2561 method_5476() {
        return TITLE;
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new SMESScreenHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.chargeMode = ChargeMode.valueOf(nbt.method_10558("ChargeMode"));
        this.wrappedInventoryStorage.readNbt(nbt.method_10554("Inventory", 10));
        this.wrappedEnergyStorage.readNbt(nbt.method_10554("Energy", 10));
    }

    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10582("ChargeMode", this.chargeMode.name());
        nbt.method_10566("Inventory", (class_2520)this.wrappedInventoryStorage.writeNbt());
        nbt.method_10566("Energy", (class_2520)this.wrappedEnergyStorage.writeNbt());
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public class_1799 getRenderStack() {
        return Objects.requireNonNull(this.getWrappedInventory().getInventory(0)).method_5438(0);
    }

    public SimpleEnergyStorage getEnergyProvider(class_2350 direction) {
        return this.wrappedEnergyStorage.getStorage(direction);
    }

    public InventoryStorage getInventoryProvider(class_2350 direction) {
        return this.wrappedInventoryStorage.getStorage(direction);
    }

    public WrappedInventoryStorage<class_1277> getWrappedInventory() {
        return this.wrappedInventoryStorage;
    }

    public SimpleEnergyStorage getEnergy() {
        return this.wrappedEnergyStorage.getStorage(null);
    }

    public class_1277 getInventory() {
        return this.wrappedInventoryStorage.getInventory(0);
    }

    public boolean isValid(class_1799 stack, int slot) {
        EnergyStorage itemEnergyStorage = (EnergyStorage)ContainerItemContext.withConstant((class_1799)stack).find(EnergyStorage.ITEM);
        return itemEnergyStorage != null;
    }

    public ChargeMode getChargeMode() {
        return this.chargeMode;
    }

    public void setChargeMode(ChargeMode mode) {
        this.chargeMode = mode;
        System.out.println("Charge mode set to: " + mode);
        this.update();
    }

    public static enum ChargeMode {
        DISCHARGE,
        CHARGE;

        public static final Codec<ChargeMode> CODEC;

        public ChargeMode next() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case DISCHARGE -> CHARGE;
                case CHARGE -> DISCHARGE;
            };
        }

        static {
            CODEC = Codec.STRING.xmap(ChargeMode::valueOf, Enum::name);
        }
    }
}

