/*
 * Decompiled with CFR 0.152.
 */
package net.infugogr.barracuda.util.energy;

import java.util.ArrayList;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.infugogr.barracuda.util.UpdatableBlockEntity;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.base.SimpleEnergyStorage;

public interface EnergySpreader {
    public static long simulateInsertion(EnergyStorage storage, long amount, Transaction outer) {
        try (Transaction inner = outer.openNested();){
            long max = storage.insert(amount, (TransactionContext)inner);
            inner.abort();
            long l = max;
            return l;
        }
    }

    default public void spread(class_1937 world, class_2338 pos, SimpleEnergyStorage energyStorage) {
        ArrayList<EnergyStorage> storages = new ArrayList<EnergyStorage>();
        for (class_2350 direction : class_2350.values()) {
            EnergyStorage storage = (EnergyStorage)EnergyStorage.SIDED.find(world, pos.method_10093(direction), (Object)direction.method_10153());
            if (storage == null || !storage.supportsInsertion() || storage.getAmount() >= storage.getCapacity()) continue;
            storages.add(storage);
        }
        if (storages.isEmpty()) {
            return;
        }
        try (Transaction transaction = Transaction.openOuter();){
            long currentEnergy = energyStorage.getAmount();
            long totalExtractable = energyStorage.extract(Long.MAX_VALUE, (TransactionContext)transaction);
            long totalInserted = 0L;
            for (EnergyStorage storage : storages) {
                long insertable = EnergySpreader.simulateInsertion(storage, totalExtractable, transaction);
                long inserted = storage.insert(insertable, (TransactionContext)transaction);
                totalInserted += inserted;
            }
            if (totalInserted < totalExtractable) {
                energyStorage.amount += totalExtractable - totalInserted;
            }
            transaction.commit();
            if (currentEnergy != energyStorage.getAmount()) {
                EnergySpreader energySpreader = this;
                if (energySpreader instanceof UpdatableBlockEntity) {
                    UpdatableBlockEntity updatableBlockEntity = (UpdatableBlockEntity)((Object)energySpreader);
                    updatableBlockEntity.update();
                } else {
                    energySpreader = this;
                    if (energySpreader instanceof class_2586) {
                        class_2586 blockEntity = (class_2586)energySpreader;
                        blockEntity.method_5431();
                    }
                }
            }
        }
    }
}

