/*
 * Decompiled with CFR 0.152.
 */
package net.infugogr.barracuda.util.fluid;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.base.SingleFluidStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.infugogr.barracuda.util.WrappedStorage;
import net.infugogr.barracuda.util.fluid.FluidStack;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class WrappedFluidStorage<T extends Storage<FluidVariant>>
extends WrappedStorage<T> {
    private final CombinedStorage<FluidVariant, T> combinedStorage;

    public WrappedFluidStorage() {
        this.combinedStorage = new CombinedStorage(this.storages);
    }

    public CombinedStorage<FluidVariant, T> getCombinedStorage() {
        return this.combinedStorage;
    }

    public List<FluidStack> getFluids() {
        ArrayList<FluidStack> fluids = new ArrayList<FluidStack>();
        for (Storage tank : this.storages) {
            for (StorageView view : tank.nonEmptyViews()) {
                fluids.add(new FluidStack((FluidVariant)view.getResource(), view.getAmount()));
            }
        }
        return fluids;
    }

    @Override
    public class_2499 writeNbt() {
        class_2499 list = new class_2499();
        for (Storage tank : this.storages) {
            for (StorageView view : tank.nonEmptyViews()) {
                class_2487 nbt = new class_2487();
                nbt.method_10544("Amount", view.getAmount());
                nbt.method_10566("Fluid", (class_2520)view.getResource());
                list.add((Object)nbt);
            }
        }
        return list;
    }

    @Override
    public void readNbt(class_2499 nbt) {
        for (int index = 0; index < nbt.size(); ++index) {
            class_2487 compound = nbt.method_10602(index);
            Storage storage = (Storage)this.storages.get(index);
            if (storage == null) continue;
            if (storage instanceof SingleFluidStorage) {
                SingleFluidStorage singleFluidStorage = (SingleFluidStorage)storage;
                singleFluidStorage.amount = compound.method_10537("Amount");
                singleFluidStorage.variant = (FluidVariant)compound.method_10562("Fluid");
                continue;
            }
            throw new UnsupportedOperationException("Cannot read fluid storage of type: " + storage.getClass().getName());
        }
    }
}

