/*
 * Decompiled with CFR 0.152.
 */
package net.infugogr.barracuda.util.inventory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.infugogr.barracuda.util.NBTSerializable;
import net.infugogr.barracuda.util.inventory.RecipeSimpleInventory;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrappedInventoryStorage<T extends class_1277>
implements NBTSerializable<class_2499> {
    private final List<T> inventories = new ArrayList<T>();
    private final List<InventoryStorage> storages = new ArrayList<InventoryStorage>();
    private final Map<class_2350, InventoryStorage> sidedStorageMap = new HashMap<class_2350, InventoryStorage>();
    private final CombinedStorage<ItemVariant, InventoryStorage> combinedStorage = new CombinedStorage(this.storages);

    public void addInventory(@NotNull T inventory) {
        this.addInventory(inventory, null);
    }

    public void addInventory(@NotNull T inventory, class_2350 side) {
        this.inventories.add(inventory);
        InventoryStorage storage = InventoryStorage.of(inventory, (class_2350)side);
        this.storages.add(storage);
        this.sidedStorageMap.put(side, storage);
    }

    public List<T> getInventories() {
        return this.inventories;
    }

    public List<InventoryStorage> getStorages() {
        return this.storages;
    }

    public Map<class_2350, InventoryStorage> getSidedStorageMap() {
        return this.sidedStorageMap;
    }

    public CombinedStorage<ItemVariant, InventoryStorage> getCombinedStorage() {
        return this.combinedStorage;
    }

    @Nullable
    public InventoryStorage getStorage(class_2350 side) {
        return this.sidedStorageMap.get(side);
    }

    @Nullable
    public T getInventory(int index) {
        return (T)((class_1277)this.inventories.get(index));
    }

    @NotNull
    public List<class_1799> getStacks() {
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        for (class_1277 inventory : this.inventories) {
            for (int i = 0; i < inventory.method_5439(); ++i) {
                stacks.add(inventory.method_5438(i));
            }
        }
        return stacks;
    }

    public void checkSize(int size) {
        if (this.inventories.stream().map(class_1263::method_5439).reduce(0, Integer::sum) != size) {
            throw new IllegalArgumentException("Size of inventories does not match the size provided: " + size);
        }
    }

    public void onOpen(@NotNull class_1657 player) {
        for (class_1277 inventory : this.inventories) {
            inventory.method_5435(player);
        }
    }

    public void onClose(@NotNull class_1657 player) {
        for (class_1277 inventory : this.inventories) {
            inventory.method_5432(player);
        }
    }

    public void dropContents(@NotNull class_1937 world, @NotNull class_2338 pos) {
        for (class_1277 inventory : this.inventories) {
            class_1264.method_5451((class_1937)world, (class_2338)pos, (class_1263)inventory);
        }
    }

    public RecipeSimpleInventory getRecipeInventory() {
        return new RecipeSimpleInventory(this.getStacks().toArray(new class_1799[0]));
    }

    @Override
    public class_2499 writeNbt() {
        class_2499 nbt = new class_2499();
        for (class_1277 inventory : this.inventories) {
            class_2487 inventoryNbt = new class_2487();
            nbt.add((Object)class_1262.method_5426((class_2487)inventoryNbt, (class_2371)inventory.method_54454()));
        }
        return nbt;
    }

    @Override
    public void readNbt(class_2499 nbt) {
        for (int index = 0; index < nbt.size(); ++index) {
            class_2487 inventoryNbt = nbt.method_10602(index);
            class_1277 inventory = (class_1277)this.inventories.get(index);
            class_1262.method_5429((class_2487)inventoryNbt, (class_2371)inventory.method_54454());
        }
    }
}

