/*
 * Decompiled with CFR 0.152.
 */
package net.infugogr.barracuda.world;

import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2423;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_4970;
import net.minecraft.class_5454;
import net.minecraft.class_5459;
import org.jetbrains.annotations.Nullable;

public class Portal {
    private static final class_4970.class_4973 IS_VALID_FRAME_BLOCK = (state, world, pos) -> state.method_27852(class_2246.field_10540);
    private static final float FALLBACK_THRESHOLD = 4.0f;
    private static final double HEIGHT_STRETCH = 1.0;
    private final class_1936 world;
    private final class_2350.class_2351 axis;
    private final class_2350 negativeDir;
    private int foundPortalBlocks;
    @Nullable
    private class_2338 lowerCorner;

    public static Optional<Portal> getNewPortal(class_1936 world, class_2338 pos, class_2350.class_2351 axis) {
        return Portal.getOrEmpty(world, pos, areaHelper -> areaHelper.isValid() && areaHelper.foundPortalBlocks == 0, axis);
    }

    public static Optional<Portal> getOrEmpty(class_1936 world, class_2338 pos, Predicate<Portal> validator, class_2350.class_2351 axis) {
        Optional<Portal> optional = Optional.of(new Portal(world, pos, axis)).filter(validator);
        if (optional.isPresent()) {
            return optional;
        }
        class_2350.class_2351 axis2 = axis == class_2350.class_2351.field_11048 ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048;
        return Optional.of(new Portal(world, pos, axis2)).filter(validator);
    }

    public Portal(class_1936 world, class_2338 pos, class_2350.class_2351 axis) {
        this.world = world;
        this.axis = axis;
        this.negativeDir = axis == class_2350.class_2351.field_11048 ? class_2350.field_11039 : class_2350.field_11035;
    }

    private static boolean validStateInsidePortal(class_2680 state) {
        return state.method_26215() || state.method_26164(class_3481.field_21952) || state.method_27852(class_2246.field_10316);
    }

    public boolean isValid() {
        return this.lowerCorner != null;
    }

    public void createPortal() {
        class_2680 blockState = (class_2680)class_2246.field_10316.method_9564().method_11657((class_2769)class_2423.field_11310, (Comparable)this.axis);
        assert (this.lowerCorner != null);
        class_2338.method_10097((class_2338)this.lowerCorner, (class_2338)this.lowerCorner.method_10093(class_2350.field_11036).method_10093(this.negativeDir)).forEach(pos -> this.world.method_8652(pos, blockState, 18));
    }

    public boolean wasAlreadyValid() {
        return this.isValid();
    }

    public static class_243 entityPosInPortal(class_5459.class_5460 portalRect, class_2350.class_2351 portalAxis, class_243 entityPos, class_4048 entityDimensions) {
        class_2350.class_2351 axis;
        double g;
        double f;
        double d = (double)portalRect.field_25937 - (double)entityDimensions.field_18067;
        double e = (double)portalRect.field_25938 - (double)entityDimensions.field_18068;
        class_2338 blockPos = portalRect.field_25936;
        if (d > 0.0) {
            f = (double)blockPos.method_30558(portalAxis) + (double)entityDimensions.field_18067 / 2.0;
            g = class_3532.method_15350((double)class_3532.method_15370((double)(entityPos.method_18043(portalAxis) - f), (double)0.0, (double)d), (double)0.0, (double)1.0);
        } else {
            g = 0.5;
        }
        if (e > 0.0) {
            axis = class_2350.class_2351.field_11052;
            f = class_3532.method_15350((double)class_3532.method_15370((double)(entityPos.method_18043(axis) - (double)blockPos.method_30558(axis)), (double)0.0, (double)e), (double)0.0, (double)1.0);
        } else {
            f = 0.0;
        }
        axis = portalAxis == class_2350.class_2351.field_11048 ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048;
        double h = entityPos.method_18043(axis) - ((double)blockPos.method_30558(axis) + 0.5);
        return new class_243(g, f, h);
    }

    public static class_5454 getTeleportTarget(class_3218 destination, class_5459.class_5460 portalRect, class_2350.class_2351 portalAxis, class_243 offset, class_1297 entity, class_243 velocity, float yaw, float pitch) {
        class_2338 blockPos = portalRect.field_25936;
        class_2680 blockState = destination.method_8320(blockPos);
        class_2350.class_2351 axis = blockState.method_28500((class_2769)class_2741.field_12529).orElse(class_2350.class_2351.field_11048);
        double d = portalRect.field_25937;
        double e = portalRect.field_25938;
        class_4048 entityDimensions = entity.method_18377(entity.method_18376());
        int i = portalAxis == axis ? 0 : 90;
        class_243 vec3d = portalAxis == axis ? velocity : new class_243(velocity.field_1350, velocity.field_1351, -velocity.field_1352);
        double f = (double)entityDimensions.field_18067 / 2.0 + (d - (double)entityDimensions.field_18067) * offset.method_10216();
        double g = (e - (double)entityDimensions.field_18068) * offset.method_10214();
        double h = 0.5 + offset.method_10215();
        boolean bl = axis == class_2350.class_2351.field_11048;
        class_243 vec3d2 = new class_243((double)blockPos.method_10263() + (bl ? f : h), (double)blockPos.method_10264() + g, (double)blockPos.method_10260() + (bl ? h : f));
        class_243 vec3d3 = Portal.findOpenPosition(vec3d2, destination, entity, entityDimensions);
        return new class_5454(vec3d3, vec3d, yaw + (float)i, pitch);
    }

    private static class_243 findOpenPosition(class_243 fallback, class_3218 world, class_1297 entity, class_4048 dimensions) {
        if (!(dimensions.field_18067 > 4.0f) && !(dimensions.field_18068 > 4.0f)) {
            double d = (double)dimensions.field_18068 / 2.0;
            class_243 vec3d = fallback.method_1031(0.0, d, 0.0);
            class_265 voxelShape = class_259.method_1078((class_238)class_238.method_30048((class_243)vec3d, (double)dimensions.field_18067, (double)0.0, (double)dimensions.field_18067).method_1012(0.0, 1.0, 0.0).method_1014(1.0E-6));
            Optional optional = world.method_33594(entity, voxelShape, vec3d, (double)dimensions.field_18067, (double)dimensions.field_18068, (double)dimensions.field_18067);
            Optional<class_243> optional2 = optional.map(pos -> pos.method_1023(0.0, d, 0.0));
            return optional2.orElse(fallback);
        }
        return fallback;
    }
}

