/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.datagen;

import com.legobmw99.allomancy.Allomancy;
import com.legobmw99.allomancy.modules.extras.ExtrasSetup;
import com.legobmw99.allomancy.modules.world.WorldSetup;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.registries.DeferredHolder;

class BlockLootTables
extends BlockLootSubProvider {
    BlockLootTables(HolderLookup.Provider provider) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), provider);
    }

    protected void generate() {
        for (int i = 0; i < WorldSetup.ORE_METALS.length; ++i) {
            Allomancy.LOGGER.debug("Creating loot tables for ore: {}", (Object)WorldSetup.ORE_METALS[i].name());
            Block block2 = (Block)WorldSetup.ORE_BLOCKS.get(i).get();
            Block ds = (Block)WorldSetup.DEEPSLATE_ORE_BLOCKS.get(i).get();
            Item raw = (Item)WorldSetup.RAW_ORE_ITEMS.get(i).get();
            Block rawb = (Block)WorldSetup.RAW_ORE_BLOCKS.get(i).get();
            this.add(block2, block -> this.createOreDrop((Block)block, raw));
            this.add(ds, block -> this.createOreDrop((Block)block, raw));
            this.dropSelf(rawb);
        }
        this.dropSelf((Block)ExtrasSetup.IRON_BUTTON.get());
        this.dropSelf((Block)ExtrasSetup.INVERTED_IRON_BUTTON.get());
        this.dropSelf((Block)ExtrasSetup.IRON_LEVER.get());
        for (Supplier supplier : WorldSetup.STORAGE_BLOCKS) {
            if (supplier == null) continue;
            this.dropSelf((Block)supplier.get());
        }
    }

    protected Iterable<Block> getKnownBlocks() {
        return Stream.concat(WorldSetup.BLOCKS.getEntries().stream().map(DeferredHolder::get), ExtrasSetup.BLOCKS.getEntries().stream().map(DeferredHolder::get))::iterator;
    }
}

