/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.combat.entity;

import com.legobmw99.allomancy.modules.combat.CombatSetup;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class ProjectileNuggetEntity
extends ThrowableItemProjectile
implements ItemSupplier {
    private static final EntityDataAccessor<ItemStack> ITEM = SynchedEntityData.defineId(ProjectileNuggetEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private final float damage;
    private boolean dropItem = true;

    public ProjectileNuggetEntity(LivingEntity livingEntityIn, Level worldIn, ItemStack itemIn, float damageIn) {
        super(CombatSetup.NUGGET_PROJECTILE.get(), livingEntityIn, worldIn, itemIn);
        if (livingEntityIn instanceof Player) {
            Player player = (Player)livingEntityIn;
            if (player.getAbilities().instabuild) {
                this.dropItem = false;
            }
        }
        if (!itemIn.isEmpty()) {
            this.entityData.set(ITEM, (Object)itemIn.copy());
        }
        this.damage = damageIn;
    }

    public ProjectileNuggetEntity(EntityType<ProjectileNuggetEntity> entityEntityType, Level world) {
        super(entityEntityType, world);
        this.damage = 0.0f;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ITEM, (Object)ItemStack.EMPTY);
    }

    protected void onHitEntity(EntityHitResult result) {
        if (result.getEntity() == this.getOwner()) {
            return;
        }
        result.getEntity().hurtOrSimulate(this.makeDamage(), this.damage);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            this.kill(level2);
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            ItemStack ammo = new ItemStack((ItemLike)((ItemStack)this.entityData.get(ITEM)).getItem(), 1);
            if (level2.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS) && this.dropItem) {
                level2.addFreshEntity((Entity)new ItemEntity(this.level(), this.position().x(), this.position().y(), this.position().z(), ammo));
            }
            this.kill(level2);
        }
    }

    private DamageSource makeDamage() {
        return new DamageSource((Holder)this.level().registryAccess().lookupOrThrow(Registries.DAMAGE_TYPE).getOrThrow(CombatSetup.COIN_DAMAGE), (Entity)this, this.getOwner());
    }

    public ItemStack getItem() {
        return ((ItemStack)this.entityData.get(ITEM)).isEmpty() ? new ItemStack((ItemLike)this.getDefaultItem()) : (ItemStack)this.entityData.get(ITEM);
    }

    protected Item getDefaultItem() {
        return Items.GOLD_NUGGET;
    }
}

