/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.combat.item;

import com.legobmw99.allomancy.api.enums.Metal;
import com.legobmw99.allomancy.modules.combat.entity.ProjectileNuggetEntity;
import com.legobmw99.allomancy.modules.powers.data.AllomancerAttachment;
import com.legobmw99.allomancy.modules.powers.data.AllomancerData;
import com.legobmw99.allomancy.modules.powers.util.Physical;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoinBagItem
extends ProjectileWeaponItem {
    private static final Predicate<ItemStack> NUGGETS = stack -> {
        Item item = stack.getItem();
        return Physical.doesResourceContainMetal(BuiltInRegistries.ITEM.getKey((Object)item)) && BuiltInRegistries.ITEM.getKey((Object)item).getPath().contains("nugget");
    };

    public CoinBagItem(Item.Properties props) {
        super(props.stacksTo(1).component(DataComponents.ENCHANTABLE, null));
    }

    private static Ammo getAmmoFromItem(Item itemIn) {
        return switch (BuiltInRegistries.ITEM.getKey((Object)itemIn).getPath()) {
            case "iron_nugget", "steel_nugget", "bronze_nugget", "copper_nugget", "nickel_nugget" -> Ammo.HEAVY;
            case "bendalloy_nugget", "nicrosil_nugget", "electrum_nugget", "platinum_nugget" -> Ammo.MAGIC;
            default -> Ammo.LIGHT;
        };
    }

    @NotNull
    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return NUGGETS;
    }

    public InteractionResult use(Level world, Player player, InteractionHand hand) {
        ItemStack weapon = player.getItemInHand(hand);
        ItemStack ammo = player.getProjectile(weapon);
        if (ammo.getItem() instanceof ArrowItem) {
            ammo = new ItemStack((ItemLike)Items.GOLD_NUGGET, 1);
        }
        AllomancerData data = AllomancerAttachment.get(player);
        if (!ammo.isEmpty() && data.isBurning(Metal.STEEL) && world instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)world;
            Ammo type = CoinBagItem.getAmmoFromItem(ammo.getItem());
            this.shoot(level, (LivingEntity)player, hand, weapon, List.of(ammo), type.velocity, type.inaccuracy, data.isEnhanced(), null);
            if (!player.getAbilities().instabuild) {
                ammo.shrink(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    protected Projectile createProjectile(Level pLevel, LivingEntity pShooter, ItemStack pWeapon, ItemStack pAmmo, boolean pIsCrit) {
        float dmg = CoinBagItem.getAmmoFromItem((Item)pAmmo.getItem()).damage;
        if (pIsCrit) {
            dmg *= 2.0f;
        }
        return new ProjectileNuggetEntity(pShooter, pLevel, pAmmo, dmg);
    }

    public int getDefaultProjectileRange() {
        return 20;
    }

    protected void shootProjectile(LivingEntity pShooter, Projectile pProjectile, int pIndex, float pVelocity, float pInaccuracy, float pAngle, @Nullable LivingEntity pTarget) {
        pProjectile.shootFromRotation((Entity)pShooter, pShooter.getXRot(), pShooter.getYHeadRot(), 2.0f, pVelocity, pInaccuracy);
    }

    private static enum Ammo {
        HEAVY(5.0f, 2.25f, 2.5f),
        MAGIC(5.5f, 4.0f, 1.0f),
        LIGHT(4.0f, 4.0f, 1.0f);

        final float damage;
        final float velocity;
        final float inaccuracy;

        private Ammo(float damage, float velocity, float inaccuracy) {
            this.damage = damage;
            this.velocity = velocity;
            this.inaccuracy = inaccuracy;
        }
    }
}

