/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.consumables;

import com.legobmw99.allomancy.api.enums.Metal;
import com.legobmw99.allomancy.modules.consumables.item.GrinderItem;
import com.legobmw99.allomancy.modules.consumables.item.LerasiumItem;
import com.legobmw99.allomancy.modules.consumables.item.VialItem;
import com.legobmw99.allomancy.modules.consumables.item.component.FlakeStorage;
import com.legobmw99.allomancy.modules.consumables.item.consume_effects.GrantAllomancyConsumeEffect;
import com.legobmw99.allomancy.modules.consumables.item.consume_effects.SummonLightningConsumeEffect;
import com.legobmw99.allomancy.modules.consumables.item.recipe.VialItemRecipe;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.consume_effects.ConsumeEffect;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.event.ModifyDefaultComponentsEvent;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class ConsumeSetup {
    private static final DeferredRegister.DataComponents DATA_COMPONENTS = DeferredRegister.createDataComponents((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"allomancy");
    public static final Supplier<DataComponentType<FlakeStorage>> FLAKE_STORAGE = DATA_COMPONENTS.registerComponentType("flake_storage", builder -> builder.persistent(FlakeStorage.CODEC).networkSynchronized(FlakeStorage.STREAM_CODEC));
    private static final DeferredRegister<ConsumeEffect.Type<?>> CONSUME_EFFECTS = DeferredRegister.create((ResourceKey)Registries.CONSUME_EFFECT_TYPE, (String)"allomancy");
    public static final Supplier<ConsumeEffect.Type<GrantAllomancyConsumeEffect>> GRANT_ALLOMANCY_ON_CONSUME = CONSUME_EFFECTS.register("grant_allomancy_on_consume", () -> new ConsumeEffect.Type(GrantAllomancyConsumeEffect.CODEC, GrantAllomancyConsumeEffect.STREAM_CODEC));
    public static final Supplier<ConsumeEffect.Type<SummonLightningConsumeEffect>> SUMMON_LIGHTNING_ON_CONSUME = CONSUME_EFFECTS.register("summon_lightning_on_consume", () -> new ConsumeEffect.Type(SummonLightningConsumeEffect.CODEC, SummonLightningConsumeEffect.STREAM_CODEC));
    private static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"allomancy");
    public static final DeferredItem<GrinderItem> ALLOMANTIC_GRINDER = ITEMS.registerItem("allomantic_grinder", GrinderItem::new);
    public static final DeferredItem<LerasiumItem> LERASIUM_NUGGET = ITEMS.registerItem("lerasium_nugget", LerasiumItem::new);
    public static final DeferredItem<VialItem> VIAL = ITEMS.registerItem("vial", VialItem::new);
    private static final DeferredRegister<RecipeSerializer<?>> RECIPES = DeferredRegister.create((ResourceKey)Registries.RECIPE_SERIALIZER, (String)"allomancy");
    public static final Supplier<RecipeSerializer<VialItemRecipe>> VIAL_RECIPE_SERIALIZER = RECIPES.register("vial_filling", () -> new CustomRecipe.Serializer(VialItemRecipe::new));

    private ConsumeSetup() {
    }

    public static void register(IEventBus bus) {
        DATA_COMPONENTS.register(bus);
        ITEMS.register(bus);
        RECIPES.register(bus);
        CONSUME_EFFECTS.register(bus);
        bus.addListener(ConsumeSetup::onModifyComponents);
    }

    private static void onModifyComponents(ModifyDefaultComponentsEvent event) {
        FlakeStorage gold = new FlakeStorage.Mutable().add(Metal.GOLD).toImmutable();
        event.modify((ItemLike)Items.GOLDEN_APPLE, builder -> builder.set(FLAKE_STORAGE.get(), (Object)gold));
        event.modify((ItemLike)Items.GOLDEN_CARROT, builder -> builder.set(FLAKE_STORAGE.get(), (Object)gold));
        event.modify((ItemLike)Items.ENCHANTED_GOLDEN_APPLE, builder -> builder.set(FLAKE_STORAGE.get(), (Object)gold));
    }
}

