/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.consumables.item;

import com.legobmw99.allomancy.Allomancy;
import com.legobmw99.allomancy.api.enums.Metal;
import com.legobmw99.allomancy.modules.consumables.ConsumeSetup;
import com.legobmw99.allomancy.modules.consumables.item.component.FlakeStorage;
import com.legobmw99.allomancy.modules.powers.data.AllomancerAttachment;
import com.legobmw99.allomancy.modules.powers.data.AllomancerData;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.UseRemainder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class VialItem
extends Item {
    private static final FoodProperties vial_food = new FoodProperties.Builder().alwaysEdible().saturationModifier(0.0f).nutrition(0).build();
    private static final Consumable vial_consumable = Consumable.builder().consumeSeconds(0.3f).animation(ItemUseAnimation.DRINK).sound((Holder)SoundEvents.GENERIC_DRINK).hasConsumeParticles(false).build();

    public VialItem(Item.Properties props) {
        super(props.stacksTo(32).food(vial_food, vial_consumable).rarity(Rarity.COMMON));
    }

    public InteractionResult use(Level worldIn, Player playerIn, InteractionHand hand) {
        ItemStack itemStackIn = playerIn.getItemInHand(hand);
        AllomancerData data = AllomancerAttachment.get(playerIn);
        int filling = 0;
        int full = 0;
        FlakeStorage storage = (FlakeStorage)itemStackIn.get(ConsumeSetup.FLAKE_STORAGE);
        if (storage != null) {
            for (Metal mt : Metal.values()) {
                if (!storage.contains(mt)) continue;
                ++filling;
                if (data.getStored(mt) < 10) continue;
                ++full;
            }
            if (filling != full) {
                playerIn.startUsingItem(hand);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.FAIL;
    }

    public static void fillVial(ItemStack stack, FlakeStorage storage) {
        stack.set(ConsumeSetup.FLAKE_STORAGE, (Object)storage);
        if (storage == null) {
            stack.set(DataComponents.RARITY, (Object)Rarity.COMMON);
        } else {
            stack.set(DataComponents.USE_REMAINDER, (Object)new UseRemainder(new ItemStack((ItemLike)ConsumeSetup.VIAL.get())));
            stack.set(DataComponents.RARITY, (Object)Rarity.UNCOMMON);
        }
    }

    public void verifyComponentsAfterLoad(ItemStack pStack) {
        super.verifyComponentsAfterLoad(pStack);
        if (pStack.has(ConsumeSetup.FLAKE_STORAGE)) {
            if (!pStack.has(DataComponents.USE_REMAINDER)) {
                pStack.set(DataComponents.USE_REMAINDER, (Object)new UseRemainder(new ItemStack((ItemLike)ConsumeSetup.VIAL.get())));
            }
            return;
        }
        CustomData customData = (CustomData)pStack.get(DataComponents.CUSTOM_DATA);
        if (customData != null && customData.contains("steel")) {
            CompoundTag tag = customData.copyTag();
            Allomancy.LOGGER.info("Found old custom item data for vial: {}", (Object)tag);
            FlakeStorage.Mutable storage = new FlakeStorage.Mutable();
            for (Metal mt : Metal.values()) {
                if (tag.getBooleanOr(mt.getName(), false)) {
                    storage.add(mt);
                }
                tag.remove(mt.getName());
            }
            VialItem.fillVial(pStack, storage.toImmutable());
            pStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        }
    }
}

