/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.consumables.item.consume_effects;

import com.legobmw99.allomancy.api.enums.Metal;
import com.legobmw99.allomancy.modules.consumables.ConsumeSetup;
import com.legobmw99.allomancy.modules.powers.data.AllomancerAttachment;
import com.legobmw99.allomancy.modules.powers.data.AllomancerData;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.EnumSet;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.consume_effects.ConsumeEffect;
import net.minecraft.world.level.Level;

public final class GrantAllomancyConsumeEffect
implements ConsumeEffect {
    private final EnumSet<Metal> powers;
    public static final MapCodec<GrantAllomancyConsumeEffect> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.list(Metal.CODEC).fieldOf("powers").forGetter(eff -> eff.powers.stream().toList())).apply((Applicative)inst, powers -> {
        Mutable effect = new Mutable();
        for (Metal mt : powers) {
            effect.add(mt);
        }
        return effect.toImmutable();
    }));
    public static final StreamCodec<RegistryFriendlyByteBuf, GrantAllomancyConsumeEffect> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, GrantAllomancyConsumeEffect>(){

        public void encode(RegistryFriendlyByteBuf buffer, GrantAllomancyConsumeEffect value) {
            buffer.writeEnumSet(value.powers, Metal.class);
        }

        public GrantAllomancyConsumeEffect decode(RegistryFriendlyByteBuf buffer) {
            return new GrantAllomancyConsumeEffect(buffer.readEnumSet(Metal.class));
        }
    };

    private GrantAllomancyConsumeEffect(EnumSet<Metal> powers) {
        this.powers = powers;
    }

    public static GrantAllomancyConsumeEffect makeMistborn() {
        return new GrantAllomancyConsumeEffect(EnumSet.allOf(Metal.class));
    }

    public ConsumeEffect.Type<GrantAllomancyConsumeEffect> getType() {
        return ConsumeSetup.GRANT_ALLOMANCY_ON_CONSUME.get();
    }

    public boolean apply(Level level, ItemStack stack, LivingEntity entity) {
        Player player;
        boolean addedPower = false;
        if (entity instanceof Player) {
            player = (Player)entity;
            AllomancerData data = AllomancerAttachment.get(player);
            for (Metal mt : this.powers) {
                if (data.hasPower(mt)) continue;
                data.addPower(mt);
                addedPower = true;
            }
        }
        if (addedPower && entity instanceof ServerPlayer) {
            player = (ServerPlayer)entity;
            AllomancerAttachment.sync(player);
        }
        return addedPower;
    }

    public static class Mutable {
        private final EnumSet<Metal> flakes = EnumSet.noneOf(Metal.class);

        public Mutable add(Metal mt) {
            this.flakes.add(mt);
            return this;
        }

        public GrantAllomancyConsumeEffect toImmutable() {
            if (this.flakes.isEmpty()) {
                return null;
            }
            return new GrantAllomancyConsumeEffect(this.flakes);
        }
    }
}

