/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.extras.advancement;

import com.legobmw99.allomancy.api.enums.Metal;
import com.legobmw99.allomancy.modules.extras.ExtrasSetup;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;
import org.jetbrains.annotations.Nullable;

public class MetalUsedOnEntityTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, Entity entity, Metal mt, boolean enhanced) {
        ServerPlayer target;
        if (entity instanceof ServerPlayer && !player.equals((Object)(target = (ServerPlayer)entity))) {
            ExtrasSetup.METAL_USED_ON_PLAYER_TRIGGER.get().trigger(target, mt, enhanced);
        }
        LootContext lootcontext = EntityPredicate.createContext((ServerPlayer)player, (Entity)entity);
        this.trigger(player, p_48112_ -> p_48112_.matches(lootcontext, mt, enhanced));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<ContextAwarePredicate> entityPredicate, Metal mt, Optional<Boolean> enhanced) implements SimpleCriterionTrigger.SimpleInstance
    {
        private static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("entity").forGetter(TriggerInstance::entityPredicate), (App)Metal.CODEC.fieldOf("metal").forGetter(TriggerInstance::mt), (App)Codec.BOOL.optionalFieldOf("enhanced").forGetter(TriggerInstance::enhanced)).apply((Applicative)builder, TriggerInstance::new));

        public static Criterion<TriggerInstance> instance(@Nullable ContextAwarePredicate player, @Nullable ContextAwarePredicate entityPredicate, Metal mt) {
            return ExtrasSetup.METAL_USED_ON_ENTITY_TRIGGER.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.ofNullable(player), Optional.ofNullable(entityPredicate), mt, Optional.empty()));
        }

        public static Criterion<TriggerInstance> instance(@Nullable ContextAwarePredicate player, @Nullable ContextAwarePredicate entityPredicate, Metal mt, boolean enhanced) {
            return ExtrasSetup.METAL_USED_ON_ENTITY_TRIGGER.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.ofNullable(player), Optional.ofNullable(entityPredicate), mt, Optional.of(enhanced)));
        }

        boolean matches(LootContext entity, Metal mt, boolean enhanced) {
            return !(this.mt != mt || !this.entityPredicate.isEmpty() && !this.entityPredicate.get().matches(entity) || !this.enhanced().isEmpty() && this.enhanced().get() != enhanced);
        }
    }
}

