/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.extras.block;

import com.legobmw99.allomancy.api.block.IAllomanticallyUsable;
import com.legobmw99.allomancy.modules.extras.ExtrasSetup;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.capabilities.IBlockCapabilityProvider;

public class IronLeverBlock
extends LeverBlock {
    public IronLeverBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHitResult) {
        return InteractionResult.FAIL;
    }

    protected void onExplosionHit(BlockState pState, ServerLevel pLevel, BlockPos pPos, Explosion pExplosion, BiConsumer<ItemStack, BlockPos> pDropConsumer) {
    }

    public static class AllomanticUseCapabilityProvider
    implements IBlockCapabilityProvider<IAllomanticallyUsable, Void> {
        public IAllomanticallyUsable getCapability(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity, Void context) {
            return (player, isPush) -> {
                if (player instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)player;
                    ExtrasSetup.ALLOMANTICALLY_ACTIVATED_BLOCK_TRIGGER.get().trigger(sp, pos, isPush);
                }
                if (level.isClientSide()) {
                    return true;
                }
                if (isPush == (Boolean)state.getValue((Property)LeverBlock.POWERED)) {
                    ((LeverBlock)state.getBlock()).pull(state, level, pos, player);
                    float f = (Boolean)state.getValue((Property)LeverBlock.POWERED) != false ? 0.6f : 0.5f;
                    level.playSound(null, pos, SoundEvents.LEVER_CLICK, SoundSource.BLOCKS, 0.3f, f);
                    level.gameEvent((Entity)player, (Holder)((Boolean)state.getValue((Property)LeverBlock.POWERED) != false ? GameEvent.BLOCK_ACTIVATE : GameEvent.BLOCK_DEACTIVATE), pos);
                    return true;
                }
                return false;
            };
        }
    }
}

