/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.extras.command;

import com.legobmw99.allomancy.api.data.IAllomancerData;
import com.legobmw99.allomancy.api.enums.Metal;
import com.legobmw99.allomancy.modules.extras.command.AllomancyPowerType;
import com.legobmw99.allomancy.modules.powers.data.AllomancerAttachment;
import com.legobmw99.allomancy.modules.powers.data.AllomancerData;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.event.RegisterCommandsEvent;

public final class AllomancyPowerCommand {
    private static final DynamicCommandExceptionType ERROR_CANT_ADD = new DynamicCommandExceptionType(s -> Component.translatable((String)"commands.allomancy.err_add", (Object[])new Object[]{s}));
    private static final DynamicCommandExceptionType ERROR_CANT_REMOVE = new DynamicCommandExceptionType(s -> Component.translatable((String)"commands.allomancy.err_remove", (Object[])new Object[]{s}));

    private AllomancyPowerCommand() {
    }

    private static Predicate<CommandSourceStack> permissions(int level) {
        return player -> player.hasPermission(level);
    }

    private static Collection<ServerPlayer> sender(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return Collections.singleton(((CommandSourceStack)ctx.getSource()).getPlayerOrException());
    }

    private static Collection<ServerPlayer> target(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return EntityArgument.getPlayers(ctx, (String)"targets");
    }

    public static void register(RegisterCommandsEvent e) {
        CommandDispatcher dispatcher = e.getDispatcher();
        LiteralArgumentBuilder root = (LiteralArgumentBuilder)Commands.literal((String)"allomancy").requires(AllomancyPowerCommand.permissions(0));
        root.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"get").requires(AllomancyPowerCommand.permissions(0))).executes(ctx -> AllomancyPowerCommand.handleMultiPlayer((CommandContext<CommandSourceStack>)ctx, AllomancyPowerCommand.sender((CommandContext<CommandSourceStack>)ctx), AllomancyPowerCommand::getPowers))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(ctx -> AllomancyPowerCommand.handleMultiPlayer((CommandContext<CommandSourceStack>)ctx, AllomancyPowerCommand.target((CommandContext<CommandSourceStack>)ctx), AllomancyPowerCommand::getPowers))));
        root.then(((LiteralArgumentBuilder)Commands.literal((String)"add").requires(AllomancyPowerCommand.permissions(2))).then(((RequiredArgumentBuilder)Commands.argument((String)"type", (ArgumentType)AllomancyPowerType.INSTANCE).executes(ctx -> AllomancyPowerCommand.handleMultiPlayer((CommandContext<CommandSourceStack>)ctx, AllomancyPowerCommand.sender((CommandContext<CommandSourceStack>)ctx), AllomancyPowerCommand::addPower))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(ctx -> AllomancyPowerCommand.handleMultiPlayer((CommandContext<CommandSourceStack>)ctx, AllomancyPowerCommand.target((CommandContext<CommandSourceStack>)ctx), AllomancyPowerCommand::addPower)))));
        root.then(((LiteralArgumentBuilder)Commands.literal((String)"remove").requires(AllomancyPowerCommand.permissions(2))).then(((RequiredArgumentBuilder)Commands.argument((String)"type", (ArgumentType)AllomancyPowerType.INSTANCE).executes(ctx -> AllomancyPowerCommand.handleMultiPlayer((CommandContext<CommandSourceStack>)ctx, AllomancyPowerCommand.sender((CommandContext<CommandSourceStack>)ctx), AllomancyPowerCommand::removePower))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(ctx -> AllomancyPowerCommand.handleMultiPlayer((CommandContext<CommandSourceStack>)ctx, AllomancyPowerCommand.target((CommandContext<CommandSourceStack>)ctx), AllomancyPowerCommand::removePower)))));
        LiteralCommandNode command = dispatcher.register(root);
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ap").requires(AllomancyPowerCommand.permissions(0))).redirect((CommandNode)command));
    }

    private static int handleMultiPlayer(CommandContext<CommandSourceStack> ctx, Iterable<ServerPlayer> players, CheckedBiCon<CommandContext<CommandSourceStack>, ServerPlayer> toApply) throws CommandSyntaxException {
        int i = 0;
        for (ServerPlayer p : players) {
            toApply.accept(ctx, p);
            ++i;
        }
        return i;
    }

    private static void getPowers(CommandContext<CommandSourceStack> ctx, ServerPlayer player) {
        StringBuilder powers = new StringBuilder();
        AllomancerData data = AllomancerAttachment.get((Player)player);
        if (data.isMistborn()) {
            powers.append("all");
        } else if (data.isUninvested()) {
            powers.append("none");
        } else {
            for (Metal mt : Metal.values()) {
                if (!data.hasPower(mt)) continue;
                if (powers.isEmpty()) {
                    powers.append(mt.getName());
                    continue;
                }
                powers.append(", ").append(mt.getName());
            }
        }
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"commands.allomancy.getpowers", (Object[])new Object[]{player.getDisplayName(), powers.toString()}), true);
    }

    private static void addPower(CommandContext<CommandSourceStack> ctx, ServerPlayer player) throws CommandSyntaxException {
        AllomancyPowerCommand.handlePowerChange(ctx, player, IAllomancerData::setMistborn, data -> Predicate.not(data::hasPower), (mt, data) -> data.addPower((Metal)((Object)mt)), arg_0 -> ((DynamicCommandExceptionType)ERROR_CANT_ADD).create(arg_0), "commands.allomancy.addpower");
    }

    private static void removePower(CommandContext<CommandSourceStack> ctx, ServerPlayer player) throws CommandSyntaxException {
        AllomancyPowerCommand.handlePowerChange(ctx, player, IAllomancerData::setUninvested, data -> data::hasPower, (mt, data) -> {
            data.revokePower((Metal)((Object)mt));
            data.setBurning((Metal)((Object)mt), false);
        }, arg_0 -> ((DynamicCommandExceptionType)ERROR_CANT_REMOVE).create(arg_0), "commands.allomancy.removepower");
    }

    private static void handlePowerChange(CommandContext<CommandSourceStack> ctx, ServerPlayer player, Consumer<IAllomancerData> all, Function<IAllomancerData, Predicate<Metal>> filterFunction, BiConsumer<Metal, IAllomancerData> single, Function<String, CommandSyntaxException> exception, String success) throws CommandSyntaxException {
        String type = (String)ctx.getArgument("type", String.class);
        AllomancerData data = AllomancerAttachment.get((Player)player);
        if ("all".equalsIgnoreCase(type)) {
            all.accept(data);
        } else {
            Predicate<Metal> filter = filterFunction.apply(data);
            if ("random".equalsIgnoreCase(type)) {
                List<Metal> metalList = Arrays.asList(Metal.values());
                Collections.shuffle(metalList);
                Metal mt = metalList.stream().filter(filter).findFirst().orElseThrow(() -> (CommandSyntaxException)exception.apply(type));
                single.accept(mt, data);
            } else {
                Metal mt = Metal.valueOf(type.toUpperCase());
                if (filter.test(mt)) {
                    single.accept(mt, data);
                } else {
                    throw exception.apply(type);
                }
            }
        }
        AllomancerAttachment.sync((Player)player);
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)success, (Object[])new Object[]{player.getDisplayName(), type}), true);
    }

    @FunctionalInterface
    private static interface CheckedBiCon<T, U> {
        public void accept(T var1, U var2) throws CommandSyntaxException;
    }
}

