/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.powers;

import com.legobmw99.allomancy.Allomancy;
import com.legobmw99.allomancy.api.enums.Metal;
import com.legobmw99.allomancy.modules.extras.ExtrasSetup;
import com.legobmw99.allomancy.modules.powers.PowersConfig;
import com.legobmw99.allomancy.modules.powers.data.AllomancerAttachment;
import com.legobmw99.allomancy.modules.powers.data.AllomancerData;
import com.legobmw99.allomancy.modules.powers.network.EnhanceTimePayload;
import com.legobmw99.allomancy.modules.powers.network.Network;
import com.legobmw99.allomancy.modules.powers.util.Emotional;
import com.legobmw99.allomancy.modules.powers.util.Enhancement;
import com.legobmw99.allomancy.modules.powers.util.Physical;
import com.legobmw99.allomancy.modules.powers.util.Temporal;
import com.legobmw99.allomancy.modules.world.WorldSetup;
import com.legobmw99.allomancy.util.AllomancyTags;
import com.mojang.serialization.DynamicOps;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.event.entity.EntityInvulnerabilityCheckEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerRespawnPositionEvent;
import net.neoforged.neoforge.event.entity.player.PlayerSetSpawnEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

@EventBusSubscriber(modid="allomancy")
public final class CommonEventHandler {
    private static final Metal[] USEFUL_MISTINGS = new Metal[]{Metal.IRON, Metal.STEEL, Metal.TIN, Metal.PEWTER, Metal.ZINC, Metal.BRASS, Metal.BRONZE, Metal.COPPER, Metal.CHROMIUM, Metal.NICROSIL, Metal.GOLD, Metal.ELECTRUM, Metal.CADMIUM, Metal.BENDALLOY};
    private static final Metal[] USEFUL_MISTINGS_SSP = new Metal[]{Metal.IRON, Metal.STEEL, Metal.TIN, Metal.PEWTER, Metal.ZINC, Metal.BRASS, Metal.GOLD, Metal.ELECTRUM, Metal.CADMIUM, Metal.BENDALLOY};

    private CommonEventHandler() {
    }

    @SubscribeEvent
    public static void onPlayerLoad(PlayerEvent.LoadFromFile event) {
        Player player = event.getEntity();
        if (AllomancerAttachment.needsData(player)) {
            CompoundTag compoundtag = null;
            try {
                File file1 = new File(event.getPlayerDirectory(), event.getPlayerUUID() + ".dat");
                if (file1.exists() && file1.isFile()) {
                    compoundtag = NbtIo.readCompressed((Path)file1.toPath(), (NbtAccounter)NbtAccounter.unlimitedHeap());
                }
            }
            catch (Exception exception) {
                Allomancy.LOGGER.warn("Failed to load old player data for {}", (Object)player.getName().getString());
            }
            if (compoundtag != null) {
                compoundtag.getCompound("ForgeCaps").flatMap(caps -> caps.getCompound("allomancy:allomancy_data")).ifPresent(oldData -> {
                    Allomancy.LOGGER.info("Found old forge data for player {}, trying to load!", (Object)player.getName().getString());
                    try {
                        AllomancerData data = (AllomancerData)AllomancerData.CODEC.codec().parse((DynamicOps)NbtOps.INSTANCE, oldData).getOrThrow();
                        AllomancerAttachment.set(player, data);
                        Allomancy.LOGGER.info("Loaded old forge data for player {}!", (Object)player.getName().getString());
                    }
                    catch (Exception exception) {
                        Allomancy.LOGGER.error("Failed to deserialize old data!", (Throwable)exception);
                    }
                });
            }
        }
    }

    private static Metal getRandomMistingForPlayer(ServerPlayer player, Metal[] options) {
        if (((Boolean)PowersConfig.respect_player_UUID.get()).booleanValue()) {
            return options[Math.abs(player.getUUID().hashCode()) % options.length];
        }
        return options[player.getRandom().nextInt(options.length)];
    }

    @SubscribeEvent
    public static void onJoinWorld(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player;
        Player player2 = event.getEntity();
        if (player2 instanceof ServerPlayer && AllomancerAttachment.needsData((Player)(player = (ServerPlayer)player2))) {
            AllomancerData data = new AllomancerData();
            if (((Boolean)PowersConfig.random_mistings.get()).booleanValue() && data.isUninvested()) {
                Metal randomMisting = FMLEnvironment.dist.isClient() ? CommonEventHandler.getRandomMistingForPlayer(player, USEFUL_MISTINGS_SSP) : CommonEventHandler.getRandomMistingForPlayer(player, USEFUL_MISTINGS);
                data.addPower(randomMisting);
                AllomancerAttachment.set((Player)player, data);
                ItemStack flakes = new ItemStack((ItemLike)WorldSetup.FLAKES.get(randomMisting.getIndex()).get());
                if (!player.getInventory().add(flakes)) {
                    ItemEntity entity = new ItemEntity((Level)player.level(), player.position().x(), player.position().y(), player.position().z(), flakes);
                    player.level().addFreshEntity((Entity)entity);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (!event.isEndConquered()) {
                AllomancerData data = AllomancerAttachment.get((Player)player2);
                data.drainMetals(Metal.values());
            }
            AllomancerAttachment.sync((Player)player2);
        }
    }

    @SubscribeEvent
    public static void onRespawnPosition(PlayerRespawnPositionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            AllomancerData data = AllomancerAttachment.get((Player)player2);
            BlockPos pos = new BlockPos((int)event.getTeleportTransition().position().x(), (int)event.getTeleportTransition().position().y(), (int)event.getTeleportTransition().position().z());
            ResourceKey dimension = event.getTeleportTransition().newLevel().dimension();
            if (data.getSpawnLoc() == null || !data.getSpawnLoc().isCloseEnough(dimension, pos, 10)) {
                data.setSpawnLoc(pos, (ResourceKey<Level>)dimension);
                AllomancerAttachment.sync((Player)player2);
            }
        }
    }

    @SubscribeEvent
    public static void onSetSpawn(PlayerSetSpawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            AllomancerData data = AllomancerAttachment.get((Player)player2);
            data.setSpawnLoc(event.getNewSpawn(), (ResourceKey<Level>)event.getSpawnLevel());
            AllomancerAttachment.sync((Player)player2);
        }
    }

    @SubscribeEvent
    public static void onChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            AllomancerAttachment.sync((Player)player2);
        }
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingIncomingDamageEvent event) {
        ServerPlayer player;
        Object data;
        Entity entity = event.getSource().getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer source = (ServerPlayer)entity;
            data = AllomancerAttachment.get((Player)source);
            if (((AllomancerData)data).isBurning(Metal.PEWTER)) {
                if (((AllomancerData)data).isEnhanced()) {
                    if (source.getMainHandItem().is(AllomancyTags.ONE_HIT_WEAPONS)) {
                        event.setAmount(550.0f);
                        Enhancement.wipePlayer(source);
                    } else {
                        event.setAmount(event.getAmount() * 3.0f);
                    }
                } else {
                    event.setAmount(event.getAmount() + 2.0f);
                }
            }
            if (((AllomancerData)data).isBurning(Metal.CHROMIUM)) {
                ServerPlayer player2;
                ExtrasSetup.METAL_USED_ON_ENTITY_TRIGGER.get().trigger(source, (Entity)event.getEntity(), Metal.CHROMIUM, ((AllomancerData)data).isEnhanced());
                LivingEntity livingEntity = event.getEntity();
                if (livingEntity instanceof ServerPlayer && !Emotional.hasTinFoilHat((LivingEntity)(player2 = (ServerPlayer)livingEntity))) {
                    Enhancement.wipePlayer(player2);
                }
            }
        }
        if ((data = event.getEntity()) instanceof ServerPlayer && ((AllomancerData)(data = AllomancerAttachment.get((Player)(player = (ServerPlayer)data)))).isBurning(Metal.PEWTER)) {
            float newDamage = Math.max(0.0f, event.getAmount() - 2.0f);
            Allomancy.LOGGER.trace("Reducing damage to {} on {}", (Object)Float.valueOf(newDamage), (Object)player);
            event.setAmount(newDamage);
            ((AllomancerData)data).setDamageStored(((AllomancerData)data).getDamageStored() + 2);
            AllomancerAttachment.sync((Player)player);
        }
    }

    @SubscribeEvent
    public static void onInvulnerabilityCheck(EntityInvulnerabilityCheckEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            AllomancerData data = AllomancerAttachment.get((Player)player);
            if (data.isBurning(Metal.PEWTER) && data.isEnhanced()) {
                Allomancy.LOGGER.debug("Canceling damage for {}", (Object)player);
                event.setInvulnerable(true);
            }
            if (data.isBurning(Metal.STEEL) && event.getSource().type().equals(player.level().registryAccess().lookupOrThrow(Registries.DAMAGE_TYPE).getOrThrow(DamageTypes.FALL).value())) {
                BlockPos on = player.getOnPos();
                if (Physical.isBlockStateMetallic(player.level().getBlockState(on)) || Physical.isBlockStateMetallic(player.level().getBlockState(on.above()))) {
                    event.setInvulnerable(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onWorldTick(LevelTickEvent.Post event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)level;
            List list = l.players();
            for (int i = list.size() - 1; i >= 0; --i) {
                ServerPlayer curPlayer = (ServerPlayer)list.get(i);
                CommonEventHandler.playerPowerTick(curPlayer, l);
            }
        }
    }

    private static void playerPowerTick(ServerPlayer curPlayer, ServerLevel level) {
        AllomancerData data = AllomancerAttachment.get((Player)curPlayer);
        boolean syncRequired = data.tickBurning();
        if (curPlayer.getItemBySlot(EquipmentSlot.HEAD).is(AllomancyTags.SPECIAL_EARRINGS)) {
            BlockPos raised;
            GlobalPos seeking = data.getSpecialSeekingLoc();
            if (seeking == null) {
                BlockPos blockpos = level.findNearestMapStructure(AllomancyTags.SEEKABLE, curPlayer.blockPosition(), 100, false);
                if (blockpos != null) {
                    data.setSpecialSeekingLoc(blockpos, (ResourceKey<Level>)curPlayer.level().dimension());
                    syncRequired = true;
                }
            } else if (level.isLoaded(seeking.pos()) && (raised = level.getHeightmapPos(Heightmap.Types.WORLD_SURFACE, seeking.pos()).below(18)) != seeking.pos()) {
                data.setSpecialSeekingLoc(raised, (ResourceKey<Level>)seeking.dimension());
                syncRequired = true;
            }
        } else {
            syncRequired = syncRequired || data.getSpecialSeekingLoc() != null;
            data.setSpecialSeekingLoc(null, null);
        }
        if (!data.isUninvested()) {
            if (data.isBurning(Metal.ALUMINUM)) {
                Enhancement.wipePlayer(curPlayer);
                syncRequired = true;
            }
            if (data.isBurning(Metal.DURALUMIN) && !data.isEnhanced()) {
                data.setEnhanced(2);
                Network.sync(new EnhanceTimePayload(2, curPlayer.getUUID()), curPlayer);
            } else if (!data.isBurning(Metal.DURALUMIN) && data.isEnhanced()) {
                data.decrementEnhanced();
                if (!data.isEnhanced()) {
                    data.drainMetals((Metal[])Arrays.stream(Metal.values()).filter(data::isBurning).toArray(Metal[]::new));
                    syncRequired = true;
                }
            }
            if (data.isEnhanced() && data.isBurning(Metal.CHROMIUM)) {
                Enhancement.wipeNearby(curPlayer, level);
            }
            if (data.isEnhanced() && data.isBurning(Metal.ELECTRUM) && data.getStored(Metal.ELECTRUM) >= 9) {
                Enhancement.teleportToSpawn(curPlayer, level, data);
                syncRequired = true;
            } else if (data.isEnhanced() && data.isBurning(Metal.GOLD) && data.getStored(Metal.GOLD) >= 9) {
                Enhancement.teleportToLastDeath(curPlayer, level, data);
                syncRequired = true;
            }
            if (data.isBurning(Metal.BENDALLOY) && !data.isBurning(Metal.CADMIUM)) {
                Temporal.speedUpNearby(curPlayer, level, data);
            }
            if (data.isBurning(Metal.CADMIUM) && !data.isBurning(Metal.BENDALLOY)) {
                Temporal.slowDownNearby(curPlayer, level, data);
            }
            if (data.isBurning(Metal.TIN)) {
                curPlayer.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, -1, 5, true, false));
                if (data.isEnhanced() && level.random.nextInt(50) == 0) {
                    curPlayer.addEffect(new MobEffectInstance(MobEffects.NAUSEA, 100, 0, true, false));
                }
                if (curPlayer.hasEffect(MobEffects.BLINDNESS)) {
                    curPlayer.removeEffect(MobEffects.BLINDNESS);
                }
            }
            if (!data.isBurning(Metal.TIN) && curPlayer.getEffect(MobEffects.NIGHT_VISION) != null && curPlayer.getEffect(MobEffects.NIGHT_VISION).getAmplifier() == 5) {
                curPlayer.removeEffect(MobEffects.NIGHT_VISION);
            }
            if (data.isBurning(Metal.PEWTER)) {
                curPlayer.addEffect(new MobEffectInstance(MobEffects.JUMP_BOOST, 11, 1, true, false));
                curPlayer.addEffect(new MobEffectInstance(MobEffects.SPEED, 11, 0, true, false));
                curPlayer.addEffect(new MobEffectInstance(MobEffects.HASTE, 11, 1, true, false));
                if (data.getDamageStored() > 0 && level.random.nextInt(200) == 0) {
                    data.setDamageStored(data.getDamageStored() - 1);
                }
            }
            if (!data.isBurning(Metal.PEWTER) && data.getDamageStored() > 0) {
                data.setDamageStored(data.getDamageStored() - 1);
                curPlayer.hurtServer(level, level.damageSources().magic(), 2.0f);
            }
            if (data.isEnhanced() && data.isBurning(Metal.COPPER)) {
                curPlayer.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, 20, 50, true, false));
            }
        }
        if (syncRequired) {
            AllomancerAttachment.sync((Player)curPlayer);
        }
    }
}

