/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.powers.client.gui;

import com.legobmw99.allomancy.Allomancy;
import com.legobmw99.allomancy.api.enums.Metal;
import com.legobmw99.allomancy.modules.powers.PowersConfig;
import com.legobmw99.allomancy.modules.powers.client.gui.MetalSelectScreen;
import com.legobmw99.allomancy.modules.powers.data.AllomancerAttachment;
import com.legobmw99.allomancy.modules.powers.data.AllomancerData;
import java.awt.Point;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.gui.GuiLayer;

public final class MetalOverlay
implements GuiLayer {
    private static final ResourceLocation METER_TEXTURE = Allomancy.rl("textures/gui/overlay/meter.png");
    private static final int OUTLINE_COLOR = ARGB.color((int)101, (int)101, (int)101);
    private static final Point[] BURNING_FRAMES = new Point[4];
    private int currentFrame = 0;

    private MetalOverlay() {
    }

    public static void registerGUI(RegisterGuiLayersEvent evt) {
        evt.registerAboveAll(Allomancy.rl("metal_display"), (GuiLayer)new MetalOverlay());
    }

    private static void blit(GuiGraphics graphics, int x, int y, float uOffset, float vOffset, int uWidth, int vHeight) {
        graphics.blit(RenderPipelines.GUI_TEXTURED, METER_TEXTURE, x, y, uOffset, vOffset, uWidth, vHeight, uWidth, vHeight, 128, 128);
    }

    public void render(GuiGraphics gui, DeltaTracker deltaTracker) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (mc.options.hideGui || !player.isAlive()) {
            return;
        }
        if (!((Boolean)PowersConfig.enable_overlay.get()).booleanValue() && !(mc.screen instanceof MetalSelectScreen)) {
            return;
        }
        AllomancerData data = AllomancerAttachment.get((Player)player);
        if (data.isUninvested()) {
            return;
        }
        Metal highlight = null;
        Screen screen = mc.screen;
        if (screen instanceof MetalSelectScreen) {
            MetalSelectScreen select = (MetalSelectScreen)screen;
            highlight = select.selectedMetal;
        }
        int renderX = ((SCREEN_LOC)((Object)PowersConfig.overlay_position.get())).getX(gui.guiWidth());
        int renderY = ((SCREEN_LOC)((Object)PowersConfig.overlay_position.get())).getY(gui.guiHeight());
        for (Metal mt : Metal.values()) {
            if (!data.hasPower(mt)) continue;
            int metalY = 9 - data.getStored(mt);
            int i = mt.getIndex();
            int offset = i / 2 * 4;
            int xCorner = renderX + 7 * i + offset;
            MetalOverlay.blit(gui, xCorner + 1, renderY + 5 + metalY, 7 + 6 * i, 1 + metalY, 3, 10 - metalY);
            MetalOverlay.blit(gui, xCorner, renderY, 0.0f, 0.0f, 5, 20);
            if (data.isBurning(mt)) {
                int frameCount = (this.currentFrame + i) % 4;
                Point frame = BURNING_FRAMES[frameCount];
                MetalOverlay.blit(gui, xCorner, renderY + 4 + metalY, frame.x, frame.y, 5, 3);
            }
            if (highlight != mt) continue;
            gui.renderOutline(xCorner - 1, renderY - 1, 7, 21, OUTLINE_COLOR);
        }
        if (mc.gui.getGuiTicks() % 6 == 0) {
            ++this.currentFrame;
            if (this.currentFrame > 3) {
                this.currentFrame = 0;
            }
        }
    }

    static {
        int x = 0;
        int firsty = 22;
        for (int i = 0; i < 4; ++i) {
            MetalOverlay.BURNING_FRAMES[i] = new Point(x, firsty + 4 * i);
        }
    }

    public static enum SCREEN_LOC {
        TOP_RIGHT,
        BOTTOM_RIGHT,
        TOP_LEFT,
        BOTTOM_LEFT;


        private int getX(int screenWidth) {
            return switch (this.ordinal()) {
                case 0, 1 -> screenWidth - 145;
                default -> 5;
            };
        }

        private int getY(int screenHeight) {
            return switch (this.ordinal()) {
                case 1, 3 -> screenHeight - 50;
                default -> 10;
            };
        }
    }
}

