/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.powers.client.network;

import com.legobmw99.allomancy.api.data.IAllomancerData;
import com.legobmw99.allomancy.api.enums.Metal;
import com.legobmw99.allomancy.modules.combat.CombatSetup;
import com.legobmw99.allomancy.modules.powers.client.util.Sounds;
import com.legobmw99.allomancy.modules.powers.network.BlockPushPullPayload;
import com.legobmw99.allomancy.modules.powers.network.EmotionPayload;
import com.legobmw99.allomancy.modules.powers.network.EnhanceTimePayload;
import com.legobmw99.allomancy.modules.powers.network.EntityPushPullPayload;
import com.legobmw99.allomancy.modules.powers.network.ToggleBurnPayload;
import com.legobmw99.allomancy.modules.powers.util.Physical;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public final class PowerRequests {
    private PowerRequests() {
    }

    public static void toggleBurn(Metal metal, IAllomancerData data) {
        if (!data.hasPower(metal)) {
            return;
        }
        if (data.getStored(metal) > 0) {
            data.setBurning(metal, !data.isBurning(metal));
            PowerRequests.sendToServer(new ToggleBurnPayload(metal, data.isBurning(metal)));
        }
        Sounds.soundForBurnChange(data.isBurning(metal));
    }

    public static void emotionPushPull(IAllomancerData data, HitResult trace, Metal metal) {
        Entity entity;
        boolean aggro;
        if (!data.isBurning(metal) || trace == null) {
            return;
        }
        boolean bl = aggro = metal == Metal.ZINC;
        if (trace.getType() == HitResult.Type.ENTITY && (entity = ((EntityHitResult)trace).getEntity()) instanceof PathfinderMob) {
            PowerRequests.sendToServer(new EmotionPayload(entity.getId(), aggro));
        }
    }

    public static void metallicPushPull(IAllomancerData data, HitResult trace, Metal metal) {
        if (!data.isBurning(metal) || trace == null) {
            return;
        }
        int force = (data.isEnhanced() ? 4 : 1) * (metal == Metal.STEEL ? 1 : -1);
        HitResult hitResult = trace;
        Objects.requireNonNull(hitResult);
        HitResult hitResult2 = hitResult;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EntityHitResult.class, BlockHitResult.class}, (Object)hitResult2, n)) {
            case 0: {
                EntityHitResult e = (EntityHitResult)hitResult2;
                if (!Physical.isEntityMetallic(e.getEntity())) break;
                PowerRequests.sendToServer(new EntityPushPullPayload(e.getEntity().getId(), force));
                break;
            }
            case 1: {
                BlockHitResult b = (BlockHitResult)hitResult2;
                BlockPos bp = b.getBlockPos();
                LocalPlayer player = Minecraft.getInstance().player;
                BlockState state = player.level().getBlockState(bp);
                if (!Physical.isBlockStateMetallic(state) && (state.isAir() || !player.isCrouching() || metal != Metal.STEEL || player.getMainHandItem().getItem() != CombatSetup.COIN_BAG.get() || player.getProjectile(player.getMainHandItem()).isEmpty())) break;
                PowerRequests.sendToServer(new BlockPushPullPayload(bp, force));
                break;
            }
        }
    }

    public static void nicrosilEnhance(IAllomancerData data, HitResult trace) {
        Entity entity;
        if (data.isBurning(Metal.NICROSIL) && trace != null && trace.getType() == HitResult.Type.ENTITY && (entity = ((EntityHitResult)trace).getEntity()) instanceof Player) {
            Player p = (Player)entity;
            PowerRequests.sendToServer(new EnhanceTimePayload(true, p.getUUID()));
        }
    }

    private static void sendToServer(CustomPacketPayload msg) {
        ClientPacketDistributor.sendToServer((CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

