/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.powers.client.particle;

import com.legobmw99.allomancy.modules.powers.client.particle.SoundParticleData;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;

public final class SoundParticle
extends TextureSheetParticle {
    private SoundParticle(Level world, double x, double y, double z, double motionX, double motionY, double motionZ, SoundSource typeIn) {
        super((ClientLevel)world, x, y, z, motionX, motionY, motionZ);
        this.xd = motionX;
        this.yd = motionY + 0.009;
        this.zd = motionZ;
        this.quadSize *= 1.5f;
        this.hasPhysics = false;
        this.setAlpha(1.0f);
        this.setLifetime(20);
        switch (typeIn) {
            case HOSTILE: {
                this.setColor(1.0f, 0.15f, 0.15f);
                break;
            }
            case PLAYERS: {
                this.setColor(1.0f, 1.0f, 0.0f);
                break;
            }
            case NEUTRAL: {
                this.setColor(0.0f, 1.0f, 0.0f);
                break;
            }
            default: {
                this.setColor(0.0f, 0.0f, 1.0f);
            }
        }
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age >= this.lifetime) {
            this.remove();
        } else {
            this.move(this.xd, this.yd, this.zd);
        }
        ++this.age;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public static class Factory
    implements ParticleProvider.Sprite<SoundParticleData> {
        public TextureSheetParticle createParticle(SoundParticleData data, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new SoundParticle((Level)worldIn, x, y, z, xSpeed, ySpeed, zSpeed, data.getSoundType());
        }
    }
}

