/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.powers.client.util;

import com.legobmw99.allomancy.api.enums.Metal;
import com.legobmw99.allomancy.modules.powers.PowersConfig;
import com.legobmw99.allomancy.modules.powers.client.gui.MetalSelectScreen;
import com.legobmw99.allomancy.modules.powers.client.network.PowerRequests;
import com.legobmw99.allomancy.modules.powers.data.AllomancerAttachment;
import com.legobmw99.allomancy.modules.powers.data.AllomancerData;
import com.mojang.blaze3d.platform.InputConstants;
import javax.annotation.Nullable;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.ClientInput;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Input;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import org.lwjgl.glfw.GLFW;

public final class Inputs {
    private static KeyMapping hud;
    public static KeyMapping burn;
    private static KeyMapping[] powers;

    private Inputs() {
    }

    @Nullable
    public static HitResult getMouseOverExtended(float dist) {
        Minecraft mc = Minecraft.getInstance();
        float partialTicks = mc.getDeltaTracker().getGameTimeDeltaPartialTick(false);
        HitResult objectMouseOver = null;
        Entity entity = mc.getCameraEntity();
        if (entity != null && mc.level != null) {
            Vec3 vec3d3;
            double d2;
            AABB axisalignedbb;
            objectMouseOver = entity.pick((double)dist, partialTicks, false);
            Vec3 vec3d = entity.getEyePosition(partialTicks);
            double d1 = objectMouseOver.getLocation().distanceToSqr(vec3d);
            Vec3 vec3d1 = entity.getViewVector(1.0f);
            Vec3 vec3d2 = vec3d.add(vec3d1.x * (double)dist, vec3d1.y * (double)dist, vec3d1.z * (double)dist);
            EntityHitResult entityraytraceresult = ProjectileUtil.getEntityHitResult((Entity)entity, (Vec3)vec3d, (Vec3)vec3d2, (AABB)(axisalignedbb = entity.getBoundingBox().expandTowards(vec3d1.scale((double)dist)).inflate(1.0, 1.0, 1.0)), e -> true, (double)d1);
            if (entityraytraceresult != null && (d2 = vec3d.distanceToSqr(vec3d3 = entityraytraceresult.getLocation())) < d1) {
                objectMouseOver = entityraytraceresult;
            }
        }
        return objectMouseOver;
    }

    public static void registerKeyBinding(RegisterKeyMappingsEvent evt) {
        burn = new KeyMapping("key.burn", 86, "key.categories.allomancy");
        hud = new KeyMapping("key.hud", -1, "key.categories.allomancy");
        evt.register(burn);
        evt.register(hud);
        powers = new KeyMapping[Metal.values().length];
        for (int i = 0; i < powers.length; ++i) {
            Inputs.powers[i] = new KeyMapping("key.metals." + Metal.getMetal(i).name().toLowerCase(), -1, "key.categories.allomancy");
            evt.register(powers[i]);
        }
    }

    public static void acceptAllomancyKeybinds() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.screen != null) {
            return;
        }
        LocalPlayer player = mc.player;
        if (player == null || !mc.isWindowActive()) {
            return;
        }
        if (Inputs.isKeyDown(hud)) {
            PowersConfig.enable_overlay.set((Object)((Boolean)PowersConfig.enable_overlay.get() == false ? 1 : 0));
            return;
        }
        AllomancerData data = AllomancerAttachment.get((Player)player);
        for (int i = 0; i < powers.length; ++i) {
            if (!Inputs.isKeyDown(powers[i])) continue;
            PowerRequests.toggleBurn(Metal.getMetal(i), data);
        }
        if (Inputs.isKeyDown(burn)) {
            switch (data.getPowerCount()) {
                case 0: {
                    break;
                }
                case 1: {
                    PowerRequests.toggleBurn(data.getPowers()[0], data);
                    break;
                }
                default: {
                    mc.setScreen((Screen)new MetalSelectScreen());
                }
            }
        }
    }

    private static float calculateImpulse(boolean input, boolean otherInput) {
        if (input == otherInput) {
            return 0.0f;
        }
        return input ? 1.0f : -1.0f;
    }

    private static boolean isKeyDown0(KeyMapping keybind) {
        if (keybind.isUnbound()) {
            return false;
        }
        return switch (keybind.getKey().getType()) {
            case InputConstants.Type.KEYSYM -> InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)keybind.getKey().getValue());
            case InputConstants.Type.MOUSE -> {
                if (GLFW.glfwGetMouseButton((long)Minecraft.getInstance().getWindow().getWindow(), (int)keybind.getKey().getValue()) == 1) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private static boolean isKeyDown(KeyMapping keybind) {
        return Inputs.isKeyDown0(keybind) && keybind.getKeyConflictContext().isActive() && keybind.getKeyModifier().isActive(keybind.getKeyConflictContext());
    }

    public static void fakeMovement(ClientInput input) {
        Options settings = Minecraft.getInstance().options;
        input.keyPresses = new Input(Inputs.isKeyDown0(settings.keyUp), Inputs.isKeyDown0(settings.keyDown), Inputs.isKeyDown0(settings.keyLeft), Inputs.isKeyDown0(settings.keyRight), Inputs.isKeyDown0(settings.keyJump), Inputs.isKeyDown0(settings.keyShift), Inputs.isKeyDown0(settings.keySprint));
        float forward = Inputs.calculateImpulse(input.keyPresses.forward(), input.keyPresses.backward());
        float left = Inputs.calculateImpulse(input.keyPresses.left(), input.keyPresses.right());
        LocalPlayer player = Minecraft.getInstance().player;
        if (player.isMovingSlowly()) {
            forward = (float)((double)forward * 0.3);
            left = (float)((double)left * 0.3);
        }
        input.moveVector = new Vec2(left, forward).normalized();
        if (!player.isSprinting() && (!player.isInWater() && !player.isInFluidType((fluidType, height) -> player.canSwimInFluidType(fluidType)) || player.isUnderWater() || player.canStartSwimming()) && (double)forward >= 0.8 && !player.isUsingItem() && ((float)player.getFoodData().getFoodLevel() > 6.0f || player.mayFly()) && !player.hasEffect(MobEffects.BLINDNESS) && Inputs.isKeyDown0(settings.keySprint)) {
            player.setSprinting(true);
        }
    }
}

