/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.powers.client.util;

import com.legobmw99.allomancy.api.data.IAllomancerData;
import com.legobmw99.allomancy.api.enums.Metal;
import com.legobmw99.allomancy.modules.powers.PowersConfig;
import com.legobmw99.allomancy.modules.powers.data.AllomancerAttachment;
import com.legobmw99.allomancy.modules.powers.data.AllomancerData;
import com.legobmw99.allomancy.modules.powers.util.Physical;
import com.legobmw99.allomancy.util.DoubleBufferList;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Tracking {
    private final List<Entity> metal_entities = new ArrayList<Entity>();
    private final DoubleBufferList<MetalBlockBlob> metal_blobs = new DoubleBufferList();
    private final List<Player> nearby_allomancers = new ArrayList<Player>();
    private final Deque<BlockPos> to_consider = new ArrayDeque<BlockPos>(400);
    private final Set<Long> seen = new LongOpenHashSet(400);
    private Future<?> blobFuture = null;

    public void forEachSeeked(Consumer<Player> f) {
        this.nearby_allomancers.forEach(f);
    }

    public void forEachMetallicEntity(Consumer<Entity> f) {
        this.metal_entities.forEach(f);
    }

    public void forEachMetalBlob(Consumer<MetalBlockBlob> f) {
        this.metal_blobs.forEach(f);
    }

    public void tick() {
        LocalPlayer player = Minecraft.getInstance().player;
        AllomancerData data = AllomancerAttachment.get((Player)player);
        if (data.isBurning(Metal.IRON) || data.isBurning(Metal.STEEL)) {
            int max = (Integer)PowersConfig.max_metal_detection.get();
            BlockPos negative = player.blockPosition().offset(-max, -max, -max);
            BlockPos positive = player.blockPosition().offset(max, max, max);
            this.metal_entities.clear();
            this.metal_entities.addAll(player.level().getEntitiesOfClass(Entity.class, AABB.encapsulatingFullBlocks((BlockPos)negative, (BlockPos)positive), arg_0 -> Tracking.lambda$tick$0((Player)player, arg_0)));
            if (this.blobFuture == null || this.blobFuture.isDone()) {
                this.blobFuture = Util.backgroundExecutor().service().submit(() -> this.lambda$tick$2(negative, positive, (Player)player, max));
            }
        } else if (this.blobFuture != null) {
            this.blobFuture = null;
            this.metal_blobs.clearBothAsync(Util.backgroundExecutor().service());
            this.metal_entities.clear();
        }
        this.nearby_allomancers.clear();
        if (data.isBurning(Metal.BRONZE) && (data.isEnhanced() || !data.isBurning(Metal.COPPER))) {
            Vec3 negative = player.position().add(-30.0, -30.0, -30.0);
            Vec3 positive = player.position().add(30.0, 30.0, 30.0);
            List nearby_players = player.level().getEntitiesOfClass(Player.class, new AABB(negative, positive), arg_0 -> Tracking.lambda$tick$3((Player)player, arg_0));
            for (Player otherPlayer : nearby_players) {
                if (this.seek(data, otherPlayer)) continue;
                this.nearby_allomancers.clear();
                break;
            }
        }
    }

    private void searchNearbyMetalBlocks(BlockPos origin, int range, BlockPos starter, Level level) {
        BlockState starterState = level.getBlockState(starter);
        if (!this.seen.add(starter.asLong()) || !Physical.isBlockStateMetallic(starterState)) {
            return;
        }
        MetalBlockBlob blob = new MetalBlockBlob(starter, starterState);
        int range_sqr = 4 * range * range;
        this.to_consider.clear();
        this.to_consider.addFirst(starter);
        while (!this.to_consider.isEmpty()) {
            BlockPos pos = this.to_consider.removeLast();
            for (BlockPos next : BlockPos.withinManhattan((BlockPos)pos, (int)1, (int)1, (int)1)) {
                BlockState nextState;
                if (!this.seen.add(next.asLong()) || !(origin.distToCenterSqr((Position)next.getCenter()) < (double)range_sqr) || !Physical.isBlockStateMetallic(nextState = level.getBlockState(next))) continue;
                blob.add(next, nextState);
                this.to_consider.add(next.immutable());
            }
        }
        this.metal_blobs.add(blob);
    }

    private boolean seek(IAllomancerData data, Player otherPlayer) {
        AllomancerData otherData = AllomancerAttachment.get(otherPlayer);
        if (otherData.isBurning(Metal.COPPER) && (!data.isEnhanced() || otherData.isEnhanced())) {
            return false;
        }
        if (Arrays.stream(Metal.values()).anyMatch(otherData::isBurning)) {
            this.nearby_allomancers.add(otherPlayer);
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$tick$3(Player player, Player entity) {
        return entity != null && entity != player;
    }

    private /* synthetic */ void lambda$tick$2(BlockPos negative, BlockPos positive, Player player, int max) {
        this.seen.clear();
        BlockPos.betweenClosed((int)negative.getX(), (int)negative.getY(), (int)negative.getZ(), (int)positive.getX(), (int)positive.getY(), (int)positive.getZ()).forEach(starter -> this.searchNearbyMetalBlocks(player.blockPosition(), max, (BlockPos)starter, player.level()));
        this.metal_blobs.commitAndClear();
    }

    private static /* synthetic */ boolean lambda$tick$0(Player player, Entity e) {
        return Physical.isEntityMetallic(e) && !e.equals((Object)player);
    }

    public static final class MetalBlockBlob {
        private static final Level level = Minecraft.getInstance().level;
        private int blocks = 1;
        private Vec3 center;

        private MetalBlockBlob(BlockPos initial, BlockState initialState) {
            this.center = MetalBlockBlob.getCenterOfBlock(initial, initialState);
        }

        private static Vec3 getCenterOfBlock(BlockPos pos, BlockState state) {
            VoxelShape shape = state.getShape((BlockGetter)level, pos);
            if (shape.isEmpty()) {
                return Vec3.atCenterOf((Vec3i)pos);
            }
            return Vec3.atLowerCornerOf((Vec3i)pos).add(shape.bounds().getCenter());
        }

        public int size() {
            return this.blocks;
        }

        private void add(BlockPos pos, BlockState state) {
            ++this.blocks;
            this.center = this.center.add(MetalBlockBlob.getCenterOfBlock(pos, state).subtract(this.center).scale(1.0 / (double)this.blocks));
        }

        public Vec3 getCenter() {
            return this.center;
        }

        public String toString() {
            return "MetalBlockBlob{blocks=" + this.blocks + ", center=" + String.valueOf(this.center) + "}";
        }
    }
}

