/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.powers.entity.ai;

import java.util.EnumSet;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;

public class AIAttackOnCollideExtended
extends Goal {
    private final PathfinderMob attacker;
    private final double speedTowardsTarget;
    private final boolean longMemory;
    private int attackTick;
    private Path entityPathEntity;
    private int ticksUntilNextPathRecalculation;
    private int failedPathFindingPenalty;

    public AIAttackOnCollideExtended(PathfinderMob par1EntityCreature, double par2, boolean par4) {
        this.attacker = par1EntityCreature;
        this.speedTowardsTarget = par2;
        this.longMemory = par4;
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean canUse() {
        LivingEntity livingEntity = this.attacker.getTarget();
        if (livingEntity == null) {
            return false;
        }
        if (!livingEntity.isAlive()) {
            return false;
        }
        --this.ticksUntilNextPathRecalculation;
        if (this.ticksUntilNextPathRecalculation <= 0) {
            this.entityPathEntity = this.attacker.getNavigation().createPath((Entity)livingEntity, 0);
            this.ticksUntilNextPathRecalculation = 4 + this.attacker.getRandom().nextInt(7);
            return this.entityPathEntity != null;
        }
        return true;
    }

    public boolean canContinueToUse() {
        LivingEntity livingEntity = this.attacker.getTarget();
        if (livingEntity == null) {
            return false;
        }
        return livingEntity.isAlive() && (!this.longMemory ? !this.attacker.getNavigation().isDone() : this.attacker.isWithinMeleeAttackRange(livingEntity));
    }

    public void start() {
        this.attacker.getNavigation().moveTo(this.entityPathEntity, this.speedTowardsTarget);
        this.ticksUntilNextPathRecalculation = 0;
    }

    public void stop() {
        this.attacker.getNavigation().stop();
    }

    public void tick() {
        LivingEntity livingEntity = this.attacker.getTarget();
        if (livingEntity == null) {
            return;
        }
        this.attacker.getLookControl().setLookAt((Entity)livingEntity, 30.0f, 30.0f);
        if (this.longMemory || this.attacker.getSensing().hasLineOfSight((Entity)livingEntity)) {
            --this.ticksUntilNextPathRecalculation;
            if (this.ticksUntilNextPathRecalculation <= 0) {
                Node finalPathPoint;
                this.ticksUntilNextPathRecalculation = this.failedPathFindingPenalty + 4 + this.attacker.getRandom().nextInt(7);
                this.attacker.getNavigation().moveTo((Entity)livingEntity, this.speedTowardsTarget);
                this.failedPathFindingPenalty = this.attacker.getNavigation().getPath() != null ? ((finalPathPoint = this.attacker.getNavigation().getPath().getEndNode()) != null && livingEntity.distanceToSqr((double)finalPathPoint.x, (double)finalPathPoint.y, (double)finalPathPoint.z) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
            }
        }
        this.attackTick = Math.max(this.attackTick - 1, 0);
        double d0 = this.attacker.getBbWidth() * 2.0f * this.attacker.getBbWidth() * 2.0f + livingEntity.getBbWidth();
        if (this.attacker.distanceToSqr((Entity)livingEntity) <= d0 && this.attackTick <= 0) {
            this.attackTick = 20;
            if (!this.attacker.getMainHandItem().isEmpty()) {
                this.attacker.swing(InteractionHand.MAIN_HAND);
            }
            if (this.attacker instanceof Monster) {
                this.attacker.doHurtTarget(AIAttackOnCollideExtended.getServerLevel((Entity)livingEntity), (Entity)livingEntity);
            } else {
                livingEntity.hurt(livingEntity.level().damageSources().mobAttack((LivingEntity)this.attacker), 3.0f);
            }
        }
    }
}

